/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabricationClientCommands;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.features.FeatureTaggablePlayers;
import com.unascribed.fabrication.interfaces.TaggablePlayer;
import com.unascribed.fabrication.loaders.LoaderFScript;
import com.unascribed.fabrication.support.ConfigValues;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.OptionalFScript;
import com.unascribed.fabrication.util.Cardinal;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7138;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class FeatureFabricationCommand
implements Feature {
    @Override
    public void apply() {
        Agnos.runForCommandRegistration((dispatcher, registryAccess, dedi) -> {
            try {
                LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)MixinConfigPlugin.MOD_NAME_LOWER);
                FeatureFabricationCommand.addConfig(root, dedi);
                if (EarlyAgnos.isModLoaded("fscript")) {
                    FeatureFabricationCommand.addFScript(root, dedi);
                }
                LiteralArgumentBuilder tag = LiteralArgumentBuilder.literal((String)"tag");
                tag.requires(scs -> FabConf.isEnabled("*.taggable_players") && scs.method_9259(2));
                LiteralArgumentBuilder add = LiteralArgumentBuilder.literal((String)"add");
                LiteralArgumentBuilder remove = LiteralArgumentBuilder.literal((String)"remove");
                LiteralArgumentBuilder get = LiteralArgumentBuilder.literal((String)"get");
                LiteralArgumentBuilder clear = LiteralArgumentBuilder.literal((String)"clear");
                LiteralArgumentBuilder push = LiteralArgumentBuilder.literal((String)"push");
                LiteralArgumentBuilder pull = LiteralArgumentBuilder.literal((String)"pull");
                for (String key : FeatureTaggablePlayers.validTags.keySet()) {
                    LiteralArgumentBuilder literalKey = class_2170.method_9247((String)key);
                    RequiredArgumentBuilder playerParameter = (RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(c -> this.addTag((CommandContext<class_2168>)c, class_2186.method_9312((CommandContext)c, (String)"players"), key));
                    ((LiteralArgumentBuilder)literalKey.executes(c -> this.addTag((CommandContext<class_2168>)c, Collections.singleton(((class_2168)c.getSource()).method_9207()), key))).then((ArgumentBuilder)playerParameter);
                    add.then((ArgumentBuilder)literalKey);
                    FeatureFabricationCommand.setAltKeys(key, alt -> add.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alt).executes(literalKey.getCommand())).then((ArgumentBuilder)playerParameter)));
                    literalKey = class_2170.method_9247((String)key);
                    playerParameter = (RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(c -> this.removeTag((CommandContext<class_2168>)c, class_2186.method_9312((CommandContext)c, (String)"players"), key));
                    ((LiteralArgumentBuilder)literalKey.executes(c -> this.removeTag((CommandContext<class_2168>)c, Collections.singleton(((class_2168)c.getSource()).method_9207()), key))).then((ArgumentBuilder)playerParameter);
                    remove.then((ArgumentBuilder)literalKey);
                    FeatureFabricationCommand.setAltKeys(key, alt -> remove.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alt).executes(literalKey.getCommand())).then((ArgumentBuilder)playerParameter)));
                    literalKey = class_2170.method_9247((String)key);
                    literalKey.executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0));
                    literalKey.then(class_2170.method_9247((String)"0").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0)));
                    literalKey.then(class_2170.method_9247((String)"1").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 1)));
                    literalKey.then(class_2170.method_9247((String)"2").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 2)));
                    literalKey.then(class_2170.method_9247((String)"3").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 3)));
                    literalKey.then(class_2170.method_9247((String)"tagged_players_only").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0)));
                    literalKey.then(class_2170.method_9247((String)"untagged_players_only").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 1)));
                    literalKey.then(class_2170.method_9247((String)"tagged_players").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 2)));
                    literalKey.then(class_2170.method_9247((String)"untagged_players").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 3)));
                    push.then((ArgumentBuilder)literalKey);
                    FeatureFabricationCommand.setAltKeys(key, alt -> {
                        LiteralArgumentBuilder literalKey = class_2170.method_9247((String)alt);
                        literalKey.executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0));
                        literalKey.then(class_2170.method_9247((String)"0").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0)));
                        literalKey.then(class_2170.method_9247((String)"1").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 1)));
                        literalKey.then(class_2170.method_9247((String)"2").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 2)));
                        literalKey.then(class_2170.method_9247((String)"3").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 3)));
                        literalKey.then(class_2170.method_9247((String)"tagged_players_only").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0)));
                        literalKey.then(class_2170.method_9247((String)"untagged_players_only").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 1)));
                        literalKey.then(class_2170.method_9247((String)"tagged_players").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 2)));
                        literalKey.then(class_2170.method_9247((String)"untagged_players").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 3)));
                        push.then((ArgumentBuilder)literalKey);
                    });
                    literalKey = class_2170.method_9247((String)key);
                    literalKey.executes(c -> {
                        ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("TaggablePlayers removed " + key)), true);
                        FeatureTaggablePlayers.remove(key);
                        return 1;
                    });
                    pull.then((ArgumentBuilder)literalKey);
                    FeatureFabricationCommand.setAltKeys(key, alt -> pull.then(LiteralArgumentBuilder.literal((String)alt).executes(literalKey.getCommand())));
                }
                ((LiteralArgumentBuilder)get.executes(c -> this.getTags((CommandContext<class_2168>)c, ((class_2168)c.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> this.getTags((CommandContext<class_2168>)c, class_2186.method_9315((CommandContext)c, (String)"player"))));
                ((LiteralArgumentBuilder)clear.executes(c -> this.clearTags((CommandContext<class_2168>)c, Collections.singleton(((class_2168)c.getSource()).method_9207())))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(c -> this.clearTags((CommandContext<class_2168>)c, class_2186.method_9312((CommandContext)c, (String)"players"))));
                tag.then((ArgumentBuilder)add);
                tag.then((ArgumentBuilder)remove);
                tag.then((ArgumentBuilder)get);
                tag.then((ArgumentBuilder)clear);
                tag.then((ArgumentBuilder)push);
                tag.then((ArgumentBuilder)pull);
                root.then((ArgumentBuilder)tag);
                LiteralArgumentBuilder analyze = LiteralArgumentBuilder.literal((String)"analyze");
                analyze.requires(scs -> scs.method_9259(4));
                LiteralArgumentBuilder biome = class_2170.method_9247((String)"biome");
                registryAccess.method_41699(class_7924.field_41236).method_42017().forEach(optBiome -> {
                    Optional optKey = optBiome.method_40230();
                    if (optKey.isEmpty()) {
                        return;
                    }
                    class_2960 id = ((class_5321)optKey.get()).method_29177();
                    class_2960 b = ((class_5321)optKey.get()).method_29177();
                    Command exec = c -> {
                        class_1937 w;
                        HashSet set = Sets.newHashSet((Object[])new class_2960[]{b});
                        try {
                            c.getArgument("dimension", class_2960.class);
                            w = class_2181.method_9289((CommandContext)c, (String)"dimension");
                        }
                        catch (IllegalArgumentException e) {
                            w = ((class_2168)c.getSource()).method_9229().method_37908();
                        }
                        return this.analyzeBlockDistribution((CommandContext<class_2168>)c, w, set);
                    };
                    if (id.method_12836().equals("minecraft")) {
                        biome.then(class_2170.method_9247((String)id.method_12832()).executes(exec));
                    }
                    biome.then(class_2170.method_9247((String)id.toString()).executes(exec));
                });
                analyze.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"block_distribution").executes(c -> this.analyzeBlockDistribution((CommandContext<class_2168>)c, ((class_2168)c.getSource()).method_9229().method_37908(), null))).then((ArgumentBuilder)biome)).then(class_2170.method_9247((String)"in").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then((ArgumentBuilder)biome)).executes(c -> this.analyzeBlockDistribution((CommandContext<class_2168>)c, (class_1937)class_2181.method_9289((CommandContext)c, (String)"dimension"), null)))));
                root.then((ArgumentBuilder)analyze);
                dispatcher.register(root);
            }
            catch (Throwable t) {
                FabricationMod.featureError(this, t, "Unknown");
            }
        });
    }

    private static Command<class_2168> createPushTagCommandContextFor(String key, int type) {
        return c -> {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("TaggablePlayers added " + key)), true);
            FeatureTaggablePlayers.add(key, type);
            return 1;
        };
    }

    private int analyzeBlockDistribution(CommandContext<class_2168> c, class_1937 world, Set<class_2960> biomesIn) {
        HashSet biomes;
        if (biomesIn != null) {
            biomes = Sets.newHashSet();
            for (class_2960 b : biomesIn) {
                biomes.add((class_1959)((class_2168)c.getSource()).method_9211().method_30611().method_30530(class_7924.field_41236).method_10223(b));
            }
        } else {
            biomes = null;
        }
        String name = MixinConfigPlugin.MOD_NAME_LOWER + "_block_distribution_" + System.currentTimeMillis() + ".tsv";
        ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Starting background block distribution analysis"), false);
        ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"This could take a while, but the server should remain usable"), false);
        ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Once complete a file named " + name + " will appear in the server directory")), false);
        ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Progress reports will go to the console"), false);
        new Thread(() -> {
            class MutableLong {
                long value = 1L;

                MutableLong() {
                }
            }
            int x = 0;
            int z = 0;
            Cardinal dir = Cardinal.WEST;
            int legLength = 0;
            int i = 0;
            int j = 0;
            int scannedChunks = 0;
            long scanned = 0L;
            long skipped = 0L;
            long goal = (biomes == null ? 8000 : 1000) * 16 * 16 * world.method_31605();
            HashMap counts = Maps.newHashMap();
            block12: while (true) {
                class_2791 chunk;
                if ((chunk = world.method_8402(x, z, class_2806.field_12803, false)) == null) {
                    try {
                        int fx = x;
                        int fz = z;
                        chunk = (class_2791)world.method_8503().method_5385(() -> world.method_8402(fx, fz, class_2806.field_12803, true)).get();
                    }
                    catch (Exception e) {
                        FabLog.warn("Failed to generate chunk at " + x + ", " + z + " for block distribution analysis");
                    }
                }
                if (chunk != null) {
                    class_2791 e = chunk;
                    synchronized (e) {
                        for (int cY = 0; cY < chunk.method_31605(); ++cY) {
                            for (int cX = 0; cX < 16; ++cX) {
                                for (int cZ = 0; cZ < 16; ++cZ) {
                                    class_2826 section;
                                    if (biomes != null) {
                                        class_2794 generator = ((class_3218)world).method_14178().method_12129();
                                        class_7138 noiseConfig = ((class_3218)world).method_14178().method_41248();
                                        class_1959 b2 = (class_1959)generator.method_12098().method_38109(cX + chunk.method_12004().method_8326(), cY, cZ + chunk.method_12004().method_8328(), noiseConfig.method_42371()).comp_349();
                                        if (!biomes.contains(b2)) {
                                            if (++skipped <= goal || scanned != 0L) continue;
                                            FabLog.warn("We have skipped more blocks than our goal and found nothing matching the given biome. Giving up.");
                                            return;
                                        }
                                    }
                                    class_2680 state = (section = chunk.method_12006()[cY / 16]) != null ? section.method_12254(cX, cY % 16, cZ) : class_2246.field_10243.method_9564();
                                    counts.compute(state, (bs, ml) -> {
                                        if (ml == null) {
                                            return new MutableLong();
                                        }
                                        ++ml.value;
                                        return ml;
                                    });
                                    if (++scanned < goal) continue;
                                    break block12;
                                }
                            }
                        }
                    }
                    if (++scannedChunks % 20 == 0) {
                        FabLog.info("Scanned " + scanned + "/" + goal + " blocks... (skipped " + skipped + ") " + scanned * 100L / goal + "% done");
                    }
                }
                if (i >= legLength) {
                    dir = dir.ccw();
                    i = 0;
                    if (++j % 2 == 0) {
                        ++legLength;
                    }
                }
                x += dir.xOfs();
                z += dir.yOfs();
                ++i;
            }
            FabLog.info("Scanned " + scanned + "/" + goal + " blocks (skipped " + skipped + "), 100% done. Writing file");
            FabLog.info("NOTE: " + MixinConfigPlugin.MOD_NAME + " block distribution analysis is NOT A BENCHMARK. Chunk generation speed is intentionally limited to keep servers responsive and not crashing.");
            ArrayList sorted = Lists.newArrayList(counts.entrySet());
            sorted.sort((a, b) -> Long.compare(((MutableLong)b.getValue()).value, ((MutableLong)a.getValue()).value));
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(name)), Charsets.UTF_8);){
                osw.write("blockstate\tpercentage\r\n");
                BigDecimal scannedBD = new BigDecimal(scanned);
                BigDecimal hundred = new BigDecimal(100);
                for (Map.Entry en : sorted) {
                    osw.write(class_7923.field_41175.method_10221((Object)((class_2680)en.getKey()).method_26204()).toString().replace("\t", "    "));
                    if (!((class_2680)en.getKey()).method_11656().isEmpty()) {
                        osw.write("[");
                        boolean first = true;
                        for (Map.Entry stateEn : ((class_2680)en.getKey()).method_11656().entrySet()) {
                            if (first) {
                                first = false;
                            } else {
                                osw.write(",");
                            }
                            osw.write(((class_2769)stateEn.getKey()).method_11899().replace("\t", "    "));
                            osw.write("=");
                            osw.write(((class_2769)stateEn.getKey()).method_11901((Comparable)stateEn.getValue()).replace("\t", "    "));
                        }
                        osw.write("]");
                    }
                    osw.write("\t");
                    osw.write(new BigDecimal(((MutableLong)en.getValue()).value).divide(scannedBD, MathContext.DECIMAL64).multiply(hundred).toString());
                    osw.write("\r\n");
                }
                FabLog.info(name + " written to disk.");
            }
            catch (IOException e) {
                FabLog.error("Failed to save block distribution data", e);
            }
        }, MixinConfigPlugin.MOD_NAME + " block analysis").start();
        return 1;
    }

    public static <T extends class_2172> void addConfig(LiteralArgumentBuilder<T> root, boolean dediServer) {
        LiteralArgumentBuilder config = LiteralArgumentBuilder.literal((String)"config");
        Predicate<class_2172> permissionPredicate = s -> {
            class_1297 e;
            if (!(s instanceof class_2168)) {
                return true;
            }
            class_2168 scs = (class_2168)s;
            if (scs.method_9259(2)) {
                return true;
            }
            return scs.method_9211().method_3724() && scs.method_9228() != null && (e = scs.method_9228()) instanceof class_1657 && scs.method_9211().method_19466(((class_1657)e).method_7334());
        };
        LiteralArgumentBuilder get = LiteralArgumentBuilder.literal((String)"get");
        for (String s2 : FabConf.getAllKeys()) {
            LiteralArgumentBuilder key = LiteralArgumentBuilder.literal((String)s2);
            key.executes(c -> {
                String value = FabConf.getRawValue(s2);
                if (value.isEmpty()) {
                    value = "unset";
                }
                boolean def = FabConf.getDefault(s2);
                class_5250 txt = class_2561.method_43470((String)(s2 + " = " + value + " (default " + def + ")"));
                if (!FabConf.isEnabled(s2)) {
                    throw new class_2164((class_2561)txt.method_27692(class_124.field_1068));
                }
                FeatureFabricationCommand.sendFeedback((CommandContext<? extends class_2172>)c, txt, false);
                return 1;
            });
            get.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s2, alt -> get.then(LiteralArgumentBuilder.literal((String)alt).executes(key.getCommand())));
        }
        config.then((ArgumentBuilder)get);
        LiteralArgumentBuilder set = LiteralArgumentBuilder.literal((String)"set");
        for (String s3 : FabConf.getAllKeys()) {
            if (dediServer && FeaturesFile.get((String)s3).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = LiteralArgumentBuilder.literal((String)s3);
            String[] values = s3.startsWith("general.") ? (s3.startsWith("general.category") ? ConfigValues.Category.vals : ConfigValues.Feature.vals_true_false) : ConfigValues.Feature.vals_unset_true_false_banned;
            for (String v : values) {
                LiteralArgumentBuilder value = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)v).executes(c -> {
                    FeatureFabricationCommand.setKeyWithFeedback((CommandContext<? extends class_2172>)c, s3, v, false);
                    return 1;
                });
                key.then((ArgumentBuilder)value);
            }
            set.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s3, alt -> {
                LiteralArgumentBuilder short_key = LiteralArgumentBuilder.literal((String)alt);
                for (CommandNode arg : key.getArguments()) {
                    short_key.then(arg);
                }
                set.then((ArgumentBuilder)short_key);
            });
        }
        set.requires(permissionPredicate);
        config.then((ArgumentBuilder)set);
        LiteralArgumentBuilder setWorld = LiteralArgumentBuilder.literal((String)"setWorld");
        for (String s4 : FabConf.getAllKeys()) {
            String[] values;
            if (dediServer && FeaturesFile.get((String)s4).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = LiteralArgumentBuilder.literal((String)s4);
            if (s4.startsWith("general.")) {
                if (s4.startsWith("general.category")) continue;
                values = ConfigValues.Feature.vals_unset_true_false;
            } else {
                values = ConfigValues.Feature.vals_unset_true_false_banned;
            }
            for (String v : values) {
                key.then(LiteralArgumentBuilder.literal((String)v).executes(c -> {
                    FeatureFabricationCommand.setKeyWithFeedback((CommandContext<? extends class_2172>)c, s4, v, true);
                    return 1;
                }));
            }
            setWorld.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s4, alt -> {
                LiteralArgumentBuilder short_key = LiteralArgumentBuilder.literal((String)alt);
                for (CommandNode arg : key.getArguments()) {
                    short_key.then(arg);
                }
                setWorld.then((ArgumentBuilder)short_key);
            });
        }
        setWorld.requires(permissionPredicate);
        config.then((ArgumentBuilder)setWorld);
        config.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reload").requires(permissionPredicate)).executes(c -> {
            FabConf.reload();
            if (c.getSource() instanceof class_2168) {
                FabricationMod.sendConfigUpdate(((class_2168)c.getSource()).method_9211(), null);
            }
            FeatureFabricationCommand.sendFeedback((CommandContext<? extends class_2172>)c, class_2561.method_43470((String)(MixinConfigPlugin.MOD_NAME + " configuration reloaded")), true);
            FeatureFabricationCommand.sendFeedback((CommandContext<? extends class_2172>)c, class_2561.method_43470((String)"\u00a7eYou may need to restart the game for the changes to take effect."), false);
            return 1;
        }));
        root.then((ArgumentBuilder)config);
    }

    public static <T extends class_2172> void addFScript(LiteralArgumentBuilder<T> root, boolean dediServer) {
        LiteralArgumentBuilder script = LiteralArgumentBuilder.literal((String)"fscript");
        LiteralArgumentBuilder get = LiteralArgumentBuilder.literal((String)"get");
        for (String s2 : OptionalFScript.predicateProviders.keySet()) {
            if (dediServer && FeaturesFile.get((String)s2).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)s2).executes(c -> {
                FeatureFabricationCommand.sendFeedback((CommandContext<? extends class_2172>)c, class_2561.method_43470((String)(s2 + ": " + LoaderFScript.get(s2))), false);
                return 1;
            });
            get.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s2, alt -> get.then(LiteralArgumentBuilder.literal((String)alt).executes(key.getCommand())));
        }
        script.then((ArgumentBuilder)get);
        LiteralArgumentBuilder set = LiteralArgumentBuilder.literal((String)"set");
        for (String s3 : OptionalFScript.predicateProviders.keySet()) {
            if (dediServer && FeaturesFile.get((String)s3).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = LiteralArgumentBuilder.literal((String)s3);
            RequiredArgumentBuilder value = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"script", (ArgumentType)StringArgumentType.string()).executes(c -> {
                OptionalFScript.set((CommandContext<? extends class_2172>)c, s3, (String)c.getArgument("script", String.class));
                return 1;
            });
            key.then((ArgumentBuilder)value);
            set.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s3, alt -> set.then(LiteralArgumentBuilder.literal((String)alt).then((ArgumentBuilder)value)));
        }
        set.requires(s -> s.method_9259(2));
        script.then((ArgumentBuilder)set);
        LiteralArgumentBuilder unset = LiteralArgumentBuilder.literal((String)"unset");
        for (String s4 : OptionalFScript.predicateProviders.keySet()) {
            if (dediServer && FeaturesFile.get((String)s4).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)s4).executes(c -> {
                OptionalFScript.restoreDefault(s4);
                FeatureFabricationCommand.sendFeedback((CommandContext<? extends class_2172>)c, class_2561.method_43470((String)("Restored default behaviour for " + s4)), true);
                return 1;
            });
            unset.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s4, alt -> unset.then(LiteralArgumentBuilder.literal((String)alt).executes(key.getCommand())));
        }
        unset.requires(s -> s.method_9259(2));
        script.then((ArgumentBuilder)unset);
        script.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reload").requires(s -> s.method_9259(2))).executes(c -> {
            LoaderFScript.reload();
            OptionalFScript.reload();
            FeatureFabricationCommand.sendFeedback((CommandContext<? extends class_2172>)c, class_2561.method_43470((String)"Fabrication fscript reloaded"), true);
            return 1;
        }));
        root.then((ArgumentBuilder)script);
    }

    public static void sendFeedback(CommandContext<? extends class_2172> c, class_5250 text, boolean broadcast) {
        if (c.getSource() instanceof class_2168) {
            ((class_2168)c.getSource()).method_9226(() -> text, broadcast);
        } else {
            FeatureFabricationCommand.sendFeedbackClient(c, text);
        }
    }

    private static void sendFeedbackClient(CommandContext<? extends class_2172> c, class_5250 text) {
        FabricationClientCommands.sendFeedback((class_2561)text);
    }

    private int clearTags(CommandContext<class_2168> c, Collection<class_3222> players) {
        for (class_3222 spe : players) {
            ((TaggablePlayer)spe).fabrication$clearTags();
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared tags for ").method_10852(spe.method_5476()), true);
        }
        return 1;
    }

    private int getTags(CommandContext<class_2168> c, class_3222 player) {
        class_5250 lt = class_2561.method_43470((String)"Tags: ");
        Set<String> tags = ((TaggablePlayer)player).fabrication$getTags();
        if (tags.isEmpty()) {
            lt.method_27693("none");
        } else {
            lt.method_27693(Joiner.on((String)", ").join(tags));
        }
        ((class_2168)c.getSource()).method_9226(() -> lt, false);
        return 1;
    }

    private int addTag(CommandContext<class_2168> c, Collection<class_3222> players, String key) {
        if (!FabConf.isEnabled(key)) {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)(key + " has to be enabled for this tag to work")), true);
        }
        if (!FeatureTaggablePlayers.activeTags.containsKey(key)) {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Automatically switched " + key + " to TaggablePlayers because a player was tagged with it")), true);
            FeatureTaggablePlayers.add(key, 0);
        }
        String keyName = key.substring(key.lastIndexOf(46) + 1);
        for (class_3222 spe : players) {
            if (((TaggablePlayer)spe).fabrication$getTagOverride(keyName) != null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)(String.valueOf(players) + " has an override, tag will be set but ignored")), true);
            }
            ((TaggablePlayer)spe).fabrication$setTag(keyName, true);
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Added tag " + key + " to ")).method_10852(spe.method_5476()), true);
        }
        return 1;
    }

    private int removeTag(CommandContext<class_2168> c, Collection<class_3222> players, String pt) {
        String keyName = pt.substring(pt.lastIndexOf(46) + 1);
        for (class_3222 spe : players) {
            if (((TaggablePlayer)spe).fabrication$getTagOverride(keyName) != null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)(String.valueOf(players) + " has an override, tag will be set but ignored")), true);
            }
            ((TaggablePlayer)spe).fabrication$setTag(keyName, false);
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Removed tag " + pt + " from ")).method_10852(spe.method_5476()), true);
        }
        return 1;
    }

    private static void setKeyWithFeedback(CommandContext<? extends class_2172> c, String key, String value, boolean local) {
        String oldValue = FabConf.getRawValue(key);
        boolean def = FabConf.getDefault(key);
        if (!local && value.equals(oldValue) || local && FabConf.doesWorldContainValue(key, value)) {
            FeatureFabricationCommand.sendFeedback(c, class_2561.method_43470((String)(key + " is already set to " + value + " (default " + def + ")")), false);
        } else {
            if (local) {
                FabConf.worldSet(key, value);
            } else {
                FabConf.set(key, value);
            }
            if (c.getSource() instanceof class_2168) {
                FabricationMod.sendConfigUpdate(((class_2168)c.getSource()).method_9211(), key);
            }
            FeatureFabricationCommand.sendFeedback(c, class_2561.method_43470((String)(key + " is now set to " + value + " (default " + def + ")" + (local ? " for this world" : ""))), true);
            if (FabricationMod.isAvailableFeature(key) && FabricationMod.updateFeature(key)) {
                return;
            }
        }
    }

    public static void setAltKeys(String key, Consumer<String> set) {
        if (!key.contains(".")) {
            return;
        }
        int i = key.indexOf(46);
        while (i != -1) {
            set.accept("*" + key.substring(i));
            set.accept(key.substring(i));
            i = key.indexOf(46, i + 1);
        }
        if (key.lastIndexOf(46) != key.indexOf(46)) {
            set.accept(key.substring(0, key.indexOf(46)) + key.substring(key.lastIndexOf(46)));
        }
    }

    @Override
    public boolean undo() {
        return false;
    }

    @Override
    public String getConfigKey() {
        return null;
    }
}

