/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.client;

import com.google.common.collect.Lists;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.client.FabricationConfigScreen;
import com.unascribed.fabrication.client.OptionalPrideFlag;
import com.unascribed.fabrication.client.PrideFlagRenderer;
import com.unascribed.fabrication.client.ScrollBar;
import com.unascribed.fabrication.interfaces.GetServerConfig;
import com.unascribed.fabrication.support.ConfigValues;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public class FabricationSummaryScreen
extends class_437 {
    PrideFlagRenderer prideFlag;
    final class_437 parent;
    final List<String> features;
    final ScrollBar scrollBar;
    boolean didClick;
    double lastMouseX;
    double lastMouseY;

    public FabricationSummaryScreen(class_437 parent, List<String> options) {
        super(class_2561.method_30163((String)(MixinConfigPlugin.MOD_NAME + " summary")));
        this.scrollBar = new ScrollBar(this.field_22790);
        this.didClick = false;
        this.prideFlag = OptionalPrideFlag.get();
        this.parent = parent;
        this.features = options;
    }

    public static FabricationSummaryScreen tryCreate(class_437 parent) {
        GetServerConfig gsc;
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.method_1576() != null) {
            ArrayList<String> features = new ArrayList<String>();
            for (String key : FabConf.getAllKeys()) {
                ConfigValues.ResolvedFeature feature = FabConf.getResolvedValue(key, true);
                if (feature == null || !feature.value) continue;
                features.add(key);
            }
            return new FabricationSummaryScreen(parent, features);
        }
        class_634 cpnh = client.method_1562();
        if (cpnh instanceof GetServerConfig && (gsc = (GetServerConfig)cpnh).fabrication$hasHandshook()) {
            ArrayList<String> features = new ArrayList<String>();
            for (String key : gsc.fabrication$getServerTrileanConfig().keySet()) {
                ConfigValues.ResolvedFeature feature = ((GetServerConfig)client.method_1562()).fabrication$getServerTrileanConfig().getOrDefault(key, ConfigValues.ResolvedFeature.DEFAULT_FALSE);
                if (feature == null || !feature.value) continue;
                features.add(key);
            }
            return new FabricationSummaryScreen(parent, features);
        }
        return null;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        FabricationConfigScreen.drawBackground(this.field_22790, this.field_22789, this.field_22787, this.prideFlag, 0.0f, drawContext, 0, 0, 0.0f, 0, 0);
        float scroll = this.scrollBar.getScaledScroll(this.field_22787);
        this.scrollBar.height = -20.0f;
        scroll = (float)(Math.floor((double)scroll * this.field_22787.method_22683().method_4495()) / this.field_22787.method_22683().method_4495());
        float y = 22.0f - scroll;
        for (String key : this.features) {
            if (key.startsWith("general.category")) continue;
            FeaturesFile.FeatureEntry entry = FeaturesFile.get(key);
            float h = 0.0f;
            if (entry == null) {
                h = this.drawWrappedText(drawContext, 25.0f, y, "Unknown feature: " + key, this.field_22789 - 100, 0xFFFFFF, false) + 6;
                this.scrollBar.height += h;
                y += h;
                continue;
            }
            h = this.drawWrappedText(drawContext, 25.0f, y, entry.name, this.field_22789 - 100, 0xFFFFFF, false) + 6;
            h += (float)(this.drawWrappedText(drawContext, 50.0f, y + h, entry.desc, this.field_22789 - 100, 0xFFFFFF, false) + 6);
            this.scrollBar.height += h;
            y += h;
        }
    }

    private int drawWrappedText(class_332 drawContext, float x, float y, String str, int width, int color, boolean fromBottom) {
        int height = 0;
        List lines = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)str), width);
        if (fromBottom) {
            y -= 12.0f;
            lines = Lists.reverse((List)lines);
        }
        for (class_5481 ot : lines) {
            drawContext.method_51430(this.field_22793, ot, (int)x, (int)y, color, false);
            y += (float)(fromBottom ? -12 : 12);
            height += 12;
        }
        return height;
    }

    public void method_25393() {
        super.method_25393();
        this.scrollBar.tick();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.scrollBar.scroll(amount * 20.0);
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void method_16014(double x, double y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 266: {
                this.method_25401(this.lastMouseX, this.lastMouseY, 20.0);
                break;
            }
            case 267: {
                this.method_25401(this.lastMouseX, this.lastMouseY, -20.0);
                break;
            }
            case 265: {
                this.method_25401(this.lastMouseX, this.lastMouseY, 2.0);
                break;
            }
            case 264: {
                this.method_25401(this.lastMouseX, this.lastMouseY, -2.0);
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.didClick = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25410(class_310 client, int width, int height) {
        this.scrollBar.displayHeight = height;
        super.method_25410(client, width, height);
    }
}

