/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.client;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.FabricationModClient;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.client.BlockLogoScreen;
import com.unascribed.fabrication.client.ClassicBlockDropsScreen;
import com.unascribed.fabrication.client.FabricationSummaryScreen;
import com.unascribed.fabrication.client.OptionalFScriptScreen;
import com.unascribed.fabrication.client.OptionalPrideFlag;
import com.unascribed.fabrication.client.PrideFlagRenderer;
import com.unascribed.fabrication.client.SelectionScreen;
import com.unascribed.fabrication.client.TaggablePlayersScreen;
import com.unascribed.fabrication.client.YeetRecipesScreen;
import com.unascribed.fabrication.interfaces.GetServerConfig;
import com.unascribed.fabrication.support.ConfigValues;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_155;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5125;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import org.apache.commons.lang3.ArrayUtils;
import org.joml.Matrix4f;

public class FabricationConfigScreen
extends class_437 {
    private final Map<String, String> SECTION_DESCRIPTIONS = Maps.newHashMap();
    private static final class_2960 ID_LOCK = new class_2960("fabrication", "lock.png");
    private static final class_2960 ID_FSCRIPT = new class_2960("fabrication", "fscript.png");
    private static final class_2960 BG = new class_2960("fabrication", "bg.png");
    private static final class_2960 BG_DARK = new class_2960("fabrication", "bg-dark.png");
    private static final class_2960 BG_GRAD = new class_2960("fabrication", "bg-grad.png");
    private static final class_2960 BG_GRAD_DARK = new class_2960("fabrication", "bg-grad-dark.png");
    private static long serverLaunchId = -1L;
    private static final Set<String> newlyBannedKeysClient = Sets.newHashSet();
    private static final Set<String> newlyBannedKeysServer = Sets.newHashSet();
    private static final Set<String> newlyUnbannedKeysClient = Sets.newHashSet();
    private static final Set<String> newlyUnbannedKeysServer = Sets.newHashSet();
    private static boolean isFScriptLoaded = EarlyAgnos.isModLoaded("fscript");
    private final class_437 parent;
    private final PrideFlagRenderer prideFlag;
    private float timeExisted;
    private boolean leaving = false;
    private float timeLeaving;
    private float sidebarScrollTarget;
    private float sidebarScroll;
    private float lastSidebarScroll;
    private float sidebarHeight;
    private boolean didClick;
    private boolean mouseDragging;
    private int lastDragY;
    private float selectTime;
    private String selectedSection;
    private String prevSelectedSection;
    private float selectedSectionHeight;
    private float prevSelectedSectionHeight;
    private float selectedSectionScroll;
    private float prevSelectedSectionScroll;
    private float lastSelectedSectionScroll;
    private float lastPrevSelectedSectionScroll;
    private float selectedSectionScrollTarget;
    private float prevSelectedSectionScrollTarget;
    private int tooltipBlinkTicks = 0;
    private boolean configuringServer;
    private boolean hasClonked = true;
    private boolean isSingleplayer;
    private boolean editingWorldPath;
    private float serverAnimateTime;
    private String whyCantConfigureServer = null;
    private Set<String> serverKnownConfigKeys = Sets.newHashSet();
    private boolean serverReadOnly;
    private final List<String> tabs = Lists.newArrayList();
    private final Multimap<String, String> options = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), Lists::newArrayList);
    private final Map<String, ConfigValues.Feature> optionPreviousValues = Maps.newHashMap();
    private final Map<String, Float> optionAnimationTime = Maps.newHashMap();
    private final Map<String, Float> disabledAnimationTime = Maps.newHashMap();
    private final Map<String, Float> becomeBanAnimationTime = Maps.newHashMap();
    private final Set<String> knownDisabled = Sets.newHashSet();
    private final Set<String> onlyBannableds = Sets.newHashSet();
    private final Map<String, Map<String, FeatureSubmenu>> submenus = new HashMap<String, Map<String, FeatureSubmenu>>();
    private boolean bufferTooltips = false;
    private final List<Runnable> bufferedTooltips = Lists.newArrayList();
    private int noteIndex = 0;
    private class_342 searchField;
    private Pattern queryPattern = Pattern.compile("");
    private boolean emptyQuery = true;
    private boolean searchingScriptable = false;
    private double lastMouseX;
    private double lastMouseY;

    public FabricationConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)(MixinConfigPlugin.MOD_NAME + " configuration")));
        this.parent = parent;
        this.prideFlag = OptionalPrideFlag.get();
        for (String sec : FabConf.getAllSections()) {
            this.SECTION_DESCRIPTIONS.put(sec, FeaturesFile.get((String)sec).desc);
        }
        for (String key : FabConf.getAllKeys()) {
            int dot = key.indexOf(46);
            String section = key.substring(0, dot);
            String name = key.substring(dot + 1);
            this.options.put((Object)section, (Object)name);
        }
        if (isFScriptLoaded) {
            for (Map.Entry en : FeaturesFile.getAll().entrySet()) {
                String key = (String)en.getKey();
                FeaturesFile.FeatureEntry feature = (FeaturesFile.FeatureEntry)en.getValue();
                if (feature.fscript == null && (feature.extend == null || FeaturesFile.get((String)FabConf.remap((String)feature.extend)).fscript == null)) continue;
                this.defaultedSubmenu(key).put("FScript", OptionalFScriptScreen::construct);
            }
        }
        this.defaultedSubmenu(FabConf.remap("*.block_logo")).put("Detailed Configs", BlockLogoScreen::new);
        this.defaultedSubmenu(FabConf.remap("*.yeet_recipes")).put("Detailed Configs", YeetRecipesScreen::new);
        this.defaultedSubmenu(FabConf.remap("*.taggable_players")).put("Detailed Configs", TaggablePlayersScreen::new);
        this.defaultedSubmenu(FabConf.remap("*.classic_block_drops")).put("Detailed Configs", ClassicBlockDropsScreen::new);
        this.tabs.add("search");
        this.tabs.addAll(this.options.keySet());
    }

    private Map<String, FeatureSubmenu> defaultedSubmenu(String key) {
        if (!this.submenus.containsKey(key)) {
            HashMap<String, FeatureSubmenu> map = new HashMap<String, FeatureSubmenu>();
            this.submenus.put(key, map);
            return map;
        }
        return this.submenus.get(key);
    }

    protected void method_25426() {
        super.method_25426();
        this.isSingleplayer = false;
        if (this.field_22787.field_1687 == null) {
            if (!this.editingWorldPath) {
                FabConf.setWorldPath(null);
            }
        } else if (this.field_22787.method_1576() != null) {
            this.isSingleplayer = true;
        } else {
            CommandDispatcher disp = this.field_22787.field_1724.field_3944.method_2886();
            CommandNode root = disp.getRoot().getChild(MixinConfigPlugin.MOD_NAME_LOWER);
            if (root == null) {
                root = disp.getRoot().getChild(MixinConfigPlugin.MOD_NAME_LOWER_OTHER);
            }
            if (root == null) {
                this.whyCantConfigureServer = "This server doesn't have " + MixinConfigPlugin.MOD_NAME + ".";
            } else {
                class_634 cpnh = this.field_22787.method_1562();
                if (cpnh instanceof GetServerConfig) {
                    GetServerConfig gsc = (GetServerConfig)cpnh;
                    if (!gsc.fabrication$hasHandshook()) {
                        this.whyCantConfigureServer = "This server's version of " + MixinConfigPlugin.MOD_NAME + " is too old.";
                    } else {
                        CommandNode config = root.getChild("config");
                        this.serverReadOnly = config == null || config.getChild("set") == null;
                        this.serverKnownConfigKeys.clear();
                        this.serverKnownConfigKeys.addAll(gsc.fabrication$getServerTrileanConfig().keySet());
                        this.serverKnownConfigKeys.addAll(gsc.fabrication$getServerStringConfig().keySet());
                    }
                } else {
                    this.whyCantConfigureServer = "An internal error prevented initialization of the syncer.";
                }
            }
        }
        this.searchField = new class_342(this.field_22793, 131, 1, this.field_22789 - 252, 14, this.searchField, (class_2561)class_2561.method_43470((String)"Search"));
        if (isFScriptLoaded) {
            this.searchField.method_25358(this.searchField.method_25368() - 16);
        }
        this.searchField.method_1863(s -> {
            s = s.trim();
            this.emptyQuery = s.isEmpty();
            this.queryPattern = Pattern.compile(s, 18);
        });
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (this.timeExisted == 0.0f && !FabConf.isEnabled("*.reduced_motion")) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14588, (float)2.0f, (float)0.1f));
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17604, (float)1.2f));
        }
        this.timeExisted += delta;
        if (this.leaving) {
            this.timeLeaving += delta;
        }
        if ((this.leaving || this.timeExisted < 10.0f) && !FabConf.isEnabled("*.reduced_motion")) {
            float a = FabricationConfigScreen.sCurve5((this.leaving ? Math.max(0.0f, 10.0f - this.timeLeaving) : this.timeExisted) / 10.0f);
            class_4587 matrices = drawContext.method_51448();
            matrices.method_22903();
            matrices.method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790, 0.0f);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(a * (float)(this.leaving ? -180 : 180)));
            matrices.method_46416((float)(-this.field_22789 / 2), (float)(-this.field_22790), 0.0f);
            matrices.method_22903();
            matrices.method_46416(0.0f, (float)this.field_22790, 0.0f);
            matrices.method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            matrices.method_46416((float)(-this.field_22789) / 2.0f, (float)(-this.field_22790) / 2.0f, 0.0f);
            drawContext.method_25294(-this.field_22789, -this.field_22790, this.field_22789 * 2, 0, FabConf.isEnabled("general.dark_mode") ? -14606304 : -14575885);
            matrices.method_22903();
            this.drawBackground(drawContext, -200, -200, delta, 0, 0);
            this.drawForeground(drawContext, -200, -200, delta);
            matrices.method_22909();
            matrices.method_22909();
            matrices.method_22909();
            if (this.parent != null) {
                class_4587 projection = new class_4587();
                projection.method_34425(RenderSystem.getProjectionMatrix());
                projection.method_22903();
                projection.method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790, 0.0f);
                projection.method_22907(class_7833.field_40718.rotationDegrees(a * (float)(this.leaving ? -180 : 180)));
                projection.method_46416((float)(-this.field_22789 / 2), (float)(-this.field_22790), 0.0f);
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 0; ++y) {
                        if (x == 0 && y == 0) continue;
                        projection.method_22903();
                        projection.method_46416((float)(this.field_22789 * x), (float)(this.field_22790 * y), 0.0f);
                        RenderSystem.setProjectionMatrix((Matrix4f)projection.method_23760().method_23761(), (class_8251)class_8251.field_43361);
                        this.parent.method_25434(drawContext);
                        projection.method_22909();
                    }
                }
                RenderSystem.setProjectionMatrix((Matrix4f)projection.method_23760().method_23761(), (class_8251)class_8251.field_43361);
                this.parent.method_25394(drawContext, -200, -200, delta);
                projection.method_22909();
                RenderSystem.setProjectionMatrix((Matrix4f)projection.method_23760().method_23761(), (class_8251)class_8251.field_43361);
            }
        } else {
            drawContext.method_51448().method_22903();
            this.drawBackground(drawContext, mouseX, mouseY, delta, 0, 0);
            this.drawForeground(drawContext, mouseX, mouseY, delta);
            drawContext.method_51448().method_22909();
        }
        if (this.leaving && this.timeLeaving > 10.0f) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25420(class_332 matrices) {
        FabricationConfigScreen.drawBackground(this.field_22790, this.field_22789, this.field_22787, this.prideFlag, 0.0f, matrices, 0, 0, 0.0f, 0, 0);
    }

    private void drawBackground(class_332 drawContext, int mouseX, int mouseY, float delta, int cutoffX, int cutoffY) {
        FabricationConfigScreen.drawBackground(this.field_22790, this.field_22789, this.field_22787, this.prideFlag, this.selectedSection == null ? 10.0f - this.selectTime : (this.prevSelectedSection == null ? this.selectTime : 0.0f), drawContext, mouseX, mouseY, delta, cutoffX, cutoffY);
    }

    public static void drawBackground(int height, int width, class_310 client, PrideFlagRenderer prideFlag, float time, class_332 drawContext, int mouseX, int mouseY, float delta, int cutoffX, int cutoffY) {
        float cutoffV = (float)cutoffY / (float)height;
        class_2960 bg = FabConf.isEnabled("general.dark_mode") ? BG_DARK : BG;
        class_2960 bgGrad = FabConf.isEnabled("general.dark_mode") ? BG_GRAD_DARK : BG_GRAD;
        class_287 bb = class_289.method_1348().method_1349();
        Matrix4f mat = drawContext.method_51448().method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)bgGrad);
        client.method_1531().method_22813(bgGrad);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.setShader(class_757::method_34542);
        int startX = cutoffX == 0 ? -width : cutoffX;
        bb.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bb.method_22918(mat, (float)startX, (float)cutoffY, 0.0f).method_22913(0.0f, cutoffV).method_1344();
        bb.method_22918(mat, (float)(width * 2), (float)cutoffY, 0.0f).method_22913(1.0f, cutoffV).method_1344();
        bb.method_22918(mat, (float)(width * 2), (float)height, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bb.method_22918(mat, (float)startX, (float)height, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bb.method_1326());
        float ratio = 0.4648148f;
        float w = (float)height * ratio;
        float brk = Math.min((float)width - w, (float)(width * 2) / 3.0f - w / 3.0f);
        float brk2 = brk + w;
        float border = (float)(20.0 / client.method_22683().method_4495());
        if (brk < (float)cutoffX) {
            brk = cutoffX;
        }
        float top = 0.5277778f * (float)height;
        float bottom = 0.8342593f * (float)height;
        if ((float)cutoffY < bottom) {
            float h = bottom - top;
            float flagCutoffV = 0.0f;
            if (top < (float)cutoffY) {
                top = cutoffY;
                flagCutoffV = 1.0f - (bottom - top) / h;
            }
            RenderSystem.setShader(class_757::method_34540);
            if (prideFlag != null) {
                prideFlag.render(drawContext, brk, top, w, bottom - top);
            } else {
                bb.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                float r = class_3532.method_16439((float)flagCutoffV, (float)0.298f, (float)0.475f);
                float g = class_3532.method_16439((float)flagCutoffV, (float)0.686f, (float)0.333f);
                float b = class_3532.method_16439((float)flagCutoffV, (float)0.314f, (float)0.282f);
                bb.method_22918(mat, brk, top, 0.0f).method_22915(r, g, b, 1.0f).method_1344();
                bb.method_22918(mat, brk2, top, 0.0f).method_22915(r, g, b, 1.0f).method_1344();
                bb.method_22918(mat, brk2, bottom, 0.0f).method_22915(0.475f, 0.333f, 0.282f, 1.0f).method_1344();
                bb.method_22918(mat, brk, bottom, 0.0f).method_22915(0.475f, 0.333f, 0.282f, 1.0f).method_1344();
                class_286.method_43433((class_287.class_7433)bb.method_1326());
            }
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)bg);
        client.method_1531().method_22813(bg);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.setShader(class_757::method_34542);
        bb.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bb.method_22918(mat, Math.max((float)cutoffX, border), (float)cutoffY, 0.0f).method_22913(0.0f, cutoffV).method_1344();
        bb.method_22918(mat, brk, (float)cutoffY, 0.0f).method_22913(0.0f, cutoffV).method_1344();
        bb.method_22918(mat, brk, (float)height, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        bb.method_22918(mat, Math.max((float)cutoffX, border), (float)height, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        bb.method_22918(mat, brk, (float)cutoffY, 0.0f).method_22913(0.0f, cutoffV).method_1344();
        bb.method_22918(mat, brk2, (float)cutoffY, 0.0f).method_22913(1.0f, cutoffV).method_1344();
        bb.method_22918(mat, brk2, (float)height, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bb.method_22918(mat, brk, (float)height, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        bb.method_22918(mat, brk2, (float)cutoffY, 0.0f).method_22913(1.0f, cutoffV).method_1344();
        bb.method_22918(mat, (float)width - border, (float)cutoffY, 0.0f).method_22913(1.0f, cutoffV).method_1344();
        bb.method_22918(mat, (float)width - border, (float)height, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bb.method_22918(mat, brk2, (float)height, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bb.method_1326());
        float a = 1.0f - (0.3f + FabricationConfigScreen.sCurve5(time / 10.0f) * 0.7f);
        if (a > 0.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            RenderSystem.setShaderTexture((int)0, (class_2960)bgGrad);
            bb.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bb.method_22918(mat, (float)startX, (float)cutoffY, 0.0f).method_22913(0.0f, cutoffV).method_1344();
            bb.method_22918(mat, (float)(width * 2), (float)cutoffY, 0.0f).method_22913(1.0f, cutoffV).method_1344();
            bb.method_22918(mat, (float)(width * 2), (float)height, 0.0f).method_22913(1.0f, 1.0f).method_1344();
            bb.method_22918(mat, (float)startX, (float)height, 0.0f).method_22913(0.0f, 1.0f).method_1344();
            class_286.method_43433((class_287.class_7433)bb.method_1326());
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int lerpColor(int from, int to, float delta) {
        float a = class_3532.method_16439((float)delta, (float)((float)(from >> 24 & 0xFF) / 255.0f), (float)((float)(to >> 24 & 0xFF) / 255.0f));
        float r = class_3532.method_16439((float)delta, (float)((float)(from >> 16 & 0xFF) / 255.0f), (float)((float)(to >> 16 & 0xFF) / 255.0f));
        float g = class_3532.method_16439((float)delta, (float)((float)(from >> 8 & 0xFF) / 255.0f), (float)((float)(to >> 8 & 0xFF) / 255.0f));
        float b = class_3532.method_16439((float)delta, (float)((float)(from >> 0 & 0xFF) / 255.0f), (float)((float)(to >> 0 & 0xFF) / 255.0f));
        int c = 0;
        c |= ((int)(a * 255.0f) & 0xFF) << 24;
        c |= ((int)(r * 255.0f) & 0xFF) << 16;
        c |= ((int)(g * 255.0f) & 0xFF) << 8;
        return c |= ((int)(b * 255.0f) & 0xFF) << 0;
    }

    private void drawForeground(class_332 drawContext, int mouseX, int mouseY, float delta) {
        Set<String> newlyUnbannedKeys;
        Set<String> newlyBannedKeys;
        float a;
        if (this.serverAnimateTime > 0.0f) {
            this.serverAnimateTime -= delta;
        }
        if (this.serverAnimateTime < 0.0f) {
            this.serverAnimateTime = 0.0f;
        }
        if (this.selectTime > 0.0f) {
            this.selectTime -= delta;
        }
        if (this.selectTime < 0.0f) {
            this.selectTime = 0.0f;
        }
        if ((double)(a = FabricationConfigScreen.sCurve5(this.serverAnimateTime / 10.0f)) <= 0.05 && !this.hasClonked) {
            this.hasClonked = true;
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_21876, (float)1.0f, (float)0.5f));
        }
        if (this.configuringServer || this.editingWorldPath) {
            a = 1.0f - a;
        }
        drawContext.method_25294(-this.field_22789, -this.field_22790, 130, this.field_22790, 0x44000000);
        float scroll = this.sidebarHeight < (float)this.field_22790 ? 0.0f : this.lastSidebarScroll + (this.sidebarScroll - this.lastSidebarScroll) * this.field_22787.method_1488();
        scroll = (float)(Math.floor((double)scroll * this.field_22787.method_22683().method_4495()) / this.field_22787.method_22683().method_4495());
        float y = 8.0f - scroll;
        int newHeight = 8;
        int i = 0;
        float selectedChoiceY = -60.0f;
        float prevSelectedChoiceY = -60.0f;
        class_4587 matrices = drawContext.method_51448();
        for (String s : this.tabs) {
            float selectA;
            int thisHeight = 8;
            if (s.equals(this.selectedSection)) {
                selectA = FabricationConfigScreen.sCurve5((10.0f - this.selectTime) / 10.0f);
                selectedChoiceY = y;
            } else if (s.equals(this.prevSelectedSection)) {
                selectA = FabricationConfigScreen.sCurve5(this.selectTime / 10.0f);
                prevSelectedChoiceY = y;
            } else {
                selectA = 0.0f;
            }
            float startY = y;
            int icoY = 0;
            int size = 28;
            if ("search".equals(s)) {
                size = 12;
                icoY = -4;
            }
            class_2960 id = new class_2960("fabrication", "category/" + s + ".png");
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            this.field_22787.method_1531().method_22813(id);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            RenderSystem.setShaderTexture((int)0, (class_2960)id);
            matrices.method_22903();
            matrices.method_46416((float)(126 - size), (float)icoY + y, 0.0f);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(5.0f));
            drawContext.method_25291(id, 0, 0, 0, 0.0f, 0.0f, size, Math.min(size, (int)Math.ceil((float)this.field_22790 - y)), size, size);
            matrices.method_22909();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            drawContext.method_51433(this.field_22793, "\u00a7l" + FeaturesFile.get((String)s).shortName, 4, (int)y, -1, false);
            y += 12.0f;
            thisHeight += 12;
            if (!"search".equals(s)) {
                String desc = this.SECTION_DESCRIPTIONS.getOrDefault(s, "No description available");
                int x = 8;
                boolean line = false;
                for (String word : Splitter.on((CharMatcher)CharMatcher.whitespace()).split((CharSequence)desc)) {
                    int w = this.field_22793.method_1727(word);
                    if (x + w > 100 && !line) {
                        x = 8;
                        y += 12.0f;
                        newHeight += 12;
                        line = true;
                    }
                    x = drawContext.method_51433(this.field_22793, word + " ", x, (int)y, -1, false);
                }
                y += 12.0f;
                thisHeight += 12;
            }
            if (this.didClick && mouseX >= 0 && mouseX <= 130 && (float)mouseY > startY - 4.0f && (float)mouseY < y) {
                boolean deselect = s.equals(this.selectedSection);
                if ("search".equals(s) && !deselect) {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_14622.comp_349()), (float)1.2f, (float)1.0f));
                } else {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_14793.comp_349()), (float)(deselect ? 0.5f : 0.6f + (float)i * 0.1f), (float)1.0f));
                }
                this.prevSelectedSection = this.selectedSection;
                this.selectedSection = deselect ? null : s;
                this.prevSelectedSectionScroll = this.selectedSectionScroll;
                this.lastPrevSelectedSectionScroll = this.lastSelectedSectionScroll;
                this.prevSelectedSectionHeight = this.selectedSectionHeight;
                this.prevSelectedSectionScrollTarget = this.selectedSectionScrollTarget;
                this.selectedSectionScroll = 0.0f;
                this.lastSelectedSectionScroll = 0.0f;
                this.selectedSectionHeight = 0.0f;
                this.selectedSectionScrollTarget = 0.0f;
                this.selectTime = 10.0f - this.selectTime;
            }
            if (selectA > 0.0f) {
                RenderSystem.disableCull();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(class_757::method_34540);
                class_287 bb = class_289.method_1348().method_1349();
                Matrix4f mat = matrices.method_23760().method_23761();
                bb.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                bb.method_22918(mat, 0.0f, y - (float)thisHeight - 8.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 0.2f).method_1344();
                bb.method_22918(mat, 130.0f * selectA, y - (float)thisHeight - 8.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 0.2f + (1.0f - selectA) * 0.8f).method_1344();
                bb.method_22918(mat, 130.0f * selectA, y, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 0.2f + (1.0f - selectA) * 0.8f).method_1344();
                bb.method_22918(mat, 0.0f, y, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 0.2f).method_1344();
                class_286.method_43433((class_287.class_7433)bb.method_1326());
            }
            y += 8.0f;
            newHeight += thisHeight;
            ++i;
        }
        this.sidebarHeight = newHeight;
        if (this.sidebarHeight >= (float)this.field_22790) {
            float knobHeight = (float)this.field_22790 / this.sidebarHeight * (float)this.field_22790;
            float knobY = scroll / (this.sidebarHeight - (float)this.field_22790) * ((float)this.field_22790 - knobHeight);
            drawContext.method_25294(128, (int)knobY, 130, (int)(knobY + knobHeight), -1426063361);
        }
        this.bufferTooltips = true;
        float selectedA = FabricationConfigScreen.sCurve5((10.0f - this.selectTime) / 10.0f);
        float prevSelectedA = FabricationConfigScreen.sCurve5(this.selectTime / 10.0f);
        this.drawSection(drawContext, this.selectedSection, mouseX, mouseY, selectedChoiceY, selectedA, true);
        if (!FabConf.isEnabled("general.reduced_motion") && !Objects.equal((Object)this.selectedSection, (Object)this.prevSelectedSection)) {
            this.drawSection(drawContext, this.prevSelectedSection, -200.0f, -200.0f, prevSelectedChoiceY, prevSelectedA, false);
        }
        boolean searchSelected = "search".equals(this.selectedSection);
        boolean searchWasSelected = "search".equals(this.prevSelectedSection);
        if (searchSelected) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)selectedA);
            this.searchField.method_25350(selectedA);
            this.searchField.method_25394(drawContext, mouseX, mouseY, delta);
        } else if (searchWasSelected && prevSelectedA > 0.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)prevSelectedA);
            this.searchField.method_25350(prevSelectedA);
            this.searchField.method_25394(drawContext, mouseX, mouseY, delta);
        }
        this.searchField.method_25365(searchSelected);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.method_22903();
        RenderSystem.disableDepthTest();
        drawContext.method_25294(this.field_22789 - 120, 0, this.field_22789 * 2, 16, 0x33000000);
        matrices.method_22903();
        matrices.method_46416((float)(this.field_22789 - 60), 8.0f, 0.0f);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40718.rotationDegrees(a * -180.0f));
        float h = (40.0f + a * -100.0f) / 360.0f;
        if (h < 0.0f) {
            h = 1.0f + h;
        }
        matrices.method_22903();
        matrices.method_22905((float)(1.0 - Math.abs(Math.sin((double)a * Math.PI)) / 2.0), 1.0f, 1.0f);
        drawContext.method_25294(-60, -8, 0, 8, class_3532.method_15369((float)h, (float)0.9f, (float)0.9f) | 0xFF000000);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40718.rotationDegrees(45.0f));
        float f = 5.656854f;
        matrices.method_22905(f, f, 1.0f);
        drawContext.method_25294(-1, -1, 1, 1, -1);
        matrices.method_22909();
        drawContext.method_25294(-6, -1, -2, 1, -16777216);
        matrices.method_22909();
        drawContext.method_25294(-2, -2, 2, 2, -16777216);
        matrices.method_22909();
        boolean darkMode = FabConf.isEnabled("general.dark_mode");
        drawContext.method_51433(this.field_22793, "CLIENT", this.field_22789 - 115, 4, -16777216, false);
        if (this.field_22787.field_1687 == null || this.isSingleplayer) {
            drawContext.method_51433(this.field_22793, "WORLD", this.field_22789 - 40, 4, -16777216, false);
        } else {
            drawContext.method_51433(this.field_22793, "SERVER", this.field_22789 - 40, 4, this.whyCantConfigureServer == null ? -16777216 : (darkMode ? 0x44FFFFFF : 0x44000000), false);
            if (this.serverReadOnly && this.whyCantConfigureServer == null) {
                RenderSystem.setShaderTexture((int)0, (class_2960)ID_LOCK);
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                drawContext.method_25291(ID_LOCK, this.field_22789 - 49, 3, 0, 0.0f, 0.0f, 8, 8, 8, 8);
            }
        }
        if (searchSelected && isFScriptLoaded) {
            if (this.didClick && mouseX >= this.field_22789 - 136 && mouseX < this.field_22789 - 120 && mouseY <= 16) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.searchingScriptable = !this.searchingScriptable;
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)ID_FSCRIPT);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            drawContext.method_25294(this.field_22789 - 136, 0, this.field_22789 - 120, 16, this.searchingScriptable ? -16080896 : 0x55000000);
            drawContext.method_25291(ID_FSCRIPT, this.field_22789 - 136, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        this.drawBackground(drawContext, mouseX, mouseY, delta, 130, this.field_22790 - 20);
        ArrayList notes = Lists.newArrayList();
        boolean hasYellowNote = false;
        boolean hasRedNote = false;
        if (this.configuringServer) {
            this.checkServerData();
            newlyBannedKeys = newlyBannedKeysServer;
            newlyUnbannedKeys = newlyUnbannedKeysServer;
        } else {
            newlyBannedKeys = newlyBannedKeysClient;
            newlyUnbannedKeys = newlyUnbannedKeysClient;
        }
        if (!newlyUnbannedKeys.isEmpty()) {
            notes.add("\u00a7c" + newlyUnbannedKeys.size() + " newly unbanned option" + (newlyUnbannedKeys.size() == 1 ? "" : "s") + " will\n\u00a7cnot activate until the {} is\n\u00a7crestarted.");
            hasRedNote = true;
        }
        if (!newlyBannedKeys.isEmpty()) {
            notes.add(newlyBannedKeys.size() + " newly banned option" + (newlyBannedKeys.size() == 1 ? "" : "s") + " will be\nunloaded when the {} is\nrestarted.");
        }
        if (this.noteIndex < 0) {
            this.noteIndex = 0;
        }
        if (this.noteIndex >= notes.size()) {
            this.noteIndex = 0;
        }
        int textHeight = this.drawWrappedText(drawContext, 136.0f, this.field_22790, (hasRedNote ? "\u00a7c\u26a0 " : (hasYellowNote ? "\u00a7e" : "")) + notes.size() + " note" + (notes.size() == 1 ? "" : "s") + (String)(notes.isEmpty() ? " \u263a" : " - hover to see " + (notes.size() == 1 ? "it" : "them")), this.field_22789 - 250, -1, true);
        if (mouseX >= 136 && mouseX <= this.field_22789 - 100 && mouseY >= this.field_22790 - textHeight && !notes.isEmpty()) {
            ArrayList lines = Lists.newArrayList();
            for (String s : ((String)notes.get(this.noteIndex)).replace("{}", this.configuringServer ? "server" : "client").split("\n")) {
                lines.add(class_2561.method_43470((String)s));
            }
            if (notes.size() > 1) {
                lines.add(class_2561.method_43470((String)"\u00a77Click to see other notes"));
            }
            drawContext.method_51434(this.field_22793, (List)lines, mouseX, mouseY);
            if (this.didClick && notes.size() > 1) {
                ++this.noteIndex;
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14920, (float)1.0f));
            }
        }
        if (this.drawButton(drawContext, this.field_22789 - 100, this.field_22790 - 20, 100, 20, "Done", mouseX, mouseY)) {
            this.method_25419();
        }
        if (this.didClick) {
            this.didClick = false;
            this.lastDragY = 0;
        }
        if (this.mouseDragging) {
            this.mouseDragging = false;
        }
        super.method_25394(drawContext, mouseX, mouseY, delta);
        this.bufferTooltips = false;
        for (Runnable r : this.bufferedTooltips) {
            r.run();
        }
        this.bufferedTooltips.clear();
        if (mouseX > this.field_22789 - 120 && mouseY < 16) {
            Object msg;
            if (this.whyCantConfigureServer != null) {
                msg = (this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "\u00a7e") + this.whyCantConfigureServer;
            } else if (this.editingWorldPath) {
                msg = "Click to unselect world";
            } else if (this.field_22787.field_1687 == null || this.isSingleplayer) {
                msg = "Click to select world";
            } else {
                int srv = this.serverKnownConfigKeys.size();
                int cli = FabConf.getAllKeys().size();
                msg = "\u00a7dServer has " + MixinConfigPlugin.MOD_NAME + " and is recognized.";
                if (srv != cli) {
                    msg = (String)msg + "\n\u00a7oMismatch: Server has " + srv + " options. Client has " + cli + ".";
                    if (srv > cli) {
                        msg = (String)msg + "\n\u00a7cOptions unknown to the client will not appear.";
                    } else if (cli > srv) {
                        msg = (String)msg + "\n\u00a7eOptions unknown to the server will be disabled.";
                    }
                }
            }
            if (this.serverReadOnly) {
                msg = (String)msg + "\n\u00a7fYou cannot configure this server.";
                if (this.configuringServer) {
                    msg = (String)msg + "\n\u00a7fChanges cannot be made.";
                }
            }
            if (!(this.isSingleplayer || this.serverReadOnly && this.configuringServer)) {
                msg = (String)msg + "\n\u00a7fChanges will apply to the " + (this.configuringServer ? "\u00a7dSERVER" : "\u00a76CLIENT") + "\u00a7f.";
            }
            drawContext.method_51434(this.field_22793, Lists.transform((List)Lists.newArrayList((Object[])((String)msg).split("\n")), class_2561::method_30163), mouseX + 10, 20 + mouseY);
        }
        matrices.method_22909();
    }

    private void checkServerData() {
        long launchId;
        class_634 cpnh = this.field_22787.method_1562();
        if (cpnh != null && cpnh instanceof GetServerConfig && (launchId = ((GetServerConfig)cpnh).fabrication$getLaunchId()) != serverLaunchId) {
            newlyBannedKeysServer.clear();
            newlyUnbannedKeysServer.clear();
            serverLaunchId = launchId;
        }
    }

    private int drawWrappedText(class_332 drawContext, float x, float y, String str, int width, int color, boolean fromBottom) {
        int height = 0;
        List lines = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)str), width);
        if (fromBottom) {
            y -= 12.0f;
            lines = Lists.reverse((List)lines);
        }
        for (class_5481 ot : lines) {
            drawContext.method_51430(this.field_22793, ot, (int)x, (int)y, color, false);
            y += (float)(fromBottom ? -12 : 12);
            height += 12;
        }
        return height;
    }

    private void drawSection(class_332 drawContext, String section, float mouseX, float mouseY, float choiceY, float a, boolean selected) {
        int startY;
        if (a <= 0.0f) {
            return;
        }
        if (FabConf.isEnabled("general.reduced_motion")) {
            a = 1.0f;
        }
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(60.0f, choiceY + 16.0f, 0.0f);
        matrices.method_22905(a, a, 1.0f);
        matrices.method_46416(-60.0f, -(choiceY + 16.0f), 0.0f);
        float lastScrollOfs = selected ? this.lastSelectedSectionScroll : this.lastPrevSelectedSectionScroll;
        float scrollOfs = selected ? this.selectedSectionScroll : this.prevSelectedSectionScroll;
        float scroll = (selected ? this.selectedSectionHeight : this.prevSelectedSectionHeight) < (float)(this.field_22790 - 36) ? 0.0f : lastScrollOfs + (scrollOfs - lastScrollOfs) * this.field_22787.method_1488();
        int y = startY = 16 - (int)scroll;
        if (section == null) {
            FabricationSummaryScreen screen;
            String v = this.getVersion();
            String blurb = "\u00a7l" + MixinConfigPlugin.MOD_NAME + " v" + v + " \u00a7rby unascribed and SFort\nRunning under Minecraft " + class_155.method_16673().method_48019() + "\n" + (String)(this.configuringServer ? "(Local version: v" + EarlyAgnos.getModVersion() + ")" : "") + "\nClick a category on the left to change settings.";
            int height = this.drawWrappedText(drawContext, 140.0f, 20.0f, blurb, this.field_22789 - 130, -1, false);
            if (!this.configuringServer && this.drawButton(drawContext, 140, 20 + height + 32, 120, 20, "Reload files", mouseX, mouseY)) {
                FabConf.reload();
            }
            if (this.drawButton(drawContext, 140, 42 + height + 32, 80, 20, "Summary", mouseX, mouseY) && (screen = FabricationSummaryScreen.tryCreate(this)) != null) {
                this.field_22787.method_1507((class_437)screen);
            }
            y += height;
            y += 44;
        } else {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_2960 tex = new class_2960("fabrication", "category/" + section + ".png");
            RenderSystem.setShaderTexture((int)0, (class_2960)tex);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
            matrices.method_22903();
            matrices.method_46416(130.0f + (float)(this.field_22789 - 130) / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
            drawContext.method_25291(tex, -80, -80, 0, 0.0f, 0.0f, 160, 160, 160, 160);
            matrices.method_22909();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if ("general".equals(section)) {
                if (y > 0) {
                    drawContext.method_51433(this.field_22787.field_1772, "\u00a7lGeneral", 135, y - 12, -1, false);
                }
                y = this.drawConfigValues(drawContext, y, mouseX, mouseY, en -> !en.key.startsWith("general.category.") && en.key.startsWith("general."), new ConfigValueFlag[0]);
                drawContext.method_51433(this.field_22787.field_1772, "\u00a7lCategory Defaults", 135, (y += 25) - 12, -1, false);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                List<Map.Entry> categories = FeaturesFile.getAll().entrySet().stream().filter(en -> ((String)en.getKey()).startsWith("general.category.")).sorted(Comparator.comparing(e -> {
                    int i = this.tabs.indexOf(((String)e.getKey()).substring(17));
                    return i == -1 ? Integer.MAX_VALUE : i;
                })).toList();
                if (this.editingWorldPath) {
                    y += this.drawWrappedText(drawContext, 200.0f, y, "Categories are not available in world settings", this.field_22789 - 200, 0xFFFFFF, false) + 6;
                } else {
                    for (Map.Entry en2 : categories) {
                        FeaturesFile.FeatureEntry fe2 = (FeaturesFile.FeatureEntry)en2.getValue();
                        y = this.drawCategoryValue(drawContext, (String)en2.getKey(), fe2.name, fe2.desc, y, mouseX, mouseY);
                    }
                }
            } else if ("search".equals(section)) {
                y += 4;
                Predicate<FeaturesFile.FeatureEntry> pen = "#failed".equals(this.searchField.method_1882()) ? fe -> this.isFailed(fe.key) : en -> this.emptyQuery || this.queryPattern.matcher(en.name).find() || this.queryPattern.matcher(en.shortName).find() || this.queryPattern.matcher(en.desc).find();
                if (isFScriptLoaded && this.searchingScriptable) {
                    pen = ((Predicate<FeaturesFile.FeatureEntry>)en -> en.fscript != null).and(pen);
                }
                y = this.drawConfigValues(drawContext, y, mouseX, mouseY, ((Predicate<FeaturesFile.FeatureEntry>)en -> !en.key.startsWith("general.category.")).and(pen), ConfigValueFlag.SHOW_SOURCE_SECTION, this.emptyQuery ? null : ConfigValueFlag.HIGHLIGHT_QUERY_MATCH);
            } else {
                String name = FeaturesFile.get((String)section).name;
                if (y > 0) {
                    drawContext.method_51433(this.field_22787.field_1772, "\u00a7l" + name, 135, y - 12, -1, false);
                }
                int titleY = y = this.drawConfigValues(drawContext, y, mouseX, mouseY, en -> en.key.startsWith(section + ".") && !en.extra, new ConfigValueFlag[0]);
                int endY = this.drawConfigValues(drawContext, y += 22, mouseX, mouseY, en -> en.key.startsWith(section + ".") && en.extra, new ConfigValueFlag[0]);
                if (endY != y && y < this.field_22790 - 8) {
                    drawContext.method_51433(this.field_22787.field_1772, "\u00a7l" + name + " \u00a7oExtra", 135, titleY + 10, -1, false);
                }
                y = endY;
            }
        }
        if (y == startY) {
            drawContext.method_51433(this.field_22787.field_1772, "There are no available features in this category", 136, startY + 14, -1, false);
        }
        float h = y - startY;
        if (selected) {
            this.selectedSectionHeight = h;
        } else {
            this.prevSelectedSectionHeight = h;
        }
        int sh = this.field_22790 - 36;
        if (h > (float)sh) {
            float knobHeight = (float)sh / h * (float)sh;
            float knobY = (selected ? this.selectedSectionScroll : this.prevSelectedSectionScroll) / (h - (float)sh) * ((float)sh - knobHeight) + 16.0f;
            drawContext.method_25294(this.field_22789 - 2, Math.max(16, (int)knobY), this.field_22789, Math.min(this.field_22790 - 20, (int)(knobY + knobHeight)), -1426063361);
        }
        matrices.method_22909();
    }

    private int drawConfigValues(class_332 drawContext, int y, float mouseX, float mouseY, Predicate<FeaturesFile.FeatureEntry> pred, ConfigValueFlag ... defaultFlags) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Map.Entry en : FeaturesFile.getAll().entrySet()) {
            FeaturesFile.FeatureEntry fe = (FeaturesFile.FeatureEntry)en.getValue();
            if (fe.meta || fe.section || !pred.test(fe)) continue;
            ConfigValueFlag[] flags = defaultFlags;
            if (fe.sides == FeaturesFile.Sides.CLIENT_ONLY) {
                flags = (ConfigValueFlag[])ArrayUtils.add((Object[])flags, (Object)((Object)ConfigValueFlag.CLIENT_ONLY));
            }
            y = this.drawConfigValue(drawContext, (String)en.getKey(), fe.name, fe.desc, y, mouseX, mouseY, flags);
        }
        return y;
    }

    private boolean drawButton(class_332 drawContext, int x, int y, int w, int h, String text, float mouseX, float mouseY) {
        return FabricationConfigScreen.drawButton(drawContext, x, y, w, h, text, mouseX, mouseY, this.didClick, this.field_22787);
    }

    public static boolean drawButton(class_332 drawContext, int x, int y, int w, int h, String text, float mouseX, float mouseY, boolean didClick, class_310 client) {
        boolean click = false;
        boolean hover = mouseX >= (float)x && mouseX <= (float)(x + w) && mouseY >= (float)y && mouseY <= (float)(y + h);
        drawContext.method_25294(x, y, x + w, y + h, FabConf.isEnabled("general.dark_mode") ? 0x44FFFFFF : 0x55000000);
        int textColor = -1;
        if (hover) {
            if (FabConf.isEnabled("*.yellow_button_hover")) {
                textColor = -96;
            }
            drawContext.method_25294(x, y, x + w, y + 1, -1);
            drawContext.method_25294(x, y, x + 1, y + h, -1);
            drawContext.method_25294(x, y + h - 1, x + w, y + h, -1);
            drawContext.method_25294(x + w - 1, y, x + w, y + h, -1);
            if (didClick) {
                client.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                click = true;
            }
        }
        int textWidth = client.field_1772.method_1727(text);
        drawContext.method_51433(client.field_1772, text, x + (w - textWidth) / 2, y + (h - 8) / 2, textColor, false);
        return click;
    }

    public static boolean drawToggleButton(class_332 drawContext, int x, int y, int w, int h, String text, float mouseX, float mouseY, boolean toggle, boolean didClick, class_310 client) {
        boolean click = false;
        boolean hover = mouseX >= (float)x && mouseX <= (float)(x + w) && mouseY >= (float)y && mouseY <= (float)(y + h);
        int textColor = -1;
        if (hover ^ toggle) {
            if (FabConf.isEnabled("*.yellow_button_hover")) {
                textColor = -96;
            }
            drawContext.method_25294(x, y, x + w, y + 1, -1);
            drawContext.method_25294(x, y, x + 1, y + h, -1);
            drawContext.method_25294(x, y + h - 1, x + w, y + h, -1);
            drawContext.method_25294(x + w - 1, y, x + w, y + h, -1);
        }
        if (hover && didClick) {
            client.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            click = true;
        }
        int textWidth = client.field_1772.method_1727(text);
        drawContext.method_51433(client.field_1772, text, (int)((float)x + (float)(w - textWidth) / 2.0f), (int)((float)y + (float)(h - 8) / 2.0f), textColor, false);
        return click;
    }

    private int drawCategoryValue(class_332 drawContext, String key, String title, String desc, int y, float mouseX, float mouseY) {
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, (float)y, 0.0f);
        int startY = y;
        y += this.drawWrappedText(drawContext, 200.0f, 2.0f, title, this.field_22789 - 200, -1, false) + 6;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (class_2960)new class_2960("fabrication", "coffee_bean.png"));
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        int x = 0;
        ConfigValues.Category hovered = null;
        for (ConfigValues.Category p : ConfigValues.Category.values()) {
            boolean profSel;
            block13: {
                block14: {
                    try {
                        profSel = ConfigValues.Category.parse(this.getRawValue(key)) == p;
                    }
                    catch (IllegalArgumentException e) {
                        boolean bl = profSel = p == ConfigValues.Category.GREEN;
                    }
                    if (mouseX >= (float)(134 + x) && mouseX <= (float)(134 + x + 16) && mouseY >= (float)startY && mouseY <= (float)(startY + 16)) {
                        hovered = p;
                    }
                    if (!this.didClick && !this.mouseDragging || !(mouseX >= (float)(134 + x)) || !(mouseX <= (float)(134 + x + 16)) || !(mouseY >= (float)startY) || !(mouseY <= (float)(startY + 16))) break block13;
                    if (this.didClick || !this.mouseDragging) break block14;
                    if (this.lastDragY == startY) break block13;
                    this.lastDragY = startY;
                }
                if (p == ConfigValues.Category.ASH) {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_14725.comp_349()), (float)2.0f, (float)1.0f));
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_15074, (float)1.0f, (float)1.0f));
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_15074, (float)1.0f, (float)1.2f));
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_15074, (float)1.0f, (float)0.7f));
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_15074, (float)1.0f, (float)0.5f));
                } else if (p == ConfigValues.Category.GREEN) {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_14624.comp_349()), (float)0.5f, (float)1.0f));
                } else {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_18309.comp_349()), (float)(0.707107f + (float)p.ordinal() * 0.22f), (float)1.0f));
                }
                this.setValue(key, p.name().toLowerCase(Locale.ROOT));
            }
            this.color(p.getColor(), profSel ? 1.0f : (hovered == p ? 0.6f : 0.3f));
            drawContext.method_25291(new class_2960("fabrication", "coffee_bean.png"), 134 + x, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            this.color(-1);
            x += 18;
        }
        if (mouseX >= 200.0f && mouseX <= (float)(this.field_22789 - 200) && mouseY >= (float)startY && mouseY <= (float)(y - 6)) {
            this.renderWrappedTooltip(drawContext, desc, mouseX, mouseY);
        }
        if (hovered != null) {
            this.renderWrappedTooltip(drawContext, "\u00a7l" + hovered.displayName() + "\n\u00a7f" + hovered.displayDesc(), mouseX, mouseY);
        }
        matrices.method_22909();
        return y;
    }

    private int drawConfigValue(class_332 drawContext, String key, String title, String desc, int y, float mouseX, float mouseY, ConfigValueFlag ... flags) {
        int endX;
        int startX;
        int clickedIndex;
        int trackSize;
        float da;
        boolean keyEnabled;
        ConfigValues.Feature currentValue;
        boolean noUnset;
        boolean noBan;
        float scale;
        class_4587 matrices;
        boolean noValue;
        boolean disabled;
        boolean banned;
        String failed;
        boolean noFabricApi;
        boolean highlightQueryMatch;
        boolean showSourceSection;
        boolean requiresFabricApi;
        boolean onlyBannable;
        boolean clientOnly;
        block88: {
            block89: {
                ConfigValues.Feature prevValue;
                boolean animateDisabled;
                if (y < -12 || y > this.field_22790 - 16) {
                    return y + 14;
                }
                clientOnly = ArrayUtils.contains((Object[])flags, (Object)((Object)ConfigValueFlag.CLIENT_ONLY));
                onlyBannable = clientOnly && this.configuringServer;
                requiresFabricApi = ArrayUtils.contains((Object[])flags, (Object)((Object)ConfigValueFlag.REQUIRES_FABRIC_API));
                showSourceSection = ArrayUtils.contains((Object[])flags, (Object)((Object)ConfigValueFlag.SHOW_SOURCE_SECTION));
                highlightQueryMatch = ArrayUtils.contains((Object[])flags, (Object)((Object)ConfigValueFlag.HIGHLIGHT_QUERY_MATCH));
                noFabricApi = !this.configuringServer && requiresFabricApi && !FabricLoader.getInstance().isModLoaded("fabric");
                failed = this.getFailed(key);
                banned = !this.configuringServer && FabricationModClient.isBannedByServer(key);
                disabled = banned || noFabricApi || this.configuringServer && this.serverReadOnly || !this.isValid(key);
                noValue = noFabricApi || this.configuringServer && clientOnly || !this.isValid(key);
                float time = this.optionAnimationTime.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
                float disabledTime = this.disabledAnimationTime.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
                float becomeBanTime = this.becomeBanAnimationTime.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
                if (onlyBannable && !this.onlyBannableds.contains(key)) {
                    becomeBanTime = this.becomeBanAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
                    this.onlyBannableds.add(key);
                } else if (!onlyBannable && this.onlyBannableds.contains(key)) {
                    becomeBanTime = this.becomeBanAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
                    this.onlyBannableds.remove(key);
                }
                boolean bl = animateDisabled = disabledTime > 0.0f;
                if (disabled && !this.knownDisabled.contains(key)) {
                    disabledTime = this.disabledAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
                    this.knownDisabled.add(key);
                } else if (!disabled && this.knownDisabled.contains(key)) {
                    disabledTime = this.disabledAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
                    this.knownDisabled.remove(key);
                }
                if (time > 0.0f) {
                    if ((time -= this.field_22787.method_1534()) <= 0.0f) {
                        this.optionAnimationTime.remove(key);
                        time = 0.0f;
                    } else {
                        this.optionAnimationTime.put(key, Float.valueOf(time));
                    }
                }
                if (disabledTime > 0.0f) {
                    if ((disabledTime -= this.field_22787.method_1534()) <= 0.0f) {
                        this.disabledAnimationTime.remove(key);
                        disabledTime = 0.0f;
                    } else {
                        this.disabledAnimationTime.put(key, Float.valueOf(disabledTime));
                    }
                }
                if (becomeBanTime > 0.0f) {
                    if ((becomeBanTime -= this.field_22787.method_1534()) <= 0.0f) {
                        this.becomeBanAnimationTime.remove(key);
                        becomeBanTime = 0.0f;
                    } else {
                        this.becomeBanAnimationTime.put(key, Float.valueOf(becomeBanTime));
                    }
                }
                matrices = drawContext.method_51448();
                matrices.method_22903();
                matrices.method_46416(0.0f, (float)y, 0.0f);
                float dia = FabricationConfigScreen.sCurve5((5.0f - becomeBanTime) / 5.0f);
                scale = 1.0f;
                noBan = key.startsWith("general.");
                boolean bl2 = noUnset = noBan && !this.editingWorldPath;
                currentValue = noUnset ? (this.isEnabled(key) ? ConfigValues.Feature.TRUE : ConfigValues.Feature.FALSE) : (onlyBannable ? (this.getValue(key) == ConfigValues.Feature.BANNED ? ConfigValues.Feature.BANNED : ConfigValues.Feature.UNSET) : this.getValue(key));
                keyEnabled = this.getResolvedValue(key) == ConfigValues.ResolvedFeature.DEFAULT_TRUE;
                ConfigValues.Feature feature = prevValue = animateDisabled ? currentValue : this.optionPreviousValues.getOrDefault(key, currentValue);
                int[] xes = noUnset ? new int[]{0, 23, 0, 0} : (noBan ? new int[]{15, 30, 0, 0} : (onlyBannable ? new int[]{30, 30, 30, 0} : new int[]{30, 45, 15, 0}));
                int[] hues = new int[]{50, 130, -10, -90};
                int[] values = new int[]{90, 85, 90, 20};
                int prevX = xes[prevValue.ordinal()];
                int prevHue = hues[prevValue.ordinal()];
                int prevHSValue = values[prevValue.ordinal()];
                int curX = xes[currentValue.ordinal()];
                int curHue = hues[currentValue.ordinal()];
                int curHSValue = values[currentValue.ordinal()];
                float a = FabricationConfigScreen.sCurve5((5.0f - time) / 5.0f);
                da = FabricationConfigScreen.sCurve5((5.0f - disabledTime) / 5.0f);
                if (!disabled && failed == null) {
                    da = 1.0f - da;
                }
                int n = trackSize = noUnset || noBan ? 45 : 60;
                if (clientOnly) {
                    drawContext.method_25294(133, 0, 134 + trackSize + 1, 11, -22016);
                } else {
                    drawContext.method_25294(133, 0, 134 + trackSize + 1, 11, -1);
                }
                drawContext.method_25294(134, 1, 134 + trackSize, 10, 0x66000000);
                if (!(noUnset || onlyBannable || noBan)) {
                    drawContext.method_25294(149, 1, 164, 10, 0x33000000);
                    drawContext.method_25294(179, 1, 194, 10, 0x33000000);
                }
                matrices.method_22903();
                matrices.method_46416(134.0f + ((float)prevX + (float)(curX - prevX) * a), 0.0f, 0.0f);
                int knobAlpha = (int)((noValue ? 1.0f - da : 1.0f) * 255.0f) << 24;
                int selectedWidth = noUnset ? 22 : (onlyBannable ? 30 : 15);
                drawContext.method_25294(0, 1, selectedWidth, 10, class_3532.method_15369((float)((float)Math.floorMod((int)((float)prevHue + (float)(curHue - prevHue) * a), 360) / 360.0f), (float)0.9f, (float)(((float)prevHSValue + (float)(curHSValue - prevHSValue) * a) / 100.0f)) | knobAlpha);
                if (!(noUnset || !(a >= 1.0f) || currentValue != ConfigValues.Feature.UNSET && !this.editingWorldPath || onlyBannable || noBan && currentValue != ConfigValues.Feature.UNSET)) {
                    drawContext.method_25294(keyEnabled ? selectedWidth : -1, 1, keyEnabled ? selectedWidth + 1 : 0, 10, class_3532.method_15369((float)((float)(keyEnabled ? 120 : 0) / 360.0f), (float)0.9f, (float)0.8f) | knobAlpha);
                }
                matrices.method_22909();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                class_2960 tex = new class_2960("fabrication", "configvalue.png");
                RenderSystem.setShaderTexture((int)0, (class_2960)tex);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f + (1.0f - da) * 0.5f));
                if (noUnset) {
                    drawContext.method_25290(tex, 137, 1, 15.0f, 0.0f, 15, 9, 60, 9);
                    drawContext.method_25290(tex, 160, 1, 45.0f, 0.0f, 15, 9, 60, 9);
                } else if (noBan) {
                    drawContext.method_25290(tex, 134, 1, 15.0f, 0.0f, 45, 9, 60, 9);
                } else if (onlyBannable) {
                    drawContext.method_25290(tex, 141, 1, 0.0f, 0.0f, 15, 9, 60, 9);
                    drawContext.method_25290(tex, 172, 1, 30.0f, 0.0f, 15, 9, 60, 9);
                } else {
                    drawContext.method_25290(tex, 134, 1, 0.0f, 0.0f, 60, 9, 60, 9);
                }
                clickedIndex = (int)(mouseX - 134.0f) / (noUnset ? 22 : (onlyBannable ? 30 : 15));
                if (!this.didClick && !this.mouseDragging || !(mouseX >= 134.0f) || !(mouseX <= (float)(134 + trackSize)) || !(mouseY >= (float)(y + 1)) || !(mouseY <= (float)(y + 10))) break block88;
                if (this.didClick || !this.mouseDragging) break block89;
                if (this.lastDragY == y) break block88;
                this.lastDragY = y;
            }
            float pitch = (float)y * 0.005f;
            if (disabled) {
                this.playErrorFeedback();
            } else {
                ConfigValues.Feature newValue;
                if (noUnset) {
                    newValue = clickedIndex == 0 ? ConfigValues.Feature.FALSE : ConfigValues.Feature.TRUE;
                } else if (noBan) {
                    switch (clickedIndex) {
                        case 0: {
                            newValue = ConfigValues.Feature.FALSE;
                            break;
                        }
                        case 2: {
                            newValue = ConfigValues.Feature.TRUE;
                            break;
                        }
                        default: {
                            newValue = ConfigValues.Feature.UNSET;
                            break;
                        }
                    }
                } else if (onlyBannable) {
                    newValue = clickedIndex == 0 ? ConfigValues.Feature.BANNED : ConfigValues.Feature.UNSET;
                } else {
                    switch (clickedIndex) {
                        case 0: {
                            newValue = ConfigValues.Feature.BANNED;
                            break;
                        }
                        case 1: {
                            newValue = ConfigValues.Feature.FALSE;
                            break;
                        }
                        case 2: {
                            newValue = ConfigValues.Feature.UNSET;
                            break;
                        }
                        case 3: {
                            newValue = ConfigValues.Feature.TRUE;
                            break;
                        }
                        default: {
                            newValue = ConfigValues.Feature.UNSET;
                        }
                    }
                }
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)(newValue == ConfigValues.Feature.BANNED ? (class_3414)class_3417.field_15047.comp_349() : (newValue == ConfigValues.Feature.FALSE ? (class_3414)class_3417.field_14624.comp_349() : (newValue == ConfigValues.Feature.UNSET ? (class_3414)class_3417.field_18309.comp_349() : (class_3414)class_3417.field_14725.comp_349()))), (float)(0.6f + pitch), (float)1.0f));
                if (newValue != currentValue || this.editingWorldPath && !FabConf.doesWorldContainValue(key)) {
                    this.optionPreviousValues.put(key, currentValue);
                    this.optionAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue())));
                    this.setValue(key, newValue.toString().toLowerCase(Locale.ROOT));
                }
            }
        }
        int textAlpha = (int)((0.7f + (1.0f - da) * 0.3f) * 255.0f) << 24;
        int startY = y;
        int startStartX = startX = 136 + (noUnset || noBan ? 45 : 60) + 5;
        String section = null;
        if (showSourceSection && key.contains(".")) {
            section = key.substring(0, key.indexOf(46));
            class_2960 id = new class_2960("fabrication", "category/" + section + ".png");
            RenderSystem.setShaderTexture((int)0, (class_2960)id);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            drawContext.method_25290(id, startX - 2, 0, 0.0f, 0.0f, 12, 12, 12, 12);
            startX += 14;
        }
        Object drawTitle = title;
        String drawDesc = desc;
        if (highlightQueryMatch) {
            drawTitle = this.queryPattern.matcher((CharSequence)drawTitle).replaceAll("\u00a7e\u00a7l$0\u00a7r");
            drawDesc = this.queryPattern.matcher(drawDesc).replaceAll("\u00a7e\u00a7l$0\u00a7r");
        }
        if (failed != null) {
            drawTitle = (String)drawTitle + (failed.startsWith("Requires") || failed.startsWith("Not Ported") ? " \u00a7e " : " \u00a74 ") + failed;
        }
        int n = endX = startY == (y = (int)((float)y + (float)this.drawWrappedText(drawContext, startX, 2.0f, (String)drawTitle, this.field_22789 - startX - 6, 0xFFFFFF | textAlpha, false) * scale)) - 8 ? this.field_22789 - 6 : startX + this.field_22793.method_1727(title);
        if (mouseX >= (float)(134 + trackSize) && mouseX <= (float)endX && mouseY >= (float)(startY + 1) && mouseY <= (float)(startY + 10) && this.submenus.containsKey(key)) {
            if (this.didClick) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                Map<String, FeatureSubmenu> menus = this.submenus.get(key);
                if (menus.size() == 1) {
                    this.field_22787.method_1507(menus.values().stream().findAny().get().construct(this, this.prideFlag, title, key));
                } else {
                    this.field_22787.method_1507(new SelectionScreen<Object>(this, new ArrayList<String>(menus.keySet()), s -> ((FeatureSubmenu)menus.get(s)).construct(this, this.prideFlag, title, key)));
                }
            }
            drawContext.method_25294(startX - 2, 9, endX, 10, -1);
        }
        matrices.method_22909();
        if ((!"search".equals(this.selectedSection) && mouseX <= (float)(this.field_22789 - 120) || mouseY >= 16.0f) && mouseY < (float)(this.field_22790 - 20)) {
            if (section != null && mouseX >= (float)startStartX && mouseX <= (float)startX && mouseY >= (float)startY && mouseY <= (float)y) {
                this.renderWrappedTooltip(drawContext, FeaturesFile.get((String)section).shortName, mouseX, mouseY);
            } else if (mouseX >= (float)startX && mouseX <= (float)endX && mouseY >= (float)startY && mouseY <= (float)y) {
                Object prefix = "";
                if (clientOnly) {
                    prefix = (String)prefix + "\u00a76Client Only ";
                }
                if (requiresFabricApi) {
                    prefix = (String)prefix + "\u00a7bRequires Fabric API ";
                }
                if (!((String)prefix).isEmpty()) {
                    prefix = (String)prefix + "\u00a7r\n";
                }
                this.renderWrappedTooltip(drawContext, (String)prefix + drawDesc, mouseX, mouseY);
            } else if (mouseX >= 134.0f && mouseX <= (float)(134 + trackSize) && mouseY >= (float)startY && mouseY <= (float)(startY + 10)) {
                if (disabled) {
                    if (noFabricApi) {
                        drawContext.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "This option requires Fabric API")), (int)mouseX, (int)mouseY);
                    } else if (noValue) {
                        drawContext.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "The server does not recognize this option")), (int)mouseX, (int)mouseY);
                    } else if (banned) {
                        drawContext.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "This feature is banned by the server")), (int)mouseX, (int)mouseY);
                    } else {
                        drawContext.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "You cannot configure this server")), (int)mouseX, (int)mouseY);
                    }
                } else if (failed != null) {
                    drawContext.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "This feature failed to initialize, reason: " + failed)), (int)mouseX, (int)mouseY);
                } else {
                    int index = (int)((mouseX - 134.0f) / (float)(noUnset ? 22 : (onlyBannable ? 30 : 15)));
                    if (onlyBannable) {
                        if (clickedIndex == 0) {
                            drawContext.method_51434(this.field_22793, (List)Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43470((String)"\u00a77Ban"), class_2561.method_43470((String)"Disallow use by clients")}), (int)mouseX, (int)mouseY);
                        } else {
                            drawContext.method_51434(this.field_22793, (List)Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43470((String)"\u00a7eUnset"), class_2561.method_43470((String)"Allow use by clients")}), (int)mouseX, (int)mouseY);
                        }
                    } else if (clickedIndex == (noUnset || noBan ? 0 : 1)) {
                        drawContext.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)"\u00a7cDisable"), (int)mouseX, (int)mouseY);
                    } else if (clickedIndex == (noUnset ? -99 : (noBan ? 1 : 2))) {
                        if (currentValue == ConfigValues.Feature.UNSET) {
                            drawContext.method_51434(this.field_22793, (List)Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43470((String)"\u00a7eUse default value \u00a7f(see General > Profile)"), class_2561.method_43470((String)("\u00a7rCurrent default: " + (keyEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled")))}), (int)mouseX, (int)mouseY);
                        } else {
                            drawContext.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)"\u00a7eUse default value \u00a7f(see General > Profile)"), (int)mouseX, (int)mouseY);
                        }
                    } else if (clickedIndex == 0) {
                        ArrayList li = Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43470((String)"\u00a77Ban"), class_2561.method_43470((String)"Prevent feature from loading entirely")});
                        if (this.configuringServer) {
                            li.add(class_2561.method_43470((String)"and disallow usage by clients"));
                        }
                        drawContext.method_51434(this.field_22793, (List)li, (int)mouseX, (int)mouseY);
                    } else {
                        drawContext.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)"\u00a7aEnable"), (int)mouseX, (int)mouseY);
                    }
                }
            }
        }
        return y + 2;
    }

    private void renderWrappedTooltip(class_332 drawContext, String str, float mouseX, float mouseY) {
        this.renderOrderedTooltip(drawContext, this.field_22793.method_1728((class_5348)class_2561.method_43470((String)str), mouseX < (float)(this.field_22789 / 2) ? (int)((float)this.field_22789 - mouseX - 30.0f) : (int)mouseX - 20), (int)mouseX, (int)(20.0f + mouseY));
    }

    private void playErrorFeedback() {
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_18310.comp_349()), (float)0.8f, (float)1.0f));
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_18310.comp_349()), (float)0.7f, (float)1.0f));
        this.tooltipBlinkTicks = 20;
    }

    public static String formatTitleCase(String in) {
        String[] pieces = new String[]{in};
        if (in.contains(" ")) {
            pieces = in.toLowerCase().split(" ");
        } else if (in.contains("_")) {
            pieces = in.toLowerCase().split("_");
        }
        StringBuilder result = new StringBuilder();
        for (String s : pieces) {
            String t;
            if (s == null || (t = s.trim().toLowerCase()).isEmpty()) continue;
            result.append(Character.toUpperCase(t.charAt(0)));
            if (t.length() > 1) {
                result.append(t.substring(1));
            }
            result.append(" ");
        }
        return result.toString().trim();
    }

    private void color(int packed) {
        this.color(packed, (float)(packed >> 24 & 0xFF) / 255.0f);
    }

    private void color(int packed, float alpha) {
        RenderSystem.setShaderColor((float)((float)(packed >> 16 & 0xFF) / 255.0f), (float)((float)(packed >> 8 & 0xFF) / 255.0f), (float)((float)(packed >> 0 & 0xFF) / 255.0f), (float)alpha);
    }

    public void method_25419() {
        if (this.field_22787.field_1687 == null) {
            FabConf.setWorldPath(null);
        }
        if (!FabConf.isEnabled("*.reduced_motion") && !this.leaving) {
            this.leaving = true;
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17603, (float)0.7f));
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_21933, (float)2.0f, (float)1.0f));
        } else {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25393() {
        float h;
        super.method_25393();
        if (this.sidebarHeight > (float)this.field_22790) {
            this.lastSidebarScroll = this.sidebarScroll;
            this.sidebarScroll += (this.sidebarScrollTarget - this.sidebarScroll) / 2.0f;
            if (this.sidebarScrollTarget < 0.0f) {
                this.sidebarScrollTarget /= 2.0f;
            }
            if (this.sidebarScrollTarget > (h = this.sidebarHeight - (float)this.field_22790)) {
                this.sidebarScrollTarget = h + (this.sidebarScrollTarget - h) / 2.0f;
            }
        }
        if (this.selectedSectionHeight > (float)(this.field_22790 - 36)) {
            this.lastSelectedSectionScroll = this.selectedSectionScroll;
            this.selectedSectionScroll += (this.selectedSectionScrollTarget - this.selectedSectionScroll) / 2.0f;
            if (this.selectedSectionScrollTarget < 0.0f) {
                this.selectedSectionScrollTarget /= 2.0f;
            }
            if (this.selectedSectionScrollTarget > (h = this.selectedSectionHeight - (float)(this.field_22790 - 36))) {
                this.selectedSectionScrollTarget = h + (this.selectedSectionScrollTarget - h) / 2.0f;
            }
        }
        if (this.prevSelectedSectionHeight > (float)(this.field_22790 - 36)) {
            this.lastPrevSelectedSectionScroll = this.prevSelectedSectionScroll;
            this.prevSelectedSectionScroll += (this.prevSelectedSectionScrollTarget - this.prevSelectedSectionScroll) / 2.0f;
            if (this.prevSelectedSectionScrollTarget < 0.0f) {
                this.prevSelectedSectionScrollTarget /= 2.0f;
            }
            if (this.prevSelectedSectionScrollTarget > (h = this.prevSelectedSectionHeight - (float)(this.field_22790 - 36))) {
                this.prevSelectedSectionScrollTarget = h + (this.prevSelectedSectionScrollTarget - h) / 2.0f;
            }
        }
        if (this.tooltipBlinkTicks > 0) {
            --this.tooltipBlinkTicks;
        }
        this.searchField.method_1865();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (mouseX <= 120.0) {
            this.sidebarScrollTarget = (float)((double)this.sidebarScrollTarget - amount * 20.0);
        } else {
            this.selectedSectionScrollTarget = (float)((double)this.selectedSectionScrollTarget - amount * 20.0);
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (mouseX > (double)(this.field_22789 - 120) && mouseY < 16.0) {
                if (this.configuringServer) {
                    this.serverAnimateTime = 10.0f - this.serverAnimateTime;
                    this.configuringServer = false;
                    this.hasClonked = false;
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_14776.comp_349()), (float)0.8f, (float)1.0f));
                } else if (this.field_22787.field_1687 == null) {
                    this.hasClonked = false;
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_14776.comp_349()), (float)0.8f, (float)1.0f));
                    this.serverAnimateTime = 10.0f - this.serverAnimateTime;
                    FabConf.setWorldPath(null);
                    if (!this.editingWorldPath) {
                        this.openWorldSelector();
                        return super.method_25402(mouseX, mouseY, button);
                    }
                    this.editingWorldPath = false;
                } else if (this.isSingleplayer) {
                    this.hasClonked = false;
                    this.serverAnimateTime = 10.0f - this.serverAnimateTime;
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_14776.comp_349()), (float)0.8f, (float)1.0f));
                    this.editingWorldPath = !this.editingWorldPath;
                } else if (this.whyCantConfigureServer == null) {
                    this.hasClonked = false;
                    this.serverAnimateTime = 10.0f - this.serverAnimateTime;
                    this.configuringServer = true;
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_14776.comp_349()), (float)1.2f, (float)1.0f));
                } else {
                    this.playErrorFeedback();
                }
            }
            this.didClick = true;
        }
        if ("search".equals(this.selectedSection)) {
            this.searchField.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void openWorldSelector() {
        try {
            Path savesDir = this.field_22787.method_1586().method_19636();
            if (Files.isDirectory(savesDir, new LinkOption[0])) {
                List files = Arrays.stream(savesDir.toFile().listFiles()).filter(f -> {
                    if (!f.isDirectory()) {
                        return false;
                    }
                    try {
                        return !class_5125.method_26804((Path)f.toPath());
                    }
                    catch (Exception var10) {
                        return false;
                    }
                }).map(x$0 -> new DrawableSave((File)x$0)).collect(Collectors.toList());
                if (files.isEmpty()) {
                    return;
                }
                if (files.size() == 1) {
                    this.setWorldMode(((DrawableSave)files.get(0)).val());
                } else {
                    this.field_22787.method_1507(new SelectionScreen<File>(this, files, this::setWorldMode));
                }
            }
        }
        catch (Exception e) {
            FabLog.error("Failed to load levels", e);
        }
    }

    public void setWorldMode(Object toFile) {
        this.editingWorldPath = true;
        FabConf.setWorldPath(((File)toFile).toPath());
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if ("search".equals(this.selectedSection)) {
            this.searchField.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        } else {
            this.mouseDragging = true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if ("search".equals(this.selectedSection)) {
            this.searchField.method_16014(mouseX, mouseY);
        }
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if ("search".equals(this.selectedSection)) {
            this.searchField.method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25400(char chr, int modifiers) {
        if ("search".equals(this.selectedSection)) {
            this.searchField.method_25400(chr, modifiers);
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 266: {
                this.method_25401(this.lastMouseX, this.lastMouseY, 20.0);
                break;
            }
            case 267: {
                this.method_25401(this.lastMouseX, this.lastMouseY, -20.0);
                break;
            }
            case 265: {
                this.method_25401(this.lastMouseX, this.lastMouseY, 2.0);
                break;
            }
            case 264: {
                this.method_25401(this.lastMouseX, this.lastMouseY, -2.0);
            }
        }
        if ("search".equals(this.selectedSection)) {
            this.searchField.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if ("search".equals(this.selectedSection)) {
            this.searchField.method_16803(keyCode, scanCode, modifiers);
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    private String getVersion() {
        if (this.configuringServer) {
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerVersion();
        }
        return EarlyAgnos.getModVersion();
    }

    private boolean isFailed(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerFailedConfig().containsKey(key);
        }
        return FabConf.isFailed(key);
    }

    private String getFailed(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerFailedConfig().get(key);
        }
        return FabConf.getFailed(key);
    }

    private boolean isValid(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerTrileanConfig().containsKey(key) || ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerStringConfig().containsKey(key);
        }
        return FabConf.isValid(key);
    }

    private ConfigValues.ResolvedFeature getResolvedValue(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerTrileanConfig().getOrDefault(key, ConfigValues.ResolvedFeature.DEFAULT_FALSE);
        }
        return FabConf.getResolvedValue(key, this.editingWorldPath);
    }

    private ConfigValues.Feature getValue(String key) {
        return this.getResolvedValue((String)key).feature;
    }

    private boolean isEnabled(String key) {
        return this.getResolvedValue((String)key).value;
    }

    private String getRawValue(String key) {
        if (this.configuringServer) {
            String k;
            ConfigValues.ResolvedFeature f = ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerTrileanConfig().get(key);
            if (f == null) {
                k = ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerStringConfig().get(key);
                if (k == null) {
                    return null;
                }
            } else {
                k = f.toString();
            }
            return k.toLowerCase(Locale.ROOT);
        }
        return FabConf.getRawValue(key);
    }

    private void setValue(String key, String value) {
        Set<String> newlyUnbannedKeys;
        Set<String> newlyBannedKeys;
        if (this.configuringServer) {
            this.checkServerData();
            newlyBannedKeys = newlyBannedKeysServer;
            newlyUnbannedKeys = newlyUnbannedKeysServer;
        } else {
            newlyBannedKeys = newlyBannedKeysClient;
            newlyUnbannedKeys = newlyUnbannedKeysClient;
        }
        String oldValue = this.getRawValue(key);
        if (!(FabConf.isRuntimeConfigurable(key) || this.configuringServer && FeaturesFile.get((String)key).sides == FeaturesFile.Sides.CLIENT_ONLY || this.editingWorldPath)) {
            if ("banned".equals(value)) {
                if (newlyUnbannedKeys.contains(key)) {
                    newlyUnbannedKeys.remove(key);
                } else {
                    newlyBannedKeys.add(key);
                }
            } else if ("banned".equals(oldValue)) {
                if (newlyBannedKeys.contains(key)) {
                    newlyBannedKeys.remove(key);
                } else {
                    newlyUnbannedKeys.add(key);
                }
            }
        }
        if (this.configuringServer) {
            class_2540 data = new class_2540(Unpooled.buffer());
            data.method_10804(1);
            data.method_10814(key);
            data.method_10814(value);
            this.field_22787.method_1562().method_2883((class_2596)new class_2817(new class_2960("fabrication", "config"), data));
        } else if (this.editingWorldPath && FabConf.hasWorldPath()) {
            FabConf.worldSet(key, value);
            if (FabricationMod.isAvailableFeature(key)) {
                FabricationMod.updateFeature(key);
            }
        } else {
            FabConf.set(key, value);
            if (FabricationMod.isAvailableFeature(key)) {
                FabricationMod.updateFeature(key);
            }
        }
    }

    public static float sCurve5(float a) {
        float a3 = a * a * a;
        float a4 = a3 * a;
        float a5 = a4 * a;
        return 6.0f * a5 - 15.0f * a4 + 10.0f * a3;
    }

    /*
     * WARNING - void declaration
     */
    public void renderOrderedTooltip(class_332 drawContext, List<? extends class_5481> lines, int x, int y) {
        if (!lines.isEmpty()) {
            int n;
            if (this.bufferTooltips) {
                int yf = y;
                this.bufferedTooltips.add(() -> this.renderOrderedTooltip(drawContext, lines, x, yf));
                return;
            }
            if (y < 20) {
                y += 20;
            }
            int maxWidth = 0;
            for (class_5481 class_54812 : lines) {
                int width = this.field_22793.method_30880(class_54812);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            int innerX = x + 12;
            int n2 = y - 12;
            int totalHeight = 8;
            if (lines.size() > 1) {
                totalHeight += (lines.size() - 1) * 10;
            }
            if (innerX + maxWidth > this.field_22789) {
                innerX -= 28 + maxWidth;
            }
            if (n2 + totalHeight + 6 > this.field_22790) {
                n = this.field_22790 - totalHeight - 6;
            }
            class_4587 matrices = drawContext.method_51448();
            matrices.method_22903();
            drawContext.method_25294(innerX - 3, n - 3, innerX + maxWidth + 3, n + totalHeight + 3, -1442840576);
            class_4597.class_4598 vcp = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            matrices.method_46416(0.0f, 0.0f, 400.0f);
            for (int i = 0; i < lines.size(); ++i) {
                class_5481 line = lines.get(i);
                if (line != null) {
                    void var7_12;
                    this.field_22793.method_22942(line, (float)innerX, (float)var7_12, -1, false, matrices.method_23760().method_23761(), (class_4597)vcp, class_327.class_6415.field_33993, 0, 0xF000F0);
                }
                var7_12 += 10;
            }
            vcp.method_22993();
            matrices.method_22909();
        }
    }

    @FunctionalInterface
    public static interface FeatureSubmenu {
        public class_437 construct(class_437 var1, PrideFlagRenderer var2, String var3, String var4);
    }

    public static enum ConfigValueFlag {
        CLIENT_ONLY,
        REQUIRES_FABRIC_API,
        SHOW_SOURCE_SECTION,
        HIGHLIGHT_QUERY_MATCH;

    }

    public class DrawableSave
    implements SelectionScreen.PreciseDrawable<File> {
        final File file;
        class_2960 icon;

        public DrawableSave(File file) {
            this.file = file;
            File iconFile = new File(file, "icon.png");
            this.icon = new class_2960("fabrication", "worlds/" + this.hashCode());
            if (iconFile.isFile()) {
                try {
                    FileInputStream inputStream = new FileInputStream(iconFile);
                    class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                    class_1043 nativeImageBackedTexture = new class_1043(nativeImage);
                    FabricationConfigScreen.this.field_22787.method_1531().method_4616(this.icon, (class_1044)nativeImageBackedTexture);
                    inputStream.close();
                }
                catch (Throwable e) {
                    FabLog.error("Invalid icon for world {}", e);
                    this.icon = null;
                }
            } else {
                FabricationConfigScreen.this.field_22787.method_1531().method_4615(this.icon);
                this.icon = null;
            }
        }

        @Override
        public void render(class_332 drawContext, float x, float y, float delta) {
            drawContext.method_51433(FabricationConfigScreen.this.field_22793, this.file.getName(), (int)(38.0f + x), (int)y, -1, true);
            drawContext.method_51433(FabricationConfigScreen.this.field_22793, this.file.getPath(), (int)(38.0f + x), (int)(y + 20.0f), -1, true);
            class_4587 matrices = drawContext.method_51448();
            if (this.icon != null) {
                RenderSystem.setShaderTexture((int)0, (class_2960)this.icon);
                matrices.method_22903();
                matrices.method_46416(x % 1.0f, y % 1.0f, 0.0f);
                drawContext.method_25291(this.icon, (int)x, (int)y, 0, 0.0f, 0.0f, 32, 32, 32, 32);
                matrices.method_22909();
            }
        }

        @Override
        public int width() {
            return 38 + FabricationConfigScreen.this.field_22793.method_1727(this.file.getPath());
        }

        @Override
        public int height() {
            return 38;
        }

        @Override
        public File val() {
            return this.file;
        }
    }
}

