/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_7367;

public class FabricationResourcePack
implements class_3262 {
    private final String path;
    private final JsonObject meta;

    public FabricationResourcePack(String path) {
        JsonObject meta;
        this.path = path;
        try {
            meta = (JsonObject)new Gson().fromJson(Resources.toString((URL)this.url("pack.mcmeta"), (Charset)Charsets.UTF_8), JsonObject.class);
        }
        catch (Throwable t) {
            FabLog.warn("Failed to load meta for internal resource pack " + path);
            meta = new JsonObject();
        }
        this.meta = meta;
    }

    @Environment(value=EnvType.CLIENT)
    public class_7367<InputStream> method_14410(String ... seg) {
        if (seg.length == 0) {
            return null;
        }
        if ("pack.png".equals(seg[0])) {
            return new class_7367<InputStream>(){

                public InputStream get() {
                    return this.getClass().getClassLoader().getResourceAsStream("assets/fabrication/icon.png");
                }
            };
        }
        final InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.path + "/" + String.join((CharSequence)"/", seg));
        if (is == null) {
            return null;
        }
        return new class_7367<InputStream>(){

            public InputStream get() {
                return is;
            }
        };
    }

    private URL url(class_3264 type, class_2960 id) {
        return this.url(type.method_14413() + "/" + id.method_12836() + "/" + id.method_12832());
    }

    private URL url(String path) {
        return this.getClass().getClassLoader().getResource("packs/" + this.path + "/" + path);
    }

    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        final URL u = this.url(type, id);
        if (u == null) {
            return null;
        }
        return new class_7367<InputStream>(){

            public InputStream get() throws IOException {
                return u.openStream();
            }
        };
    }

    public void method_14408(class_3264 type, String namespace, String prefix, class_3262.class_7664 consumer) {
        String prePath = "packs/" + this.path + "/" + type.method_14413() + "/" + namespace + "/";
        String dirPathStr = prePath + prefix;
        try {
            URL dirUrl = this.getClass().getClassLoader().getResource(dirPathStr);
            if (dirUrl == null) {
                return;
            }
            if ("jar".equals(dirUrl.getProtocol())) {
                JarFile jar = ((JarURLConnection)dirUrl.openConnection()).getJarFile();
                Enumeration<JarEntry> en = jar.entries();
                while (en.hasMoreElements()) {
                    String name = en.nextElement().getName();
                    int i = name.indexOf(dirPathStr);
                    if (i == -1) continue;
                    class_2960 id = new class_2960("fabrication", name.substring(i + prePath.length()));
                    consumer.accept((Object)id, this.method_14405(type, id));
                }
            } else {
                ArrayList<File> dirs = new ArrayList<File>();
                dirs.add(new File(dirUrl.getFile()));
                for (int i = 0; i < dirs.size(); ++i) {
                    File[] files = ((File)dirs.get(i)).listFiles();
                    if (files == null) continue;
                    for (File file : files) {
                        if (file.isDirectory()) {
                            dirs.add(file);
                            continue;
                        }
                        String name = file.getPath();
                        int ix = name.indexOf(dirPathStr);
                        if (ix == -1) continue;
                        class_2960 id = new class_2960("fabrication", name.substring(ix + prePath.length()));
                        consumer.accept((Object)id, this.method_14405(type, id));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Set<String> method_14406(class_3264 type) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.meta.getAsJsonObject("fabrication").getAsJsonArray("namespaces"), JsonElement::getAsString));
    }

    public <T> T method_14407(class_3270<T> metaReader) throws IOException {
        if (!this.meta.has(metaReader.method_14420())) {
            return null;
        }
        return (T)metaReader.method_14421(this.meta.getAsJsonObject(metaReader.method_14420()));
    }

    public String method_14409() {
        return MixinConfigPlugin.MOD_NAME;
    }

    public void close() {
    }
}

