/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.FabricationClientCommands;
import com.unascribed.fabrication.interfaces.SetFabricationConfigAware;
import com.unascribed.fabrication.support.ConfigLoader;
import com.unascribed.fabrication.support.ConfigValues;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.FabricationDefaultResources;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.OptionalFScript;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3898;
import net.minecraft.class_5629;
import net.minecraft.server.MinecraftServer;

public class FabricationMod
implements ModInitializer {
    private static final Map<String, Feature> features = Maps.newHashMap();
    private static final List<Feature> unconfigurableFeatures = Lists.newArrayList();
    private static final Set<String> enabledFeatures = Sets.newHashSet();
    public static final long LAUNCH_ID = ThreadLocalRandom.current().nextLong();
    public static class_3414 LEVELUP_LONG;
    public static class_3414 OOF;
    public static class_3414 ABSORPTION_HURT;
    public static class_2960 CONFIG_ID1;
    public static class_2960 CONFIG_ID2;
    private static final class_2338.class_2339 scratchpos1;
    private static final class_2338.class_2339 scratchpos2;
    private static final class_2338.class_2339 scratchpos3;
    private static final class_2338.class_2339 scratchpos4;

    public void onInitialize() {
        MixinConfigPlugin.loadComplete = true;
        for (String str : MixinConfigPlugin.discoverClassesInPackage("com.unascribed.fabrication.loaders", false)) {
            try {
                FabConf.introduce((ConfigLoader)Class.forName(str).newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (EarlyAgnos.isModLoaded("fscript")) {
            OptionalFScript.reload();
        }
        for (String s : MixinConfigPlugin.discoverClassesInPackage("com.unascribed.fabrication.features", false)) {
            try {
                String key;
                Feature r;
                block12: {
                    r = (Feature)Class.forName(s).newInstance();
                    key = FabConf.remap(r.getConfigKey());
                    if (key == null || FabConf.isEnabled(key)) {
                        try {
                            r.apply();
                            if (key == null) break block12;
                            enabledFeatures.add(key);
                        }
                        catch (Throwable t) {
                            FabricationMod.featureError(r, t, "Unknown");
                            continue;
                        }
                    }
                }
                if (key != null) {
                    features.put(key, r);
                    continue;
                }
                unconfigurableFeatures.add(r);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize feature " + s, e);
            }
        }
        if (EarlyAgnos.getCurrentEnv() == Env.CLIENT) {
            FabricationClientCommands.registerCommands();
            LEVELUP_LONG = class_3414.method_47908((class_2960)new class_2960("fabrication", "levelup_long"));
            OOF = class_3414.method_47908((class_2960)new class_2960("fabrication", "oof"));
            ABSORPTION_HURT = class_3414.method_47908((class_2960)new class_2960("fabrication", "absorption_hurt"));
            FabricationDefaultResources.apply();
        }
    }

    public static void featureError(Feature f, Throwable t, String reason) {
        FabricationMod.featureError(f.getClass(), f.getConfigKey(), t, reason);
    }

    public static void featureError(Class<?> clazz, String configKey, Throwable t, String reason) {
        FabLog.debug("Original feature error", t);
        if (configKey == null) {
            FabLog.warn("Feature " + clazz.getName() + " failed to apply!");
        } else {
            FabLog.warn("Feature " + clazz.getName() + " failed to apply! Force-disabling " + configKey);
        }
        FabConf.addFailure(configKey, reason);
    }

    public static class_2960 createIdWithCustomDefault(String namespace, String pathOrId) {
        if (pathOrId.contains(":")) {
            return new class_2960(pathOrId);
        }
        return new class_2960(namespace, pathOrId);
    }

    public static boolean isAvailableFeature(String configKey) {
        return features.containsKey(FabConf.remap(configKey));
    }

    public static boolean updateFeature(String configKey) {
        configKey = FabConf.remap(configKey);
        boolean enabled = FabConf.isEnabled(configKey);
        if (enabledFeatures.contains(configKey) == enabled) {
            return true;
        }
        if (enabled) {
            features.get(configKey).apply();
            enabledFeatures.add(configKey);
            return true;
        }
        boolean b = features.get(configKey).undo();
        if (b) {
            enabledFeatures.remove(configKey);
        }
        return b;
    }

    public static Set<class_5629> getTrackers(class_1297 entity) {
        class_3215 cm = ((class_3218)entity.method_37908()).method_14178();
        class_3898 tacs = cm.field_17254;
        Int2ObjectMap<class_3898.class_3208> entityTrackers = FabRefl.getEntityTrackers(tacs);
        class_3898.class_3208 tracker = (class_3898.class_3208)entityTrackers.get(entity.method_5628());
        if (tracker == null) {
            return Collections.emptySet();
        }
        return FabRefl.getPlayersTracking(tracker);
    }

    public static void sendToTrackersMatching(class_1297 entity, class_2658 pkt, Predicate<class_3222> predicate) {
        class_3222 spe;
        if (entity.method_37908().field_9236) {
            return;
        }
        Set<class_5629> playersTracking = FabricationMod.getTrackers(entity);
        if (entity instanceof class_3222 && predicate.test(spe = (class_3222)entity)) {
            spe.field_13987.method_14364((class_2596)pkt);
        }
        for (class_5629 etl : playersTracking) {
            class_3222 spe2 = etl.method_32311();
            if (!predicate.test(spe2)) continue;
            spe2.field_13987.method_14364((class_2596)pkt);
        }
    }

    public static void sendConfigUpdate(MinecraftServer server, String key) {
        class_2540 data = null;
        int lastVer = -1;
        List players = server.method_3760().method_14571();
        for (int i = 0; i < players.size(); ++i) {
            int reqVer;
            class_3222 spe = (class_3222)players.get(i);
            if (!(spe instanceof SetFabricationConfigAware) || (reqVer = ((SetFabricationConfigAware)spe).fabrication$getReqVer()) < 0) continue;
            if (data == null || reqVer != lastVer) {
                lastVer = reqVer;
                data = FabricationMod.createConfigUpdateBuf(server, key, reqVer);
            }
            spe.field_13987.method_14364((class_2596)new class_2658(reqVer == 0 ? CONFIG_ID1 : CONFIG_ID2, i + 1 == players.size() ? data : new class_2540(data.copy())));
        }
    }

    public static void sendConfigUpdate(MinecraftServer server, String key, class_3222 spe, int reqVer) {
        spe.field_13987.method_14364((class_2596)new class_2658(reqVer == 0 ? CONFIG_ID1 : CONFIG_ID2, FabricationMod.createConfigUpdateBuf(server, key, reqVer)));
    }

    private static class_2540 createConfigUpdateBuf(MinecraftServer server, String key, int reqVer) {
        if (key != null && key.startsWith("general.category")) {
            key = null;
        }
        class_2540 data = new class_2540(Unpooled.buffer());
        if (reqVer > 0) {
            data.method_10804(1);
        }
        if (key == null) {
            HashMap trileans = Maps.newHashMap();
            HashMap strings = Maps.newHashMap();
            for (String k : FabConf.getAllKeys()) {
                if (k.startsWith("general.category")) {
                    strings.put(k, FabConf.getRawValue(k));
                    continue;
                }
                trileans.put(k, FabConf.getResolvedValue(k));
            }
            data.method_10804(trileans.size());
            trileans.entrySet().forEach(en -> data.method_10814((String)en.getKey()).writeByte(((ConfigValues.ResolvedFeature)((Object)((Object)en.getValue()))).ordinal()));
            data.method_10804(strings.size());
            strings.entrySet().forEach(en -> data.method_10814((String)en.getKey()).method_10814((String)en.getValue()));
            data.writeLong(LAUNCH_ID);
        } else {
            data.method_10804(1);
            data.method_10814(key);
            data.writeByte(FabConf.getResolvedValue(key).ordinal());
            data.method_10804(0);
            data.writeLong(LAUNCH_ID);
        }
        data.method_10814(EarlyAgnos.getModVersion());
        data.method_10804(FabConf.getAllFailures().size());
        if (reqVer > 0) {
            for (Object k : FabConf.getAllFailures().entrySet()) {
                data.method_10814((String)k.getKey());
                data.method_10814((String)k.getValue());
            }
        } else {
            for (Object k : FabConf.getAllFailures().keySet()) {
                data.method_10814((String)k);
            }
        }
        data.method_10804(FabConf.getAllBanned().size());
        for (Object k : FabConf.getAllBanned()) {
            data.method_10814((String)k);
        }
        return data;
    }

    public static void forAllAdjacentBlocks(class_1297 entity, BlockScanCallback callback) {
        class_1937 w = entity.method_37908();
        class_238 box = entity.method_5829();
        if (!FabricationMod.scanBlocks(w, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1322, box.field_1324, class_2350.field_11033, callback)) {
            return;
        }
        if (!FabricationMod.scanBlocks(w, box.field_1323, box.field_1325, box.field_1321, box.field_1320, box.field_1325, box.field_1324, class_2350.field_11036, callback)) {
            return;
        }
        if (!FabricationMod.scanBlocks(w, box.field_1323, box.field_1322, box.field_1321, box.field_1323, box.field_1325, box.field_1324, class_2350.field_11039, callback)) {
            return;
        }
        if (!FabricationMod.scanBlocks(w, box.field_1320, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, class_2350.field_11034, callback)) {
            return;
        }
        if (!FabricationMod.scanBlocks(w, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1321, class_2350.field_11043, callback)) {
            return;
        }
        if (!FabricationMod.scanBlocks(w, box.field_1323, box.field_1322, box.field_1324, box.field_1320, box.field_1325, box.field_1324, class_2350.field_11035, callback)) {
            return;
        }
    }

    private static boolean scanBlocks(class_1937 w, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, class_2350 dir, BlockScanCallback callback) {
        class_2338.class_2339 min = scratchpos1.method_10102(minX + (double)dir.method_10148(), minY + (double)dir.method_10164(), minZ + (double)dir.method_10165());
        class_2338.class_2339 max = scratchpos2.method_10102(maxX + (double)dir.method_10148(), maxY + (double)dir.method_10164(), maxZ + (double)dir.method_10165());
        class_2338.class_2339 mut = scratchpos3;
        if (w.method_22343((class_2338)min, (class_2338)max)) {
            for (int x = min.method_10263(); x <= max.method_10263(); ++x) {
                for (int y = min.method_10264(); y <= max.method_10264(); ++y) {
                    for (int z = min.method_10260(); z <= max.method_10260(); ++z) {
                        mut.method_10103(x, y, z);
                        scratchpos4.method_10101((class_2382)mut);
                        if (callback.invoke(w, mut, scratchpos4, dir)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    static {
        CONFIG_ID1 = new class_2960("fabrication", "config");
        CONFIG_ID2 = new class_2960("fabrication", "config2");
        scratchpos1 = new class_2338.class_2339();
        scratchpos2 = new class_2338.class_2339();
        scratchpos3 = new class_2338.class_2339();
        scratchpos4 = new class_2338.class_2339();
    }

    public static interface BlockScanCallback {
        public boolean invoke(class_1937 var1, class_2338.class_2339 var2, class_2338.class_2339 var3, class_2350 var4);
    }
}

