/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.client.AtlasTracking;
import com.unascribed.fabrication.client.AtlasViewerScreen;
import com.unascribed.fabrication.client.FabricationConfigScreen;
import com.unascribed.fabrication.client.FabricationSummaryScreen;
import com.unascribed.fabrication.client.OptionalFScriptScreen;
import com.unascribed.fabrication.client.OptionalPrideFlag;
import com.unascribed.fabrication.features.FeatureFabricationCommand;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.OptionalFScript;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1059;
import net.minecraft.class_1723;
import net.minecraft.class_2164;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class FabricationClientCommands {
    private static final CommandDispatcher<class_2172> dispatcher = new CommandDispatcher();
    public static String rootCommand = MixinConfigPlugin.MOD_NAME_LOWER + ":client";

    public static void registerCommands() {
        FabricationClientCommands.registerCommands(dispatcher);
    }

    public static boolean runCommand(String command) {
        if (command.isEmpty() || !command.startsWith(rootCommand)) {
            return false;
        }
        try {
            dispatcher.execute(command, (Object)class_310.method_1551().method_1562().method_2875());
        }
        catch (class_2164 ignore) {
            FabricationClientCommands.sendFeedback(ignore.method_9199());
        }
        catch (Exception e) {
            FabLog.error("Failed to execute client command: " + command, e);
            FabricationClientCommands.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7c" + String.valueOf(e))));
        }
        return true;
    }

    public static <T extends class_2172> void addSuggestions(CommandDispatcher<T> dispatcher) {
        FabricationClientCommands.registerCommands(dispatcher);
    }

    private static <T extends class_2172> void registerCommands(CommandDispatcher<T> dispatcher) {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)rootCommand);
        if (EarlyAgnos.isModLoaded("fscript")) {
            FabricationClientCommands.addFScript(root);
        }
        FeatureFabricationCommand.addConfig(root, false);
        root.then(LiteralArgumentBuilder.literal((String)"ui").executes(c -> {
            class_310.method_1551().method_18858(() -> class_310.method_1551().method_1507((class_437)new FabricationConfigScreen(null)));
            return 1;
        }));
        root.then(LiteralArgumentBuilder.literal((String)"summary_ui").executes(c -> {
            class_310.method_1551().method_18858(() -> {
                FabricationSummaryScreen screen = FabricationSummaryScreen.tryCreate(null);
                if (screen == null) {
                    FabricationClientCommands.sendFeedback(class_2561.method_30163((String)("Server isn't running " + MixinConfigPlugin.MOD_NAME)));
                } else {
                    class_310.method_1551().method_1507((class_437)screen);
                }
            });
            return 1;
        }));
        if (!FabConf.isFailed("atlas_viewer")) {
            root.then(LiteralArgumentBuilder.literal((String)"atlas").then(LiteralArgumentBuilder.literal((String)"view").then(RequiredArgumentBuilder.argument((String)"atlas", (ArgumentType)new AtlasArgumentType()).executes(c -> {
                class_310.method_1551().method_18858(() -> class_310.method_1551().method_1507((class_437)new AtlasViewerScreen((class_2960)c.getArgument("atlas", class_2960.class))));
                return 1;
            }))));
        }
        dispatcher.register(root);
    }

    public static <T extends class_2172> void addFScript(LiteralArgumentBuilder<T> root) {
        LiteralArgumentBuilder script = LiteralArgumentBuilder.literal((String)"fscript");
        LiteralArgumentBuilder ui = LiteralArgumentBuilder.literal((String)"ui");
        for (String s : OptionalFScript.predicateProviders.keySet()) {
            LiteralArgumentBuilder key = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)s).executes(c -> {
                class_310.method_1551().method_18858(() -> class_310.method_1551().method_1507(OptionalFScriptScreen.construct(null, OptionalPrideFlag.get(), FeaturesFile.get((String)s).name, s)));
                return 1;
            });
            ui.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s, alt -> ui.then(LiteralArgumentBuilder.literal((String)alt).executes(key.getCommand())));
        }
        script.then((ArgumentBuilder)ui);
        root.then((ArgumentBuilder)script);
    }

    public static void sendFeedback(class_2561 text) {
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"\u00a7b[CLIENT]\u00a7r ").method_10852(text));
    }

    public static class AtlasArgumentType
    implements ArgumentType<class_2960> {
        public class_2960 parse(StringReader reader) throws CommandSyntaxException {
            class_2960 id = class_2960.method_12835((StringReader)reader);
            for (class_1059 sat : AtlasTracking.allAtlases) {
                if (!sat.method_24106().equals((Object)id)) continue;
                return id;
            }
            throw new class_2164((class_2561)class_2561.method_43470((String)("There is no atlas with ID " + String.valueOf(id))));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (class_1059 sat : AtlasTracking.allAtlases) {
                builder.suggest(sat.method_24106().toString());
            }
            return builder.buildFuture();
        }

        public Collection<String> getExamples() {
            return Collections.singleton(class_1723.field_21668.toString());
        }
    }
}

