/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.izofar.bygonenether.entity.PiglinPrisoner;
import com.izofar.bygonenether.entity.ai.behaviour.ModFollowLeader;
import com.izofar.bygonenether.entity.ai.behaviour.ModStartAdmiringItemIfSeen;
import com.izofar.bygonenether.entity.ai.behaviour.ModStopAdmiringIfItemTooFarAway;
import com.izofar.bygonenether.entity.ai.behaviour.ModStopAdmiringIfTiredOfTryingToReachItem;
import com.izofar.bygonenether.entity.ai.behaviour.ModStopHoldingItemIfNoLongerAdmiring;
import com.izofar.bygonenether.init.ModEntityTypes;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4106;
import net.minecraft.class_4107;
import net.minecraft.class_4109;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4121;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4802;
import net.minecraft.class_4807;
import net.minecraft.class_4809;
import net.minecraft.class_4810;
import net.minecraft.class_4813;
import net.minecraft.class_4814;
import net.minecraft.class_4815;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_4829;
import net.minecraft.class_4836;
import net.minecraft.class_4838;
import net.minecraft.class_5418;
import net.minecraft.class_5534;
import net.minecraft.class_6019;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_7898;

public class PiglinPrisonerAi {
    private static final class_6019 AVOID_ZOMBIFIED_DURATION = class_4802.method_24505((int)5, (int)7);
    private static final int CELEBRATION_TIME = 200;
    private static final Predicate<class_1314> isDistracted = mob -> {
        if (mob instanceof PiglinPrisoner) {
            PiglinPrisoner piglinPrisoner = (PiglinPrisoner)((Object)mob);
            class_4095<PiglinPrisoner> brain = piglinPrisoner.method_18868();
            return brain.method_18896(class_4140.field_22332) || brain.method_18896(class_4140.field_25360) || brain.method_18896(class_4140.field_22357) || brain.method_18904(class_4140.field_25159).orElse(false) != false || brain.method_18904(class_4140.field_28327).orElse(false) == false;
        }
        return false;
    };

    public static class_4095<?> makeBrain(PiglinPrisoner piglinPrisoner, class_4095<PiglinPrisoner> brain) {
        PiglinPrisonerAi.initCoreActivity(brain);
        PiglinPrisonerAi.initIdleActivity(brain);
        PiglinPrisonerAi.initAdmireItemActivity(brain);
        PiglinPrisonerAi.initFightActivity(piglinPrisoner, brain);
        PiglinPrisonerAi.initCelebrateActivity(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void initCoreActivity(class_4095<PiglinPrisoner> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)((Object)new ModFollowLeader(isDistracted)), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)class_4107.method_46964(), PiglinPrisonerAi.avoidZombified(), new ModStopHoldingItemIfNoLongerAdmiring(), new ModStartAdmiringItemIfSeen(120), (Object)class_4829.method_47143()));
    }

    private static void initIdleActivity(class_4095<PiglinPrisoner> brain) {
        brain.method_18882(class_4168.field_18595, 10, ImmutableList.of((Object)class_4119.method_47065(PiglinPrisonerAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)class_4824.method_47120(class_5418::method_30236, PiglinPrisonerAi::findNearestValidAttackTarget), PiglinPrisonerAi.avoidRepellent(), PiglinPrisonerAi.createIdleLookBehaviors(), PiglinPrisonerAi.createIdleMovementBehaviors(), (Object)class_4109.method_47082((class_1299)class_1299.field_6097, (int)4)));
    }

    private static void initFightActivity(PiglinPrisoner piglinPrisoner, class_4095<PiglinPrisoner> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)class_4828.method_47138(target -> !PiglinPrisonerAi.isNearestValidAttackTarget(piglinPrisoner, target)), (Object)class_7898.method_47227(PiglinPrisonerAi::hasCrossbow, (class_7894)class_4807.method_46901((int)5, (float)0.75f)), (Object)class_4822.method_47094((float)1.0f), (Object)class_4816.method_46987((int)20), (Object)new class_4810(), (Object)class_4813.method_46922(PiglinPrisonerAi::isNearZombified, (class_4140)class_4140.field_22355)), class_4140.field_22355);
    }

    private static void initCelebrateActivity(class_4095<PiglinPrisoner> brain) {
        brain.method_24527(class_4168.field_22397, 10, ImmutableList.of(PiglinPrisonerAi.avoidRepellent(), (Object)class_4119.method_47065(PiglinPrisonerAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)class_4824.method_47120(class_5418::method_30236, PiglinPrisonerAi::findNearestValidAttackTarget), (Object)class_7898.method_47227(PiglinPrisoner::isDancing, (class_7894)class_4814.method_46941((class_4140)class_4140.field_22337, (int)2, (float)1.0f)), (Object)class_7898.method_47227(PiglinPrisoner::isDancing, (class_7894)class_4814.method_46941((class_4140)class_4140.field_22337, (int)4, (float)0.6f)), (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057(ModEntityTypes.PIGLIN_PRISONER, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4818.method_47015((float)0.6f, (int)2, (int)1), (Object)1), (Object)Pair.of((Object)new class_4101(10, 20), (Object)1)))), class_4140.field_22337);
    }

    private static void initAdmireItemActivity(class_4095<PiglinPrisoner> brain) {
        brain.method_24527(class_4168.field_22398, 10, ImmutableList.of((Object)class_4815.method_46947(PiglinPrisonerAi::isNotHoldingLovedItemInOffHand, (float)1.0f, (boolean)true, (int)9), new ModStopAdmiringIfItemTooFarAway(9), new ModStopAdmiringIfTiredOfTryingToReachItem(200, 200)), class_4140.field_22334);
    }

    private static class_4118<PiglinPrisoner> createIdleLookBehaviors() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_22281, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47057(ModEntityTypes.PIGLIN_PRISONER, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47056((float)8.0f), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    private static class_4118<PiglinPrisoner> createIdleMovementBehaviors() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.6f), (Object)2), (Object)Pair.of((Object)class_4106.method_18941((class_1299)class_1299.field_22281, (int)8, (class_4140)class_4140.field_18447, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)class_4106.method_18941(ModEntityTypes.PIGLIN_PRISONER, (int)8, (class_4140)class_4140.field_18447, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    private static class_7893<class_1314> avoidRepellent() {
        return class_4121.method_47091((class_4140)class_4140.field_22474, (float)1.0f, (int)8, (boolean)false);
    }

    private static class_7893<PiglinPrisoner> avoidZombified() {
        return class_4809.method_46914(PiglinPrisonerAi::isNearZombified, (class_4140)class_4140.field_22346, (class_4140)class_4140.field_22357, (class_6019)AVOID_ZOMBIFIED_DURATION);
    }

    public static void updateActivity(PiglinPrisoner piglinPrisoner) {
        class_4095<PiglinPrisoner> brain = piglinPrisoner.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_22398, (Object)class_4168.field_22396, (Object)class_4168.field_22399, (Object)class_4168.field_22397, (Object)class_4168.field_18595));
        class_4168 activity1 = brain.method_24538().orElse(null);
        if (activity != activity1) {
            PiglinPrisonerAi.getSoundForCurrentActivity(piglinPrisoner).ifPresent(piglinPrisoner::method_43077);
        }
        piglinPrisoner.method_19540(brain.method_18896(class_4140.field_22355));
        if (!brain.method_18896(class_4140.field_22337)) {
            brain.method_18875(class_4140.field_25159);
        }
        piglinPrisoner.setDancing(brain.method_18896(class_4140.field_25159));
    }

    public static boolean isPiglinCurrency(class_1799 stack) {
        return stack.method_7909() == class_4838.field_23826;
    }

    public static void pickUpItem(PiglinPrisoner piglinPrisoner, class_1542 itemEntity) {
        class_1799 itemstack;
        PiglinPrisonerAi.stopWalking(piglinPrisoner);
        if (itemEntity.method_6983().method_31574(class_1802.field_8397)) {
            piglinPrisoner.method_6103((class_1297)itemEntity, itemEntity.method_6983().method_7947());
            itemstack = itemEntity.method_6983();
            itemEntity.method_31472();
        } else {
            piglinPrisoner.method_6103((class_1297)itemEntity, 1);
            itemstack = PiglinPrisonerAi.removeOneItemFromItemEntity(itemEntity);
        }
        if (PiglinPrisonerAi.isLovedItem(itemstack)) {
            piglinPrisoner.method_18868().method_18875(class_4140.field_25813);
            PiglinPrisonerAi.holdInOffhand(piglinPrisoner, itemstack);
            PiglinPrisonerAi.admireGoldItem((class_1309)piglinPrisoner);
        } else if (PiglinPrisonerAi.isFood(itemstack) && !PiglinPrisonerAi.hasEatenRecently(piglinPrisoner)) {
            PiglinPrisonerAi.eat(piglinPrisoner);
        } else if (piglinPrisoner.method_24523(itemstack).method_7960()) {
            PiglinPrisonerAi.putInInventory(piglinPrisoner, itemstack);
        }
    }

    private static void holdInOffhand(PiglinPrisoner piglinPrisoner, class_1799 stack) {
        if (PiglinPrisonerAi.isHoldingItemInOffHand(piglinPrisoner)) {
            piglinPrisoner.method_5775(piglinPrisoner.method_5998(class_1268.field_5810));
        }
        piglinPrisoner.holdInOffHand(stack);
    }

    private static class_1799 removeOneItemFromItemEntity(class_1542 itemEntity) {
        class_1799 itemstack = itemEntity.method_6983();
        class_1799 itemstack1 = itemstack.method_7971(1);
        if (itemstack.method_7960()) {
            itemEntity.method_31472();
        } else {
            itemEntity.method_6979(itemstack);
        }
        return itemstack1;
    }

    public static void stopHoldingOffHandItem(PiglinPrisoner piglinPrisoner, boolean shouldThrowItems) {
        class_1799 itemstack = piglinPrisoner.method_5998(class_1268.field_5810);
        piglinPrisoner.method_6122(class_1268.field_5810, class_1799.field_8037);
        boolean flag = PiglinPrisonerAi.isPiglinCurrency(itemstack);
        if (shouldThrowItems && flag) {
            PiglinPrisonerAi.putInInventory(piglinPrisoner, itemstack);
        } else if (!flag) {
            boolean flag1;
            boolean bl = flag1 = !piglinPrisoner.method_24523(itemstack).method_7960();
            if (!flag1) {
                PiglinPrisonerAi.throwItems(piglinPrisoner, Collections.singletonList(itemstack));
            }
        }
    }

    public static void throwItems(PiglinPrisoner piglinPrisoner, List<class_1799> stackList) {
        class_1657 tempter = piglinPrisoner.getTempter();
        Optional optional = piglinPrisoner.method_18868().method_18904(class_4140.field_18444);
        if (tempter != null) {
            PiglinPrisonerAi.throwItemsTowardPlayer(piglinPrisoner, tempter, stackList);
        } else if (optional.isPresent()) {
            PiglinPrisonerAi.throwItemsTowardPlayer(piglinPrisoner, (class_1657)optional.get(), stackList);
        } else {
            PiglinPrisonerAi.throwItemsTowardRandomPos(piglinPrisoner, stackList);
        }
    }

    private static void throwItemsTowardRandomPos(PiglinPrisoner piglinPrisoner, List<class_1799> stackList) {
        PiglinPrisonerAi.throwItemsTowardPos(piglinPrisoner, stackList, PiglinPrisonerAi.getRandomNearbyPos(piglinPrisoner));
    }

    private static void throwItemsTowardPlayer(PiglinPrisoner piglinPrisoner, class_1657 player, List<class_1799> stackList) {
        PiglinPrisonerAi.throwItemsTowardPos(piglinPrisoner, stackList, player.method_19538());
    }

    private static void throwItemsTowardPos(PiglinPrisoner piglinPrisoner, List<class_1799> stackList, class_243 vec) {
        if (!stackList.isEmpty()) {
            piglinPrisoner.method_6104(class_1268.field_5810);
            for (class_1799 itemstack : stackList) {
                class_4215.method_19949((class_1309)piglinPrisoner, (class_1799)itemstack, (class_243)vec.method_1031(0.0, 1.0, 0.0));
            }
        }
    }

    private static class_243 getRandomNearbyPos(PiglinPrisoner piglinPrisoner) {
        class_243 vec3 = class_5534.method_31527((class_1314)piglinPrisoner, (int)4, (int)2);
        return vec3 == null ? piglinPrisoner.method_19538() : vec3;
    }

    public static void cancelAdmiring(PiglinPrisoner piglinPrisoner) {
        if (PiglinPrisonerAi.isAdmiringItem(piglinPrisoner) && !piglinPrisoner.method_6079().method_7960()) {
            piglinPrisoner.method_5775(piglinPrisoner.method_6079());
            piglinPrisoner.method_6122(class_1268.field_5810, class_1799.field_8037);
        }
    }

    public static boolean wantsToPickup(PiglinPrisoner piglinPrisoner, class_1799 stack) {
        if (stack.method_31573(class_3489.field_23064)) {
            return false;
        }
        if (PiglinPrisonerAi.isAdmiringDisabled(piglinPrisoner) && piglinPrisoner.method_18868().method_18896(class_4140.field_22355)) {
            return false;
        }
        if (PiglinPrisonerAi.isPiglinCurrency(stack) || PiglinPrisonerAi.isLovedItem(stack)) {
            return PiglinPrisonerAi.isNotHoldingLovedItemInOffHand(piglinPrisoner);
        }
        boolean flag = piglinPrisoner.canAddToInventory(stack);
        if (stack.method_31574(class_1802.field_8397)) {
            return flag;
        }
        if (!PiglinPrisonerAi.isLovedItem(stack)) {
            return piglinPrisoner.canReplaceCurrentItem(stack);
        }
        return PiglinPrisonerAi.isNotHoldingLovedItemInOffHand(piglinPrisoner) && flag;
    }

    public static boolean isLovedItem(class_1799 stack) {
        return stack.method_31573(class_3489.field_24481);
    }

    private static boolean isNearestValidAttackTarget(PiglinPrisoner piglinPrisoner, class_1309 target) {
        return PiglinPrisonerAi.findNearestValidAttackTarget(piglinPrisoner).filter(potentialTarget -> potentialTarget == target).isPresent();
    }

    private static boolean isNearZombified(PiglinPrisoner entity) {
        class_4095<PiglinPrisoner> brain = entity.method_18868();
        if (brain.method_18896(class_4140.field_22346)) {
            class_1309 livingentity = (class_1309)brain.method_18904(class_4140.field_22346).get();
            return entity.method_24516((class_1297)livingentity, 6.0);
        }
        return false;
    }

    private static Optional<? extends class_1309> findNearestValidAttackTarget(PiglinPrisoner piglinPrisoner) {
        class_4095<PiglinPrisoner> brain = piglinPrisoner.method_18868();
        if (PiglinPrisonerAi.isNearZombified(piglinPrisoner)) {
            return Optional.empty();
        }
        Optional optional = class_4215.method_24560((class_1309)piglinPrisoner, (class_4140)class_4140.field_22333);
        if (optional.isPresent() && class_4148.method_37456((class_1309)piglinPrisoner, (class_1309)((class_1309)optional.get()))) {
            return optional;
        }
        Optional optional1 = brain.method_18904(class_4140.field_25360);
        if (optional1.isPresent()) {
            return optional1;
        }
        return Optional.empty();
    }

    public static class_1269 mobInteract(PiglinPrisoner piglinPrisoner, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (PiglinPrisonerAi.canAdmire(piglinPrisoner, itemstack)) {
            class_1799 itemstack1 = itemstack.method_7971(1);
            PiglinPrisonerAi.holdInOffhand(piglinPrisoner, itemstack1);
            if (!player.equals((Object)piglinPrisoner.getTempter())) {
                PiglinPrisonerAi.newTemptingPlayer(piglinPrisoner, player);
            }
            PiglinPrisonerAi.admireGoldItem((class_1309)piglinPrisoner);
            PiglinPrisonerAi.stopWalking(piglinPrisoner);
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public static boolean canAdmire(PiglinPrisoner piglinPrisoner, class_1799 stack) {
        return !PiglinPrisonerAi.isAdmiringDisabled(piglinPrisoner) && !PiglinPrisonerAi.isAdmiringItem(piglinPrisoner) && piglinPrisoner.method_30236() && (PiglinPrisonerAi.isPiglinCurrency(stack) || PiglinPrisonerAi.isLovedItem(stack));
    }

    public static void wasHurtBy(PiglinPrisoner piglinPrisoner, class_1309 attacker) {
        if (attacker instanceof class_4836) {
            return;
        }
        if (PiglinPrisonerAi.isHoldingItemInOffHand(piglinPrisoner)) {
            PiglinPrisonerAi.stopHoldingOffHandItem(piglinPrisoner, false);
        }
        class_4095<PiglinPrisoner> brain = piglinPrisoner.method_18868();
        brain.method_18875(class_4140.field_22337);
        brain.method_18875(class_4140.field_25159);
        brain.method_18875(class_4140.field_22334);
        if (attacker instanceof class_1657) {
            brain.method_24525(class_4140.field_22473, (Object)true, 400L);
        }
        PiglinPrisonerAi.getAvoidTarget(piglinPrisoner).ifPresent(target -> {
            if (target.method_5864() != attacker.method_5864()) {
                brain.method_18875(class_4140.field_22357);
            }
        });
        PiglinPrisonerAi.maybeRetaliate(piglinPrisoner, attacker);
    }

    protected static void maybeRetaliate(class_5418 abstractPiglin, class_1309 target) {
        if (!abstractPiglin.method_18868().method_18906(class_4168.field_22399) && class_4148.method_37456((class_1309)abstractPiglin, (class_1309)target) && !class_4215.method_24558((class_1309)abstractPiglin, (class_1309)target, (double)4.0) && target.method_5864() != class_1299.field_6097) {
            PiglinPrisonerAi.setAngerTarget(abstractPiglin, target);
            PiglinPrisonerAi.broadcastAngerTarget(abstractPiglin, target);
        }
    }

    public static Optional<class_3414> getSoundForCurrentActivity(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.method_18868().method_24538().map(activity -> PiglinPrisonerAi.getSoundForActivity(piglinPrisoner, activity));
    }

    private static class_3414 getSoundForActivity(PiglinPrisoner piglinPrisoner, class_4168 activity) {
        if (activity == class_4168.field_22396) {
            return class_3417.field_22265;
        }
        if (piglinPrisoner.method_30235()) {
            return class_3417.field_22270;
        }
        if (activity == class_4168.field_22399 && PiglinPrisonerAi.isNearAvoidTarget(piglinPrisoner)) {
            return class_3417.field_22270;
        }
        if (activity == class_4168.field_22398) {
            return class_3417.field_22263;
        }
        if (activity == class_4168.field_22397) {
            return class_3417.field_22266;
        }
        if (PiglinPrisonerAi.seesPlayerHoldingLovedItem((class_1309)piglinPrisoner)) {
            return class_3417.field_22268;
        }
        if (PiglinPrisonerAi.isNearRepellent(piglinPrisoner)) {
            return class_3417.field_22270;
        }
        return class_3417.field_22264;
    }

    private static boolean isNearAvoidTarget(PiglinPrisoner piglinPrisoner) {
        class_4095<PiglinPrisoner> brain = piglinPrisoner.method_18868();
        return brain.method_18896(class_4140.field_22357) && ((class_1309)brain.method_18904(class_4140.field_22357).get()).method_24516((class_1297)piglinPrisoner, 12.0);
    }

    private static void stopWalking(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.method_18868().method_18875(class_4140.field_18445);
        piglinPrisoner.method_5942().method_6340();
    }

    public static void setAngerTarget(class_5418 abstractPiglin, class_1309 target) {
        if (class_4148.method_37456((class_1309)abstractPiglin, (class_1309)target)) {
            abstractPiglin.method_18868().method_18875(class_4140.field_19293);
            abstractPiglin.method_18868().method_24525(class_4140.field_22333, (Object)target.method_5667(), 600L);
        }
    }

    private static boolean isNearRepellent(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.method_18868().method_18896(class_4140.field_22474);
    }

    public static void exciteNearbyPiglins(class_1657 player, boolean requireVisibility) {
        List list = player.method_37908().method_18467(PiglinPrisoner.class, player.method_5829().method_1014(16.0));
        list.stream().filter(class_4838::method_24766).filter(piglin -> !requireVisibility || class_4215.method_24565((class_1309)piglin, (class_1309)player)).forEach(PiglinPrisonerAi::startDancing);
    }

    public static void startDancing(class_5418 abstractPiglin) {
        abstractPiglin.method_18868().method_24525(class_4140.field_25159, (Object)true, 200L);
        abstractPiglin.method_18868().method_24525(class_4140.field_22337, (Object)abstractPiglin.method_24515(), 200L);
    }

    private static boolean seesPlayerHoldingLovedItem(class_1309 piglin) {
        return piglin.method_18868().method_18896(class_4140.field_22349);
    }

    private static boolean isHoldingItemInOffHand(PiglinPrisoner piglinPrisoner) {
        return !piglinPrisoner.method_6079().method_7960();
    }

    private static void admireGoldItem(class_1309 piglin) {
        piglin.method_18868().method_24525(class_4140.field_22334, (Object)true, 120L);
    }

    private static void putInInventory(PiglinPrisoner piglinPrisoner, class_1799 stack) {
        piglinPrisoner.addToInventory(stack);
        PiglinPrisonerAi.giveGoldBuff(piglinPrisoner);
        PiglinPrisonerAi.pledgeAllegiance(piglinPrisoner);
    }

    private static boolean hasCrossbow(class_1309 entity) {
        return entity.method_24520(is -> is.method_7909() instanceof class_1764);
    }

    protected static void broadcastAngerTarget(class_5418 abstractPiglin, class_1309 target) {
        PiglinPrisonerAi.getAdultPiglins(abstractPiglin).forEach(adultPiglin -> PiglinPrisonerAi.setAngerTargetIfCloserThanCurrent((class_5418)adultPiglin, target));
    }

    private static List<class_5418> getAdultAbstractPiglins(class_5418 abstractPiglin) {
        return (List)abstractPiglin.method_18868().method_18904(class_4140.field_25755).orElse(ImmutableList.of());
    }

    private static List<class_4836> getAdultPiglins(class_5418 abstractPiglin) {
        return PiglinPrisonerAi.getAdultAbstractPiglins(abstractPiglin).stream().filter(class_4836.class::isInstance).map(class_4836.class::cast).toList();
    }

    public static void broadcastBeingRescued(class_5418 piglin) {
        PiglinPrisonerAi.getAdultPiglins(piglin).forEach(PiglinPrisonerAi::startDancing);
    }

    private static void setAngerTargetIfCloserThanCurrent(class_5418 abstractPiglin, class_1309 target) {
        Optional<class_1309> optional = PiglinPrisonerAi.getAngerTarget(abstractPiglin);
        class_1309 livingentity = class_4215.method_24562((class_1309)abstractPiglin, optional, (class_1309)target);
        if (optional.isEmpty() || optional.get() != livingentity) {
            PiglinPrisonerAi.setAngerTarget(abstractPiglin, livingentity);
        }
    }

    private static Optional<class_1309> getAngerTarget(class_5418 abstractPiglin) {
        return class_4215.method_24560((class_1309)abstractPiglin, (class_4140)class_4140.field_22333);
    }

    private static boolean isNotHoldingLovedItemInOffHand(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.method_6079().method_7960() || !PiglinPrisonerAi.isLovedItem(piglinPrisoner.method_6079());
    }

    private static boolean isAdmiringItem(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.method_18868().method_18896(class_4140.field_22334);
    }

    private static boolean isAdmiringDisabled(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.method_18868().method_18896(class_4140.field_22473);
    }

    public static Optional<class_1309> getAvoidTarget(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.method_18868().method_18896(class_4140.field_22357) ? piglinPrisoner.method_18868().method_18904(class_4140.field_22357) : Optional.empty();
    }

    public static boolean isPlayerHoldingLovedItem(class_1309 player) {
        return player.method_5864() == class_1299.field_6097 && player.method_24520(PiglinPrisonerAi::isLovedItem);
    }

    private static boolean isFood(class_1799 stack) {
        return stack.method_31573(class_3489.field_26988);
    }

    private static void eat(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.method_18868().method_24525(class_4140.field_22350, (Object)true, 200L);
    }

    private static boolean hasEatenRecently(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.method_18868().method_18896(class_4140.field_22350);
    }

    private static void giveGoldBuff(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.method_6092(new class_1293(class_1294.field_5898, 10800, 3, false, true));
        piglinPrisoner.method_6092(new class_1293(class_1294.field_5924, 7200, 1, false, false));
    }

    private static void newTemptingPlayer(PiglinPrisoner piglinPrisoner, class_1657 player) {
        piglinPrisoner.method_18868().method_18878(class_4140.field_28325, (Object)player);
        piglinPrisoner.method_18868().method_18878(class_4140.field_28327, (Object)false);
        piglinPrisoner.setTempterUUID(player.method_5667());
    }

    protected static void pledgeAllegiance(PiglinPrisoner piglin) {
        if (piglin.method_18868().method_18896(class_4140.field_28325)) {
            piglin.method_18868().method_18878(class_4140.field_28327, (Object)true);
        }
    }

    public static void reloadAllegiance(PiglinPrisoner piglin, class_1657 player) {
        piglin.method_18868().method_18878(class_4140.field_28325, (Object)player);
        piglin.method_18868().method_18878(class_4140.field_28327, (Object)true);
    }
}

