/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.configs;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ModEntriesConfigs {
    private static final Map<Class<? extends BlockType>, Map<String, Supplier<Boolean>>> BLOCK_TYPE_CONFIGS = new HashMap<Class<? extends BlockType>, Map<String, Supplier<Boolean>>>();
    private static final Map<Class<? extends BlockType>, Map<String, Supplier<Boolean>>> CHILD_CONFIGS = new HashMap<Class<? extends BlockType>, Map<String, Supplier<Boolean>>>();
    public static ConfigSpec SPEC;
    private static boolean wasInit;

    public static void initEarlyButNotSuperEarly() {
        Map map;
        Supplier config;
        String key;
        if (wasInit) {
            return;
        }
        wasInit = true;
        ConfigBuilder builder = ConfigBuilder.create((class_2960)EveryCompat.res("entries"), (ConfigType)ConfigType.COMMON);
        builder.comment("Disables certain types. Note that all these configs, like in any other mod, only hide stuff from tabs and disable their recipes").push("types");
        for (BlockTypeRegistry reg : BlockSetAPI.getRegistries()) {
            builder.push(reg.typeName().replace(" ", "_"));
            for (BlockType w : reg.getValues()) {
                if (w.isVanilla()) continue;
                key = w.toString().replace(":", ".");
                config = builder.define(key, true);
                map = BLOCK_TYPE_CONFIGS.computeIfAbsent(reg.getType(), s -> new HashMap());
                map.put(w.toString(), config);
            }
            builder.pop();
        }
        builder.pop();
        builder.comment("Disables specific entries").push("entries");
        for (BlockTypeRegistry reg : BlockSetAPI.getRegistries()) {
            builder.push(reg.typeName().replace(" ", "_"));
            for (String c : EveryCompat.getChildKeys(reg.getType())) {
                key = c.replace(":", ".");
                config = builder.define(key, true);
                map = CHILD_CONFIGS.computeIfAbsent(reg.getType(), s -> new HashMap());
                map.put(c, config);
            }
            builder.pop();
        }
        builder.pop();
        SPEC = builder.buildAndRegister();
        SPEC.loadFromFile();
    }

    public static <T extends BlockType> boolean isEntryEnabled(T blockType, Object o) {
        if (o instanceof class_1747) {
            class_1747 bi = (class_1747)o;
            o = bi.method_7711();
        }
        return ModEntriesConfigs.isTypeEnabled(blockType, blockType.getChildKey(o));
    }

    public static <T extends BlockType> boolean isEntryEnabled(Class<T> typeClass, Object o) {
        if (o instanceof class_1747) {
            class_1747 bi = (class_1747)o;
            o = bi.method_7711();
        }
        BlockType blockType = BlockSetAPI.getBlockTypeOf((class_1935)((class_1935)o), typeClass);
        return ModEntriesConfigs.isTypeEnabled(blockType, blockType.getChildKey(o));
    }

    public static <T extends BlockType> boolean isTypeEnabled(T w) {
        return ModEntriesConfigs.isTypeEnabled(w, null);
    }

    public static <T extends BlockType> boolean isTypeEnabled(T w, @Nullable String childType) {
        if (!wasInit) {
            ModEntriesConfigs.initEarlyButNotSuperEarly();
        }
        try {
            if (childType != null && !CHILD_CONFIGS.get(w.getClass()).getOrDefault(childType, () -> true).get().booleanValue()) {
                return false;
            }
            return BLOCK_TYPE_CONFIGS.get(w.getClass()).get(w.getId().toString()).get();
        }
        catch (Exception exception) {
            return true;
        }
    }

    static {
        wasInit = false;
    }
}

