/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.mpuc.client.util.DebugInfo;
import com.jab125.mpuc.config.Tags;
import com.jab125.mpuc.util.OnlineInfo;
import com.jab125.mpuc.util.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class MpucConfig {
    public static final int LATEST_SCHEMA_VERSION = 9;
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    static final Path MPUC_CONFIG_FOLDER = Platform.getConfigDir().resolve("modpack-update-checker");
    private static final Path CONFIG_LOCATION = MPUC_CONFIG_FOLDER.resolve("config.json");
    private static final Path MODPACK_INFO_LOCATION = MPUC_CONFIG_FOLDER.resolve("modpack-info.txt");
    public final String currentVersion;
    public final String modpackName;
    public final String modpackAuthor;
    public final String modpackReleaseType;
    public final String updateCheckerId;
    public final UpdateCheckerType type;
    public final boolean bccEnabled;
    public final boolean expandButton;
    public final String[] modpackMods;
    public final boolean addButton;
    public final boolean mainMenuCreditsIntegration;
    public final boolean forceModpackCompatible;
    public final boolean retroAllow;
    public final boolean retroWarning;
    public final int buttonXOffset;
    public final int buttonYOffset;
    public final boolean legacyInfoText;
    public final String markdownRenderer;
    public final Tags tags;
    private OnlineInfo associatedOnlineInfo;
    private static final JsonObject elem = new JsonObject();
    private String cachedText;

    private MpucConfig(String currentVersion, String modpackName, String modpackAuthor, String modpackReleaseType, String updateCheckerId, UpdateCheckerType type, boolean bccEnabled, boolean expandButton, String[] modpackMods, boolean addButton, boolean mainMenuCreditsIntegration, boolean forceModpackCompatible, boolean retroAllow, boolean retroWarning, int buttonXOffset, int buttonYOffset, boolean legacyInfoText, String markdownRenderer, Tags tags) {
        this.currentVersion = currentVersion;
        this.modpackName = modpackName;
        this.modpackAuthor = modpackAuthor;
        if (!("stable".equals(modpackReleaseType) || "beta".equals(modpackReleaseType) || "alpha".equals(modpackReleaseType))) {
            throw new IllegalStateException("modpackReleaseType must can only be one of the following: [stable, beta, alpha]");
        }
        this.modpackReleaseType = modpackReleaseType;
        this.updateCheckerId = updateCheckerId;
        this.type = type;
        this.bccEnabled = bccEnabled;
        this.expandButton = expandButton;
        this.modpackMods = modpackMods;
        this.addButton = addButton;
        this.mainMenuCreditsIntegration = mainMenuCreditsIntegration;
        this.forceModpackCompatible = forceModpackCompatible;
        this.retroAllow = retroAllow;
        this.retroWarning = retroWarning;
        this.buttonXOffset = buttonXOffset;
        this.buttonYOffset = buttonYOffset;
        this.legacyInfoText = legacyInfoText;
        this.markdownRenderer = markdownRenderer;
        this.tags = tags;
    }

    public static MpucConfig load() {
        if (!CONFIG_LOCATION.toFile().exists()) {
            if (Platform.getConfigDir().resolve("modpack-update-checker.txt").toFile().exists()) {
                try {
                    DebugInfo.schemaVersion = 0;
                    return MpucConfig.loadLegacyConfig();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            MpucConfig.makeDirs();
        }
        MpucConfig.makeDirs();
        if (!CONFIG_LOCATION.toFile().exists()) {
            MpucConfig defaultConfig = new MpucConfig("1.0.0", "Modpack Name Goes Here", "My Modpack Studio", "stable", "https://raw.githubusercontent.com/Modpack-Update-Checker/example-update-checker/main/", UpdateCheckerType.TWO, false, false, new String[0], true, true, false, true, false, 0, 0, false, "builtin:mpuc_lavendermd", new Tags());
            try {
                defaultConfig.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return MpucConfig.readConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated(since="0.6.1", forRemoval=true)
    private static MpucConfig loadLegacyConfig() throws IOException {
        String currentVersion;
        String modpackName;
        boolean expandButton;
        String githubRepo;
        boolean bccEnabled;
        System.out.println("[Modpack Update Checker] A JSON config wasn't found but the old TXT file config exists! Loading...");
        System.out.println("[Modpack Update Checker] The old TXT format will be removed in a future version!");
        System.out.println("[Modpack Update Checker] The config can be migrated in the Editor Screen. Make sure to delete the TXT config after migrating.");
        Path configFile = Platform.getConfigDir().resolve("modpack-update-checker.txt");
        Path bccConfig = Platform.getConfigDir().resolve("bcc.json");
        String config = Files.readString(configFile);
        String[] lines = config.replaceAll("\r\n", "\n").split("\n");
        if ("BCC ENABLED".equals(lines[2])) {
            String bccConfigString = Files.readString(bccConfig);
            bccEnabled = true;
            githubRepo = lines[1];
            expandButton = lines.length > 4 && lines[4].equals("y");
            JsonObject bccJson = (JsonObject)GSON.fromJson(bccConfigString, JsonObject.class);
            modpackName = bccJson.getAsJsonPrimitive("modpackName").getAsString();
            currentVersion = bccJson.getAsJsonPrimitive("modpackVersion").getAsString();
        } else {
            bccEnabled = false;
            expandButton = lines.length > 7 && lines[7].equals("y");
            githubRepo = lines[1];
            currentVersion = lines[3];
            modpackName = lines[5];
        }
        return new MpucConfig(currentVersion, modpackName, modpackName + "'s Maintainers", "stable", githubRepo, UpdateCheckerType.ONE, bccEnabled, expandButton, new String[0], true, true, false, true, false, 0, 0, true, "builtin:mpuc_lavendermd", new Tags());
    }

    private static MpucConfig readConfig() throws IOException {
        int schemaVersion;
        String json = Files.readString(CONFIG_LOCATION);
        JsonObject object = (JsonObject)GSON.fromJson(json, JsonObject.class);
        if (!(object.has("schemaVersion") && object.get("schemaVersion").isJsonPrimitive() && object.getAsJsonPrimitive("schemaVersion").isNumber())) {
            throw new IllegalStateException("schemaVersion missing!");
        }
        DebugInfo.schemaVersion = schemaVersion = object.get("schemaVersion").getAsInt();
        if (schemaVersion == 1) {
            return MpucConfig.readSchemaV1(object);
        }
        if (schemaVersion == 2) {
            return MpucConfig.readSchemaV2(object);
        }
        if (schemaVersion == 3) {
            return MpucConfig.readSchemaV3(object);
        }
        if (schemaVersion == 4) {
            return MpucConfig.readSchemaV4(object);
        }
        if (schemaVersion == 5) {
            return MpucConfig.readSchemaV5(object);
        }
        if (schemaVersion == 6) {
            return MpucConfig.readSchemaV6(object);
        }
        if (schemaVersion == 7) {
            return MpucConfig.readSchemaV7(object);
        }
        if (schemaVersion == 8) {
            return MpucConfig.readSchemaV8(object);
        }
        if (schemaVersion == 9) {
            return MpucConfig.readSchemaV9(object);
        }
        System.out.println("\ud83e\udd2e");
        throw new IOException("[Modpack Update Checker] Schema version not found!");
    }

    @Deprecated(since="0.7.0")
    private static MpucConfig readSchemaV1(JsonObject object) throws IOException {
        JsonObject advanced;
        if (object.has("advanced") && object.get("advanced").isJsonObject()) {
            advanced = object.getAsJsonObject("advanced");
        } else {
            advanced = new JsonObject();
            object.add("advanced", (JsonElement)advanced);
        }
        advanced.addProperty("updateCheckerType", (Number)UpdateCheckerType.ONE.getId());
        return MpucConfig.readSchemaV2(object);
    }

    @Deprecated(since="0.8.0")
    private static MpucConfig readSchemaV2(JsonObject object) throws IOException {
        JsonObject advanced;
        if (object.has("advanced") && object.get("advanced").isJsonObject()) {
            advanced = object.getAsJsonObject("advanced");
        } else {
            advanced = new JsonObject();
            object.add("advanced", (JsonElement)advanced);
        }
        advanced.addProperty("showAllIfUpToDate", Boolean.valueOf(false));
        return MpucConfig.readSchemaV3(object);
    }

    @Deprecated(since="0.10.0")
    private static MpucConfig readSchemaV3(JsonObject object) throws IOException {
        object.add("modpackAuthor", (JsonElement)elem);
        return MpucConfig.readSchemaV4(object);
    }

    @Deprecated(since="0.10.2")
    private static MpucConfig readSchemaV4(JsonObject object) throws IOException {
        JsonObject advanced;
        object.addProperty("modpackReleaseType", "stable");
        if (object.has("advanced") && object.get("advanced").isJsonObject()) {
            boolean hasShowAllChangelogsIfUpToDate;
            advanced = object.getAsJsonObject("advanced");
            boolean bl = hasShowAllChangelogsIfUpToDate = advanced.has("showAllChangelogsIfUpToDate") && advanced.get("showAllChangelogsIfUpToDate").isJsonPrimitive() && advanced.get("showAllChangelogsIfUpToDate").getAsJsonPrimitive().isBoolean();
            if (hasShowAllChangelogsIfUpToDate) {
                advanced.remove("showAllChangelogsIfUpToDate");
            }
        } else {
            advanced = new JsonObject();
            object.add("advanced", (JsonElement)advanced);
        }
        advanced.add("modpackMods", (JsonElement)new JsonArray());
        return MpucConfig.readSchemaV5(object);
    }

    @Deprecated(since="0.11.0")
    private static MpucConfig readSchemaV5(JsonObject object) throws IOException {
        if (object.has("advanced") && object.get("advanced").isJsonObject()) {
            boolean retroAllow;
            boolean hasForceModpackCompatible;
            boolean hasMainMenuCreditsIntegration;
            boolean hasShowAllChangelogsIfUpToDate;
            JsonObject advanced = object.getAsJsonObject("advanced");
            boolean bl = hasShowAllChangelogsIfUpToDate = advanced.has("addButton") && advanced.get("addButton").isJsonPrimitive() && advanced.get("addButton").getAsJsonPrimitive().isBoolean();
            if (hasShowAllChangelogsIfUpToDate) {
                advanced.remove("addButton");
            }
            boolean bl2 = hasMainMenuCreditsIntegration = advanced.has("mainMenuCreditsIntegration") && advanced.get("mainMenuCreditsIntegration").isJsonPrimitive() && advanced.get("mainMenuCreditsIntegration").getAsJsonPrimitive().isBoolean();
            if (hasMainMenuCreditsIntegration) {
                advanced.remove("mainMenuCreditsIntegration");
            }
            boolean bl3 = hasForceModpackCompatible = advanced.has("forceModpackCompatible") && advanced.get("forceModpackCompatible").isJsonPrimitive() && advanced.get("forceModpackCompatible").getAsJsonPrimitive().isBoolean();
            if (hasForceModpackCompatible) {
                advanced.remove("forceModpackCompatible");
            }
            boolean bl4 = retroAllow = advanced.has("retroAllow") && advanced.get("retroAllow").isJsonPrimitive() && advanced.get("retroAllow").getAsJsonPrimitive().isBoolean();
            if (retroAllow) {
                advanced.remove("retroAllow");
            }
        } else {
            JsonObject advanced = new JsonObject();
            object.add("advanced", (JsonElement)advanced);
        }
        return MpucConfig.readSchemaV6(object);
    }

    @Deprecated(since="0.12.0")
    private static MpucConfig readSchemaV6(JsonObject object) throws IOException {
        if (object.has("advanced") && object.get("advanced").isJsonObject()) {
            boolean buttonYOffset;
            boolean buttonXOffset;
            boolean retroWarning;
            JsonObject advanced = object.getAsJsonObject("advanced");
            boolean bl = retroWarning = advanced.has("retroWarning") && advanced.get("retroWarning").isJsonPrimitive() && advanced.get("retroWarning").getAsJsonPrimitive().isBoolean();
            if (retroWarning) {
                advanced.remove("retroWarning");
            }
            boolean bl2 = buttonXOffset = advanced.has("buttonXOffset") && advanced.get("buttonXOffset").isJsonPrimitive() && advanced.get("buttonXOffset").getAsJsonPrimitive().isNumber();
            if (buttonXOffset) {
                advanced.remove("buttonXOffset");
            }
            boolean bl3 = buttonYOffset = advanced.has("buttonYOffset") && advanced.get("buttonYOffset").isJsonPrimitive() && advanced.get("buttonYOffset").getAsJsonPrimitive().isNumber();
            if (buttonYOffset) {
                advanced.remove("buttonYOffset");
            }
        } else {
            JsonObject advanced = new JsonObject();
            object.add("advanced", (JsonElement)advanced);
        }
        JsonElement githubRepo = object.get("githubRepo");
        object.remove("githubRepo");
        object.add("updateCheckerId", githubRepo);
        return MpucConfig.readSchemaV7(object);
    }

    private static MpucConfig readSchemaV7(JsonObject object) throws IOException {
        JsonObject advanced;
        if (object.has("advanced") && object.get("advanced").isJsonObject()) {
            advanced = object.getAsJsonObject("advanced");
        } else {
            advanced = new JsonObject();
            object.add("advanced", (JsonElement)advanced);
        }
        advanced.addProperty("legacyInfoText", Boolean.valueOf(true));
        return MpucConfig.readSchemaV8(object);
    }

    private static MpucConfig readSchemaV8(JsonObject object) throws IOException {
        JsonObject advanced;
        if (object.has("advanced") && object.get("advanced").isJsonObject()) {
            advanced = object.getAsJsonObject("advanced");
        } else {
            advanced = new JsonObject();
            object.add("advanced", (JsonElement)advanced);
        }
        advanced.addProperty("defaultMarkdownRenderer", "builtin:mpuc_lavendermd");
        return MpucConfig.readSchemaV9(object);
    }

    private static MpucConfig readSchemaV9(JsonObject object) throws IOException {
        String currentVersion;
        boolean hasAdvanced;
        boolean bccEnabled = false;
        boolean expandButton = false;
        String[] modpackMods = new String[]{};
        UpdateCheckerType updateCheckerType = UpdateCheckerType.TWO;
        boolean addButton = true;
        boolean mainMenuCreditsIntegration = true;
        boolean forceModpackCompatible = false;
        boolean retroAllow = true;
        boolean retroWarning = true;
        int buttonXOffset = 0;
        int buttonYOffset = 0;
        boolean legacyInfoText = false;
        String markdownRenderer = "builtin:mpuc_lavendermd";
        Tags tags = new Tags();
        boolean bl = hasAdvanced = object.has("advanced") && object.get("advanced").isJsonObject();
        if (hasAdvanced) {
            boolean hasTags;
            boolean hasMarkdownRenderer;
            boolean hasLegacyInfoText;
            boolean hasButtonYOffset;
            boolean hasButtonXOffset;
            boolean hasRetroWarning;
            boolean hasRetroAllow;
            boolean hasForceModpackCompatible;
            boolean hasMainMenuCreditsIntegration;
            boolean hasAddButton;
            boolean hasModpackMods;
            boolean hasUpdateCheckerType;
            boolean hasExpandButton;
            boolean hasBccEnabled;
            JsonObject advanced = object.getAsJsonObject("advanced");
            boolean bl2 = hasBccEnabled = advanced.has("bccEnabled") && advanced.get("bccEnabled").isJsonPrimitive() && advanced.get("bccEnabled").getAsJsonPrimitive().isBoolean();
            if (hasBccEnabled) {
                bccEnabled = advanced.get("bccEnabled").getAsBoolean();
            }
            boolean bl3 = hasExpandButton = advanced.has("expandButton") && advanced.get("expandButton").isJsonPrimitive() && advanced.get("expandButton").getAsJsonPrimitive().isBoolean();
            if (hasExpandButton) {
                expandButton = advanced.get("expandButton").getAsBoolean();
            }
            boolean bl4 = hasUpdateCheckerType = advanced.has("updateCheckerType") && advanced.get("updateCheckerType").isJsonPrimitive() && advanced.get("updateCheckerType").getAsJsonPrimitive().isNumber();
            if (hasUpdateCheckerType) {
                updateCheckerType = UpdateCheckerType.fromId(advanced.get("updateCheckerType").getAsJsonPrimitive().getAsNumber().intValue());
                System.out.println("found type, is " + String.valueOf((Object)updateCheckerType));
            }
            boolean bl5 = hasModpackMods = advanced.has("modpackMods") && advanced.get("modpackMods").isJsonArray();
            if (hasModpackMods) {
                modpackMods = (String[])GSON.fromJson((JsonElement)advanced.get("modpackMods").getAsJsonArray(), String[].class);
            }
            boolean bl6 = hasAddButton = advanced.has("addButton") && advanced.get("addButton").isJsonPrimitive() && advanced.get("addButton").getAsJsonPrimitive().isBoolean();
            if (hasAddButton) {
                addButton = advanced.getAsJsonPrimitive("addButton").getAsBoolean();
            }
            boolean bl7 = hasMainMenuCreditsIntegration = advanced.has("mainMenuCreditsIntegration") && advanced.get("mainMenuCreditsIntegration").isJsonPrimitive() && advanced.get("mainMenuCreditsIntegration").getAsJsonPrimitive().isBoolean();
            if (hasMainMenuCreditsIntegration) {
                mainMenuCreditsIntegration = advanced.getAsJsonPrimitive("mainMenuCreditsIntegration").getAsBoolean();
            }
            boolean bl8 = hasForceModpackCompatible = advanced.has("forceModpackCompatible") && advanced.get("forceModpackCompatible").isJsonPrimitive() && advanced.get("forceModpackCompatible").getAsJsonPrimitive().isBoolean();
            if (hasForceModpackCompatible) {
                forceModpackCompatible = advanced.getAsJsonPrimitive("forceModpackCompatible").getAsBoolean();
            }
            boolean bl9 = hasRetroAllow = advanced.has("retroAllow") && advanced.get("retroAllow").isJsonPrimitive() && advanced.get("retroAllow").getAsJsonPrimitive().isBoolean();
            if (hasRetroAllow) {
                retroAllow = advanced.getAsJsonPrimitive("retroAllow").getAsBoolean();
            }
            boolean bl10 = hasRetroWarning = advanced.has("retroWarning") && advanced.get("retroWarning").isJsonPrimitive() && advanced.get("retroWarning").getAsJsonPrimitive().isBoolean();
            if (hasRetroWarning) {
                retroWarning = advanced.getAsJsonPrimitive("retroWarning").getAsBoolean();
            }
            boolean bl11 = hasButtonXOffset = advanced.has("buttonXOffset") && advanced.get("buttonXOffset").isJsonPrimitive() && advanced.get("buttonXOffset").getAsJsonPrimitive().isNumber();
            if (hasButtonXOffset) {
                buttonXOffset = advanced.getAsJsonPrimitive("buttonXOffset").getAsInt();
            }
            boolean bl12 = hasButtonYOffset = advanced.has("buttonYOffset") && advanced.get("buttonYOffset").isJsonPrimitive() && advanced.get("buttonYOffset").getAsJsonPrimitive().isNumber();
            if (hasButtonYOffset) {
                buttonYOffset = advanced.getAsJsonPrimitive("buttonYOffset").getAsInt();
            }
            boolean bl13 = hasLegacyInfoText = advanced.has("legacyInfoText") && advanced.get("legacyInfoText").isJsonPrimitive() && advanced.get("legacyInfoText").getAsJsonPrimitive().isBoolean();
            if (hasLegacyInfoText) {
                legacyInfoText = advanced.getAsJsonPrimitive("legacyInfoText").getAsBoolean();
            }
            boolean bl14 = hasMarkdownRenderer = advanced.has("markdownRenderer") && advanced.get("markdownRenderer").isJsonPrimitive() && advanced.get("markdownRenderer").getAsJsonPrimitive().isString();
            if (hasMarkdownRenderer) {
                markdownRenderer = advanced.getAsJsonPrimitive("markdownRenderer").getAsString();
            }
            boolean bl15 = hasTags = advanced.has("tags") && advanced.get("tags").isJsonArray();
            if (hasTags) {
                tags = Tags.deserialize(advanced.getAsJsonArray("tags"));
            }
        }
        if (bccEnabled) {
            if (!(object.has("updateCheckerId") && object.get("updateCheckerId").isJsonPrimitive() && object.getAsJsonPrimitive("updateCheckerId").isString())) {
                throw new IllegalStateException("updateCheckerId missing!");
            }
            if (!(elem == object.get("modpackAuthor") || object.has("modpackAuthor") && object.get("modpackAuthor").isJsonPrimitive() && object.getAsJsonPrimitive("modpackAuthor").isString())) {
                throw new IllegalStateException("modpackAuthor missing!");
            }
            if (!(object.has("modpackReleaseType") && object.get("modpackReleaseType").isJsonPrimitive() && object.getAsJsonPrimitive("modpackReleaseType").isString())) {
                throw new IllegalStateException("modpackReleaseType missing!");
            }
            String modpackReleaseType = object.get("modpackReleaseType").getAsString();
            String updateCheckerId = object.get("updateCheckerId").getAsString();
            Path bccConfig = Platform.getConfigDir().resolve("bcc.json");
            String bccConfigString = Files.readString(bccConfig);
            JsonObject bccJson = (JsonObject)GSON.fromJson(bccConfigString, JsonObject.class);
            String modpackName = bccJson.getAsJsonPrimitive("modpackName").getAsString();
            currentVersion = bccJson.getAsJsonPrimitive("modpackVersion").getAsString();
            String modpackAuthor = elem == object.get("modpackAuthor") ? modpackName + "'s Maintainers" : object.getAsJsonPrimitive("modpackAuthor").getAsString();
            return new MpucConfig(currentVersion, modpackName, modpackAuthor, modpackReleaseType, updateCheckerId, updateCheckerType, bccEnabled, expandButton, modpackMods, addButton, mainMenuCreditsIntegration, forceModpackCompatible, retroAllow, retroWarning, buttonXOffset, buttonYOffset, legacyInfoText, markdownRenderer, tags);
        }
        if (!(object.has("currentVersion") && object.get("currentVersion").isJsonPrimitive() && object.getAsJsonPrimitive("currentVersion").isString())) {
            throw new IllegalStateException("currentVersion missing!");
        }
        if (!(object.has("modpackName") && object.get("modpackName").isJsonPrimitive() && object.getAsJsonPrimitive("modpackName").isString())) {
            throw new IllegalStateException("modpackName missing!");
        }
        if (!(elem == object.get("modpackAuthor") || object.has("modpackAuthor") && object.get("modpackAuthor").isJsonPrimitive() && object.getAsJsonPrimitive("modpackAuthor").isString())) {
            throw new IllegalStateException("modpackAuthor missing!");
        }
        if (!(object.has("modpackReleaseType") && object.get("modpackReleaseType").isJsonPrimitive() && object.getAsJsonPrimitive("modpackReleaseType").isString())) {
            throw new IllegalStateException("modpackReleaseType missing!");
        }
        if (!(object.has("updateCheckerId") && object.get("updateCheckerId").isJsonPrimitive() && object.getAsJsonPrimitive("updateCheckerId").isString())) {
            throw new IllegalStateException("updateCheckerId missing!");
        }
        currentVersion = object.get("currentVersion").getAsString();
        String modpackName = object.get("modpackName").getAsString();
        String modpackAuthor = elem == object.get("modpackAuthor") ? modpackName + "'s Maintainers" : object.getAsJsonPrimitive("modpackAuthor").getAsString();
        String modpackReleaseType = object.get("modpackReleaseType").getAsString();
        String updateCheckerId = object.get("updateCheckerId").getAsString();
        return new MpucConfig(currentVersion, modpackName, modpackAuthor, modpackReleaseType, updateCheckerId, updateCheckerType, bccEnabled, expandButton, modpackMods, addButton, mainMenuCreditsIntegration, forceModpackCompatible, retroAllow, retroWarning, buttonXOffset, buttonYOffset, legacyInfoText, markdownRenderer, tags);
    }

    public void clearCachedText() {
        this.cachedText = null;
    }

    public String getInfoText() {
        Path a;
        if (this.cachedText != null) {
            return this.cachedText;
        }
        Path path = a = this.legacyInfoText ? Platform.getConfigDir().resolve("modpack-update-checker-info.txt") : MODPACK_INFO_LOCATION;
        if (!a.toFile().exists()) {
            a.toFile().getParentFile().mkdirs();
            try {
                Files.writeString(a, (CharSequence)"Put whatever you want on this screen, lines will wrap, and URLs will be clickable, example: https://www.youtube.com/channel/UC151j_E5Qin4I-pl7PNo12g/ :)", new OpenOption[0]);
                this.cachedText = "Put whatever you want on this screen, lines will wrap, and URLs will be clickable, example: https://www.youtube.com/channel/UC151j_E5Qin4I-pl7PNo12g/ :)";
                return "Put whatever you want on this screen, lines will wrap, and URLs will be clickable, example: https://www.youtube.com/channel/UC151j_E5Qin4I-pl7PNo12g/ :)";
            }
            catch (IOException e) {
                e.printStackTrace();
                this.cachedText = "Put whatever you want on this screen, lines will wrap, and URLs will be clickable, example: https://www.youtube.com/channel/UC151j_E5Qin4I-pl7PNo12g/ :)";
                return "Put whatever you want on this screen, lines will wrap, and URLs will be clickable, example: https://www.youtube.com/channel/UC151j_E5Qin4I-pl7PNo12g/ :)";
            }
        }
        try {
            this.cachedText = Files.readString(a);
            return this.cachedText;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.cachedText = "Error reading file";
            return "Error reading file";
        }
    }

    private JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.addProperty("schemaVersion", (Number)9);
        if (!this.bccEnabled) {
            object.addProperty("currentVersion", this.currentVersion);
            object.addProperty("modpackName", this.modpackName);
        }
        object.addProperty("modpackAuthor", this.modpackAuthor);
        object.addProperty("modpackReleaseType", this.modpackReleaseType);
        object.addProperty("updateCheckerId", this.updateCheckerId);
        JsonObject advanced = new JsonObject();
        advanced.addProperty("bccEnabled", Boolean.valueOf(this.bccEnabled));
        advanced.addProperty("expandButton", Boolean.valueOf(this.expandButton));
        advanced.addProperty("updateCheckerType", (Number)this.type.getId());
        if (!this.addButton) {
            advanced.addProperty("addButton", Boolean.valueOf(this.addButton));
        }
        if (!this.mainMenuCreditsIntegration) {
            advanced.addProperty("mainMenuCreditsIntegration", Boolean.valueOf(this.mainMenuCreditsIntegration));
        }
        if (this.forceModpackCompatible) {
            advanced.addProperty("forceModpackCompatible", Boolean.valueOf(this.forceModpackCompatible));
        }
        if (!this.retroAllow) {
            advanced.addProperty("retroAllow", Boolean.valueOf(this.retroAllow));
        }
        if (!this.retroWarning) {
            advanced.addProperty("retroWarning", Boolean.valueOf(this.retroWarning));
        }
        if (this.buttonXOffset != 0 || this.buttonYOffset != 0) {
            advanced.addProperty("buttonXOffset", (Number)this.buttonXOffset);
            advanced.addProperty("buttonYOffset", (Number)this.buttonYOffset);
        }
        if (this.legacyInfoText) {
            advanced.addProperty("legacyInfoText", Boolean.valueOf(this.legacyInfoText));
        }
        if (!"builtin:mpuc_lavendermd".equals(this.markdownRenderer)) {
            advanced.addProperty("markdownRenderer", this.markdownRenderer);
        }
        if (!this.tags.isEmpty()) {
            advanced.add("tags", (JsonElement)this.tags.serialize());
        }
        advanced.add("modpackMods", (JsonElement)new JsonArray());
        object.add("advanced", (JsonElement)advanced);
        return object;
    }

    private void save() throws IOException {
        MpucConfig.makeDirs();
        String json = GSON.toJson((JsonElement)this.toJsonObject());
        Files.writeString(CONFIG_LOCATION, (CharSequence)json, new OpenOption[0]);
    }

    public boolean tryMigrate() throws IOException {
        if (DebugInfo.schemaVersion < 9) {
            this.save();
            return true;
        }
        return false;
    }

    private static boolean makeDirs() {
        return MPUC_CONFIG_FOLDER.toFile().mkdirs();
    }

    public static int getId(Object object) {
        if (object instanceof UpdateCheckerType) {
            UpdateCheckerType type = (UpdateCheckerType)((Object)object);
            return type.getId();
        }
        return -1;
    }

    public OnlineInfo getAssociatedOnlineInfo() {
        return this.associatedOnlineInfo;
    }

    public OnlineInfo setAssociatedOnlineInfo(OnlineInfo associatedOnlineInfo) {
        this.associatedOnlineInfo = associatedOnlineInfo;
        return this.associatedOnlineInfo;
    }

    private static enum UpdateCheckerType {
        ZERO,
        ONE,
        TWO,
        THREE;


        public int getId() {
            return this.ordinal();
        }

        public static UpdateCheckerType fromId(int id) {
            UpdateCheckerType[] values = UpdateCheckerType.values();
            if (values.length <= id) {
                return null;
            }
            return values[id];
        }
    }
}

