/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.markdown;

import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.Parser;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ImageFeature
implements MarkdownFeature {
    private static final Pattern URL_PATTERN = Pattern.compile("(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");

    public String name() {
        return "mpuc_images";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            nibbler.skip();
            if (!nibbler.tryConsume('[')) {
                return false;
            }
            String description = nibbler.consumeUntil(']');
            if (description == null || !nibbler.tryConsume('(')) {
                return false;
            }
            String url = nibbler.consumeUntil(')');
            if (url == null) {
                return false;
            }
            boolean fit = url.endsWith(",fit");
            if (fit) {
                url = url.substring(0, url.length() - 4);
            }
            if (!URL_PATTERN.matcher(url).matches()) {
                return false;
            }
            tokens.add(new ImageToken(description, url, fit));
            return true;
        }, '!');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, image, tokens) -> new ImageNode(image.url, image.description, image.fit), (token, tokens) -> token instanceof ImageToken ? (ImageToken)((Object)token) : null);
    }

    private static final class ImageToken
    extends Lexer.Token {
        public final String description;
        public final String url;
        public final boolean fit;

        public ImageToken(String description, String url, boolean fit) {
            super("![" + description + "](" + url + ")");
            this.description = description;
            this.url = url;
            this.fit = fit;
        }
    }

    private static class ImageNode
    extends Parser.Node {
        private final String url;
        private final String description;
        private final boolean fit;
        private static final Map<String, class_2960> CACHED_IMAGES = new HashMap<String, class_2960>();
        private static int num;

        public ImageNode(String url, String description, boolean fit) {
            this.url = url;
            this.description = description;
            this.fit = fit;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            compiler.visitImage(this.identifierFor(this.url), this.description, this.fit);
        }

        private class_2960 identifierFor(String url) {
            if (!CACHED_IMAGES.containsKey(url)) {
                class_2960 identifier;
                try {
                    identifier = new class_2960("modpack-update-checker", "generated/" + num + ".png");
                    ImageNode.applyTexture(identifier, ImageNode.fromUrl(url));
                    ++num;
                }
                catch (Throwable t) {
                    identifier = new class_2960("minecraft", "missing_texture");
                }
                CACHED_IMAGES.put(url, identifier);
            }
            return CACHED_IMAGES.get(url);
        }

        private static class_1011 fromUrl(String surl) throws Throwable {
            URL url = new URL(surl);
            return class_1011.method_4309((InputStream)url.openStream());
        }

        private static void applyTexture(class_2960 identifier, class_1011 image) {
            class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(identifier, (class_1044)new class_1043(image)));
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

