/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import net.minecraft.class_1297;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.apache.commons.lang3.Validate;

public class DataEntry<E extends class_1297, T> {
    private final SyncedDataKey<E, T> key;
    private T value;
    private boolean dirty;

    DataEntry(SyncedDataKey<E, T> key) {
        this.key = key;
        this.value = key.defaultValueSupplier().get();
    }

    SyncedDataKey<E, T> getKey() {
        return this.key;
    }

    T getValue() {
        return this.value;
    }

    void setValue(T value, boolean dirty) {
        this.value = value;
        this.dirty = dirty;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void clean() {
        this.dirty = false;
    }

    public void write(class_2540 buffer) {
        int id = SyncedEntityData.instance().getInternalId(this.key);
        buffer.method_10804(id);
        this.key.serializer().write(buffer, this.value);
    }

    public static DataEntry<?, ?> read(class_2540 buffer) {
        SyncedDataKey<?, ?> key = SyncedEntityData.instance().getKey(buffer.method_10816());
        Validate.notNull(key, (String)"Synced key does not exist for id", (Object[])new Object[0]);
        DataEntry entry = new DataEntry(key);
        entry.readValue(buffer);
        return entry;
    }

    private void readValue(class_2540 buffer) {
        this.value = this.getKey().serializer().read(buffer);
    }

    class_2520 writeValue() {
        return this.key.serializer().write(this.value);
    }

    void readValue(class_2520 nbt) {
        this.value = this.key.serializer().read(nbt);
    }
}

