/*
 * Decompiled with CFR 0.152.
 */
package com.mrerenk.mapdistancefix.mixin.client;

import com.mrerenk.mapdistancefix.config.ModConfig;
import com.mrerenk.mapdistancefix.util.MapCenterTracker;
import com.mrerenk.mapdistancefix.util.MapIconUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_22.class})
public class MapStateMixin {
    @Shadow
    @Final
    @Mutable
    private boolean field_113;
    @Shadow
    @Final
    public byte field_119;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void enableUnlimitedTracking(int centerX, int centerZ, byte scale, boolean showIcons, boolean unlimitedTracking, boolean locked, class_5321<?> dimension, CallbackInfo ci) {
        this.field_113 = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getIcons"}, at={@At(value="RETURN")}, cancellable=true)
    private void convertOffMapPlayerIcons(CallbackInfoReturnable<Iterable<class_20>> cir) {
        Iterable originalIcons = (Iterable)cir.getReturnValue();
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || originalIcons == null) {
            return;
        }
        class_22 self = (class_22)this;
        double playerX = client.field_1724.method_23317();
        double playerZ = client.field_1724.method_23321();
        ModConfig config = ModConfig.get();
        ArrayList<class_20> modifiedIcons = null;
        byte playerRotation = 0;
        boolean rotationCalculated = false;
        for (class_20 icon : originalIcons) {
            if (icon.method_93() != class_20.class_21.field_91) continue;
            MapCenterTracker.updateFromOnMapIcon(self, icon, playerX, playerZ, this.field_119);
            break;
        }
        int mapHalfSize = 64 * (1 << this.field_119);
        double distance = MapCenterTracker.calculateDistance(self, playerX, playerZ);
        boolean hasValidDistance = distance >= 0.0;
        boolean isOffMap = false;
        MapCenterTracker.EstimatedCenter center = MapCenterTracker.getEstimatedCenter(self);
        if (center != null) {
            double dx = playerX - (double)center.x;
            double dz = playerZ - (double)center.z;
            isOffMap = Math.abs(dx) > (double)mapHalfSize || Math.abs(dz) > (double)mapHalfSize;
        }
        MapIconUtils.setPlayerContext(true);
        try {
            for (class_20 icon : originalIcons) {
                Object convertedOpt;
                class_20 prev;
                MapIconUtils.cachePlayerTypeFromIcon(icon);
                if (MapIconUtils.isPlayerOffMapAny(icon)) {
                    if (modifiedIcons == null) {
                        modifiedIcons = new ArrayList<class_20>();
                        Iterator dz = originalIcons.iterator();
                        while (dz.hasNext() && (prev = (class_20)dz.next()) != icon) {
                            modifiedIcons.add(prev);
                        }
                    }
                    if (!rotationCalculated) {
                        playerRotation = MapIconUtils.calculateMapRotation(client.field_1724.method_36454());
                        rotationCalculated = true;
                    }
                    if (!MapCenterTracker.hasCenter(self)) {
                        MapCenterTracker.estimateFromOffMapIcon(self, icon, playerX, playerZ, this.field_119);
                        distance = MapCenterTracker.calculateDistance(self, playerX, playerZ);
                        boolean bl = hasValidDistance = distance >= 0.0;
                    }
                    if (!((Optional)(convertedOpt = MapIconUtils.convertOffMapIcon(icon, playerRotation))).isPresent()) continue;
                    class_20 converted = ((Optional)convertedOpt).get();
                    if (config.isShowDistance() && hasValidDistance) {
                        boolean shouldShow;
                        boolean bl = shouldShow = config.isShowDistanceWhenOffMap() && isOffMap || config.isShowDistanceInsideBoundaries();
                        if (shouldShow) {
                            class_20 iconWithDistance = this.createIconWithDistance(converted, distance, config);
                            modifiedIcons.add(iconWithDistance);
                            continue;
                        }
                        modifiedIcons.add(converted);
                        continue;
                    }
                    modifiedIcons.add(converted);
                    continue;
                }
                if (icon.method_93() == class_20.class_21.field_91) {
                    if (config.isShowDistance() && config.isShowDistanceInsideBoundaries() && hasValidDistance) {
                        if (modifiedIcons == null) {
                            modifiedIcons = new ArrayList();
                            convertedOpt = originalIcons.iterator();
                            while (convertedOpt.hasNext() && (prev = (class_20)convertedOpt.next()) != icon) {
                                modifiedIcons.add(prev);
                            }
                        }
                        class_20 iconWithDistance = this.createIconWithDistance(icon, distance, config);
                        modifiedIcons.add(iconWithDistance);
                        continue;
                    }
                    if (modifiedIcons == null) continue;
                    modifiedIcons.add(icon);
                    continue;
                }
                if (modifiedIcons == null) continue;
                modifiedIcons.add(icon);
            }
            if (modifiedIcons != null) {
                cir.setReturnValue(modifiedIcons);
            }
        }
        finally {
            MapIconUtils.clearPlayerContext();
        }
    }

    private class_20 createIconWithDistance(class_20 original, double distance, ModConfig config) {
        String distanceText = config.formatDistance(distance);
        return new class_20(original.method_93(), original.method_90(), original.method_91(), original.method_89(), (class_2561)class_2561.method_43470((String)distanceText));
    }
}

