/*
 * Decompiled with CFR 0.152.
 */
package com.mrerenk.mapdistancefix.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mrerenk.mapdistancefix.client.MapdistancefixClient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("mapdistancefix.json");
    private static ModConfig INSTANCE;
    private Boolean showDistance = null;
    private Boolean showDistanceWhenOffMap = null;
    private Boolean showDistanceInsideBoundaries = null;
    private String distanceFormat = null;
    private Boolean useShortUnits = null;
    private Integer shortUnitThreshold = null;
    private static final boolean DEFAULT_SHOW_DISTANCE = true;
    private static final boolean DEFAULT_SHOW_DISTANCE_WHEN_OFF_MAP = true;
    private static final boolean DEFAULT_SHOW_DISTANCE_INSIDE_BOUNDARIES = false;
    private static final String DEFAULT_DISTANCE_FORMAT = "%dm";
    private static final boolean DEFAULT_USE_SHORT_UNITS = true;
    private static final int DEFAULT_SHORT_UNIT_THRESHOLD = 1000;

    public static ModConfig get() {
        if (INSTANCE == null) {
            INSTANCE = ModConfig.load();
        }
        return INSTANCE;
    }

    public static ModConfig load() {
        ModConfig config = null;
        boolean needsSave = false;
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                config = (ModConfig)GSON.fromJson(json, ModConfig.class);
            }
            catch (IOException e) {
                MapdistancefixClient.LOGGER.error("Failed to load config", (Throwable)e);
            }
            catch (Exception e) {
                MapdistancefixClient.LOGGER.error("Failed to parse config, using defaults", (Throwable)e);
            }
        }
        if (config == null) {
            config = new ModConfig();
            needsSave = true;
        }
        if (needsSave |= config.applyDefaults()) {
            config.save();
            MapdistancefixClient.LOGGER.info("Config saved with updated defaults");
        } else {
            MapdistancefixClient.LOGGER.info("Loaded config from {}", (Object)CONFIG_PATH);
        }
        return config;
    }

    private boolean applyDefaults() {
        boolean changed = false;
        if (this.showDistance == null) {
            this.showDistance = true;
            changed = true;
        }
        if (this.showDistanceWhenOffMap == null) {
            this.showDistanceWhenOffMap = true;
            changed = true;
        }
        if (this.showDistanceInsideBoundaries == null) {
            this.showDistanceInsideBoundaries = false;
            changed = true;
        }
        if (this.distanceFormat == null) {
            this.distanceFormat = DEFAULT_DISTANCE_FORMAT;
            changed = true;
        }
        if (this.useShortUnits == null) {
            this.useShortUnits = true;
            changed = true;
        }
        if (this.shortUnitThreshold == null) {
            this.shortUnitThreshold = 1000;
            changed = true;
        }
        return changed;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
            MapdistancefixClient.LOGGER.debug("Saved config to {}", (Object)CONFIG_PATH);
        }
        catch (IOException e) {
            MapdistancefixClient.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static void reload() {
        INSTANCE = ModConfig.load();
        MapdistancefixClient.LOGGER.info("Config reloaded");
    }

    public boolean isShowDistance() {
        return this.showDistance != null ? this.showDistance : true;
    }

    public boolean isShowDistanceWhenOffMap() {
        return this.showDistanceWhenOffMap != null ? this.showDistanceWhenOffMap : true;
    }

    public boolean isShowDistanceInsideBoundaries() {
        return this.showDistanceInsideBoundaries != null ? this.showDistanceInsideBoundaries : false;
    }

    public String getDistanceFormat() {
        return this.distanceFormat != null ? this.distanceFormat : DEFAULT_DISTANCE_FORMAT;
    }

    public boolean isUseShortUnits() {
        return this.useShortUnits != null ? this.useShortUnits : true;
    }

    public int getShortUnitThreshold() {
        return this.shortUnitThreshold != null ? this.shortUnitThreshold : 1000;
    }

    public void setShowDistance(boolean showDistance) {
        this.showDistance = showDistance;
    }

    public void setShowDistanceWhenOffMap(boolean showDistanceWhenOffMap) {
        this.showDistanceWhenOffMap = showDistanceWhenOffMap;
    }

    public void setShowDistanceInsideBoundaries(boolean showDistanceInsideBoundaries) {
        this.showDistanceInsideBoundaries = showDistanceInsideBoundaries;
    }

    public void setDistanceFormat(String distanceFormat) {
        this.distanceFormat = distanceFormat;
    }

    public void setUseShortUnits(boolean useShortUnits) {
        this.useShortUnits = useShortUnits;
    }

    public void setShortUnitThreshold(int shortUnitThreshold) {
        this.shortUnitThreshold = shortUnitThreshold;
    }

    public String formatDistance(double distanceBlocks) {
        int distance = (int)Math.round(distanceBlocks);
        if (this.isUseShortUnits() && distance >= this.getShortUnitThreshold()) {
            double shortened = (double)distance / 1000.0;
            if (shortened >= 10.0) {
                return String.format("%.0fk", shortened);
            }
            return String.format("%.1fk", shortened);
        }
        try {
            return String.format(this.getDistanceFormat(), distance);
        }
        catch (Exception e) {
            return distance + "m";
        }
    }
}

