/*
 * Decompiled with CFR 0.152.
 */
package com.mrerenk.mapdistancefix.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mrerenk.mapdistancefix.config.ModConfig;
import com.mrerenk.mapdistancefix.util.MapCenterTracker;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class MapdistancefixClient
implements ClientModInitializer {
    public static final String MOD_ID = "map-distance-fix";
    public static final String MOD_NAME = "MapDistanceFix";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MapDistanceFix");

    public void onInitializeClient() {
        String version = FabricLoader.getInstance().getModContainer(MOD_ID).map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse("Unknown");
        LOGGER.info("Initializing {} v{}", (Object)MOD_NAME, (Object)version);
        ModConfig.get();
        ClientCommandRegistrationCallback.EVENT.register(this::registerCommands);
        LOGGER.info("{} v{} initialized successfully", (Object)MOD_NAME, (Object)version);
    }

    private void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mapdistancefix").then(ClientCommandManager.literal((String)"reload").executes(context -> {
            ModConfig.reload();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7a[MapDistanceFix] Config reloaded!"));
            return 1;
        }))).then(ClientCommandManager.literal((String)"status").executes(context -> {
            ModConfig config = ModConfig.get();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76[MapDistanceFix] Current settings:"));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  showDistance: \u00a7f" + config.isShowDistance())));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  showDistanceWhenOffMap: \u00a7f" + config.isShowDistanceWhenOffMap())));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  showDistanceInsideBoundaries: \u00a7f" + config.isShowDistanceInsideBoundaries())));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  distanceFormat: \u00a7f" + config.getDistanceFormat())));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  useShortUnits: \u00a7f" + config.isUseShortUnits())));
            return 1;
        }))).then(ClientCommandManager.literal((String)"clearcache").executes(context -> {
            MapCenterTracker.clearCache();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7a[MapDistanceFix] Map center cache cleared!"));
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mdf").redirect(dispatcher.getRoot().getChild("mapdistancefix")));
    }
}

