/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;

public class Credits
implements Serializable {
    private static final Codec<Credits> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING, Supporter.CODEC).fieldOf("supporters").forGetter(p -> p.supporters), (App)Codec.STRING.listOf().fieldOf("additional_artists").forGetter(p -> p.otherArtists), (App)Codec.STRING.listOf().fieldOf("translators").forGetter(p -> p.translators), (App)Codec.STRING.listOf().fieldOf("mod_compatibility").forGetter(p -> p.modCompatibility), (App)Codec.STRING.listOf().fieldOf("music_and_sounds").forGetter(p -> p.soundArtists), (App)Codec.STRING.listOf().fieldOf("others").forGetter(p -> p.others)).apply((Applicative)i, Credits::new));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(Credits.class, (json, typeOfT, context) -> (Credits)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {})).create();
    public static Credits INSTANCE = new Credits(Map.of(), List.of(), List.of(), List.of(), List.of(), List.of());
    private final transient List<UUID> devs = new ArrayList<UUID>();
    private final transient Map<String, Pair<UUID, String>> statues = new HashMap<String, Pair<UUID, String>>();
    private final transient Map<String, class_2960> globes = new HashMap<String, class_2960>();
    private final transient Map<String, Supporter> supporters;
    private final List<String> otherArtists;
    private final List<String> translators;
    private final List<String> modCompatibility;
    private final List<String> soundArtists;
    private final List<String> others;

    private Credits(Map<String, Supporter> supporters, List<String> artists, List<String> translators, List<String> mod_compat, List<String> sounds, List<String> others) {
        this.supporters = supporters;
        this.otherArtists = artists;
        this.translators = translators;
        this.modCompatibility = mod_compat;
        this.soundArtists = sounds;
        this.others = others;
        this.addSpecialPlayer("Dev", true, false, false, "380df991-f603-344c-a090-369bad2a924a", new String[0]);
        this.addSpecialPlayer("Dev", true, false, true, "5084e6f3-8f54-43f1-8df5-1dca109e430f", new String[0]);
        this.addSpecialPlayer("MehVahdJukaar", true, false, true, "898b3a39-e486-405c-a873-d6b472dc3ba2", "TheEvilGolem");
        this.addSpecialPlayer("Plantkillable", true, true, true, "720f165c-b066-4113-9622-63fc63c65696", new String[0]);
        this.addSpecialPlayer("DarkShrek_", true, false, true, "351a126a-705e-4c5f-9ab1-3051f18e16f0", new String[0]);
        this.addSpecialPlayer("Agrona", true, true, false, (UUID)null, "Pancake", "Pancakes");
        this.supporters.forEach((n, s) -> this.addSpecialPlayer((String)n, false, s.has_globe, s.has_statue, s.uuid, s.alias));
    }

    private void addSpecialPlayer(String name, boolean isDev, boolean hasGlobe, boolean hasStatue, String id, String ... alias) {
        UUID onlineId = id == null ? null : UUID.fromString(id);
        this.addSpecialPlayer(name, isDev, hasGlobe, hasStatue, onlineId, new String[0]);
    }

    private void addSpecialPlayer(String name, boolean isDev, boolean hasGlobe, boolean hasStatue, @Nullable UUID onlineId, String ... alias) {
        name = name.toLowerCase(Locale.ROOT);
        if (isDev) {
            if (onlineId != null) {
                this.devs.add(onlineId);
            }
            this.devs.add(class_4844.method_43344((String)name));
        }
        if (hasGlobe) {
            class_2960 texture = new class_2960("supplementaries", "textures/entity/globes/globe_" + name + ".png");
            this.globes.put(name, texture);
            for (String n : alias) {
                if (n == null) continue;
                this.globes.put(n.toLowerCase(Locale.ROOT), texture);
            }
        }
        Pair p = Pair.of((Object)onlineId, (Object)name);
        if (hasStatue) {
            this.statues.put(name, (Pair<UUID, String>)p);
            for (String n : alias) {
                if (n == null) continue;
                this.statues.put(n.toLowerCase(Locale.ROOT), (Pair<UUID, String>)p);
            }
        }
    }

    public Map<String, class_2960> globes() {
        return this.globes;
    }

    public Map<String, Pair<UUID, String>> statues() {
        return this.statues;
    }

    public List<UUID> getDevs() {
        return this.devs;
    }

    public String createCreditsText() {
        StringBuilder builder = new StringBuilder();
        builder.append("\u00a76\n\u00a7lSupplementaries\n\n\n\n\n\u00a74Author:\u00a7r\n+\n\u00a70MehVahdJukaar\n\n\u00a74Artist:\u00a7r\n\n\u00a70Plantkillable\n\n\n");
        builder.append("\u00a74Supporters:\u00a7r\n\u00a70\n");
        this.supporters.keySet().forEach(s -> builder.append((String)s).append("\n"));
        builder.append("\n\n");
        builder.append("\u00a75Mod Compatibility:\u00a7r\n\u00a70\n");
        this.modCompatibility.forEach(s -> builder.append((String)s).append("\n"));
        builder.append("\n\n");
        builder.append("\u00a75Music and Sounds:\u00a7r\n\u00a70\n");
        this.soundArtists.forEach(s -> builder.append((String)s).append("\n"));
        builder.append("\n\n");
        builder.append("\u00a75Other Artists:\u00a7r\n\u00a70\n");
        this.otherArtists.forEach(s -> builder.append((String)s).append("\n"));
        builder.append("\n\n");
        builder.append("\u00a75Translators:\u00a7r\n\u00a70\n");
        this.translators.forEach(s -> builder.append((String)s).append("\n"));
        builder.append("\n\n");
        builder.append("\u00a75Others:\u00a7r\n\u00a70\n");
        this.others.forEach(s -> builder.append((String)s).append("\n"));
        builder.append("\n\n\n\n\n");
        return builder.toString();
    }

    private static <T> T readFromURL(String link, Function<Reader, T> readerConsumer) throws IOException {
        URL url = new URL(link);
        URLConnection connection = url.openConnection();
        String encoding = connection.getContentEncoding();
        Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), charset));){
            T t = readerConsumer.apply(reader);
            return t;
        }
    }

    public static void fetchFromServer() {
        Thread creditsFetcher = new Thread(() -> {
            String link = "https://raw.githubusercontent.com/MehVahdJukaar/Supplementaries/master/credits.json";
            try {
                INSTANCE = Credits.readFromURL(link, r -> (Credits)GSON.fromJson(r, Credits.class));
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("Failed to fetch contributors data from url {}, {}", (Object)link, (Object)e);
            }
        });
        creditsFetcher.start();
    }

    private static final class Supporter {
        private static final Codec<Supporter> CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of((Codec)class_4844.field_41525, (String)"uuid").forGetter(p -> Optional.ofNullable(p.uuid)), (App)StrOpt.of((Codec)Codec.BOOL, (String)"has_statue", (Object)false).forGetter(p -> p.has_statue), (App)StrOpt.of((Codec)Codec.BOOL, (String)"has_globe", (Object)false).forGetter(p -> p.has_globe), (App)StrOpt.of((Codec)Codec.STRING, (String)"alias").forGetter(p -> Optional.ofNullable(p.alias))).apply((Applicative)i, Supporter::new));
        @Nullable
        private final UUID uuid;
        @Nullable
        private final String alias;
        private final boolean has_statue;
        private final boolean has_globe;

        private Supporter(Optional<UUID> uuid, boolean has_statue, boolean has_globe, Optional<String> alias) {
            this.uuid = uuid.orElse(null);
            this.has_statue = has_statue;
            this.has_globe = has_globe;
            this.alias = alias.orElse(null);
        }
    }
}

