/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.patches.armorpointspp;

import com.github.thedeathlycow.thermoo.api.client.StatusBarOverlayRenderEvents;
import com.github.thedeathlycow.thermoo.patches.ThermooPatches;
import dev.cheos.armorpointspp.config.ApppConfig;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.render.Components;
import dev.cheos.libhud.LibhudGui;
import dev.cheos.libhud.VanillaComponents;
import dev.cheos.libhud.api.Component;
import dev.cheos.libhud.api.LibhudApi;
import dev.cheos.libhud.api.event.RegisterComponentsEvent;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_636;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class LibhudCompat
implements LibhudApi {
    public static final int ORANGE = 16753920;
    private static final int MAX_DISPLAY_HEALTH = 20;
    private static final Vector2i[] heartPositionsPool = new Vector2i[10];
    public static final Component.NamedComponent PLAYER_TEMPERATURE_OVERLAY = Component.named((class_2960)ThermooPatches.id("player_temperature_overlay"), LibhudCompat::playerTemperatureOverlay);
    public static final Component.NamedComponent MOUNT_TEMPERATURE_OVERLAY = Component.named((class_2960)ThermooPatches.id("mount_temperature_overlay"), LibhudCompat::mountTemperatureOverlay);

    public void onRegisterComponents(RegisterComponentsEvent event) {
        event.registerAbove(VanillaComponents.HEALTH, PLAYER_TEMPERATURE_OVERLAY);
        event.registerAbove(VanillaComponents.VEHICLE_HEALTH, MOUNT_TEMPERATURE_OVERLAY);
    }

    private static void playerTemperatureOverlay(LibhudGui gui, class_332 graphics, float tickDelta, int screenWidth, int screenHeight) {
        class_1657 player = LibhudCompat.getCameraPlayer(false);
        if (player == null) {
            return;
        }
        int baseX = screenWidth / 2 - 91;
        Arrays.fill(heartPositionsPool, null);
        int[] heartYPositions = Components.HEALTH.lastHeartY();
        for (int i = 0; i < heartYPositions.length; ++i) {
            LibhudCompat.heartPositionsPool[i] = new Vector2i(baseX + i * 8, heartYPositions[i]);
        }
        int displayMaxHealth = ApppConfig.instance().bool((IConfig.Option)IConfig.BooleanOption.HEALTH_BG_ALWAYS_SHOW_10) ? 20 : LibhudCompat.getMaxDisplayHealth((class_1309)player);
        ((StatusBarOverlayRenderEvents.RenderHealthBarCallback)StatusBarOverlayRenderEvents.AFTER_HEALTH_BAR.invoker()).render(graphics, player, heartPositionsPool, LibhudCompat.getDisplayHealth((class_1309)player), displayMaxHealth);
    }

    private static void mountTemperatureOverlay(LibhudGui gui, class_332 graphics, float tickDelta, int screenWidth, int screenHeight) {
        class_1657 player = LibhudCompat.getCameraPlayer(true);
        if (player == null) {
            return;
        }
        class_1309 mount = LibhudCompat.getMountEntity(player);
        if (mount == null) {
            return;
        }
        int baseX = screenWidth / 2 + 91;
        int baseY = screenHeight - 39;
        Arrays.fill(heartPositionsPool, null);
        int displayMaxHealth = LibhudCompat.getMaxDisplayHealth(mount);
        for (int i = 0; i < displayMaxHealth / 2; ++i) {
            LibhudCompat.heartPositionsPool[i] = new Vector2i(baseX - i * 8 - 9, baseY);
        }
        ((StatusBarOverlayRenderEvents.RenderMountHealthBarCallback)StatusBarOverlayRenderEvents.AFTER_MOUNT_HEALTH_BAR.invoker()).render(graphics, player, mount, heartPositionsPool, LibhudCompat.getDisplayHealth(mount), displayMaxHealth);
    }

    private static int getMaxDisplayHealth(class_1309 entity) {
        return Math.min(class_3532.method_15386((float)entity.method_6063()), 20);
    }

    private static int getDisplayHealth(class_1309 entity) {
        return Math.min(class_3532.method_15386((float)entity.method_6032()), 20);
    }

    @Nullable
    private static class_1657 getCameraPlayer(boolean showInCreative) {
        class_1657 player;
        class_310 client = class_310.method_1551();
        class_636 interactionManager = client.field_1761;
        if (!showInCreative && interactionManager != null && !interactionManager.method_2908()) {
            return null;
        }
        class_1297 entity = client.field_1719;
        return entity instanceof class_1657 ? (player = (class_1657)entity) : null;
    }

    private static class_1309 getMountEntity(class_1657 player) {
        if (player != null) {
            class_1297 entity = player.method_5854();
            if (entity == null) {
                return null;
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                return livingEntity;
            }
        }
        return null;
    }
}

