/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasonsextras.blockentities;

import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.GreenhouseCache;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasonsextras.FabricSeasonsExtras;
import io.github.lucaargolo.seasonsextras.block.AirConditioningBlock;
import io.github.lucaargolo.seasonsextras.screenhandlers.AirConditioningScreenHandler;
import io.github.lucaargolo.seasonsextras.utils.ModIdentifier;
import io.github.lucaargolo.seasonsextras.utils.SlotSimpleInventory;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class AirConditioningBlockEntity
extends class_2586
implements class_1263,
class_1278 {
    private GreenhouseCache.GreenHouseTicket ticket = null;
    private Conditioning conditioning;
    private boolean particles = true;
    private int progress = 0;
    private int lastProgress = 0;
    private int level = 0;
    private boolean halt = false;
    private final FilteredSimpleInventory inputInventory = new FilteredSimpleInventory(9);
    private final FilteredSimpleInventory moduleInventory = new FilteredSimpleInventory(3);
    private final BurnSlot[] burnSlots = new BurnSlot[]{new BurnSlot(true, false, 0, 0), new BurnSlot(false, false, 0, 0), new BurnSlot(false, false, 0, 0)};
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return AirConditioningBlockEntity.this.progress;
                }
                case 1: {
                    return AirConditioningBlockEntity.this.conditioning.ordinal();
                }
                case 2: {
                    return AirConditioningBlockEntity.this.particles ? 1 : 0;
                }
                case 3: {
                    return AirConditioningBlockEntity.this.burnSlots[0].enabled ? 1 : 0;
                }
                case 4: {
                    return AirConditioningBlockEntity.this.burnSlots[0].burnTime;
                }
                case 5: {
                    return AirConditioningBlockEntity.this.burnSlots[0].burnTimeTotal;
                }
                case 6: {
                    return AirConditioningBlockEntity.this.burnSlots[1].enabled ? 1 : 0;
                }
                case 7: {
                    return AirConditioningBlockEntity.this.burnSlots[1].burnTime;
                }
                case 8: {
                    return AirConditioningBlockEntity.this.burnSlots[1].burnTimeTotal;
                }
                case 9: {
                    return AirConditioningBlockEntity.this.burnSlots[2].enabled ? 1 : 0;
                }
                case 10: {
                    return AirConditioningBlockEntity.this.burnSlots[2].burnTime;
                }
                case 11: {
                    return AirConditioningBlockEntity.this.burnSlots[2].burnTimeTotal;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return 12;
        }
    };

    public AirConditioningBlockEntity(class_2338 pos, class_2680 state, Conditioning conditioning) {
        super(FabricSeasonsExtras.AIR_CONDITIONING_TYPE, pos, state);
        this.conditioning = conditioning;
    }

    public AirConditioningBlockEntity(class_2338 pos, class_2680 state) {
        this(pos, state, Conditioning.HEATER);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("progress", this.progress);
        class_2487 inputInventoryNbt = new class_2487();
        class_1262.method_5426((class_2487)inputInventoryNbt, (class_2371)this.inputInventory.field_5828);
        nbt.method_10566("inputInventory", (class_2520)inputInventoryNbt);
        class_2487 moduleInventoryNbt = new class_2487();
        class_1262.method_5426((class_2487)moduleInventoryNbt, (class_2371)this.moduleInventory.field_5828);
        nbt.method_10566("moduleInventory", (class_2520)moduleInventoryNbt);
        for (int i = 0; i < this.burnSlots.length; ++i) {
            nbt.method_10566("module_" + i, (class_2520)this.burnSlots[i].writeNbt(new class_2487()));
        }
        this.writeClientNbt(nbt);
    }

    public void writeClientNbt(class_2487 nbt) {
        nbt.method_10569("conditioning", this.conditioning.ordinal());
        nbt.method_10556("particles", this.particles);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.progress = nbt.method_10550("progress");
        class_1262.method_5429((class_2487)nbt.method_10562("inputInventory"), (class_2371)this.inputInventory.field_5828);
        class_1262.method_5429((class_2487)nbt.method_10562("moduleInventory"), (class_2371)this.moduleInventory.field_5828);
        for (int i = 0; i < this.burnSlots.length; ++i) {
            this.burnSlots[i].readNbt(nbt.method_10562("module_" + i));
        }
        this.readClientNbt(nbt);
    }

    public void readClientNbt(class_2487 nbt) {
        this.conditioning = Conditioning.values()[Math.max(0, Math.min(Conditioning.values().length, nbt.method_10550("conditioning")))];
        this.particles = nbt.method_10577("particles");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.writeClientNbt(nbt);
        return nbt;
    }

    public class_3913 getPropertyDelegate() {
        return this.propertyDelegate;
    }

    public class_1277 getInputInventory() {
        return this.inputInventory;
    }

    public class_1277 getModuleInventory() {
        return this.moduleInventory;
    }

    public void cycleButton(int index) {
        this.method_5431();
        switch (index) {
            case 0: {
                this.burnSlots[0].enabled = !this.burnSlots[0].enabled;
                break;
            }
            case 1: {
                this.burnSlots[1].enabled = !this.burnSlots[1].enabled;
                break;
            }
            case 2: {
                this.burnSlots[2].enabled = !this.burnSlots[2].enabled;
                break;
            }
            case 3: {
                this.particles = !this.particles;
                class_1937 class_19372 = this.field_11863;
                if (!(class_19372 instanceof class_3218)) break;
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_14178().method_14128(this.field_11867);
            }
        }
    }

    private void updateHalt(Storage<ItemVariant> inputStorage, Predicate<ItemVariant> filter) {
        try (Transaction transaction = Transaction.openOuter();){
            ItemVariant variant = (ItemVariant)StorageUtil.findExtractableResource(inputStorage, filter, (TransactionContext)transaction);
            if (variant == null || variant.isBlank()) {
                this.halt = true;
            }
            transaction.commit();
        }
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, AirConditioningBlockEntity entity) {
        InventoryStorage inputStorage = InventoryStorage.of((class_1263)entity.inputInventory, null);
        Predicate<ItemVariant> filter = entity.conditioning.getFilter();
        entity.updateHalt((Storage<ItemVariant>)inputStorage, filter);
        BurnSlot[] burnSlots = AirConditioningScreenHandler.getBurnSlots((class_1263)entity.moduleInventory, entity.propertyDelegate);
        int maxProgress = AirConditioningScreenHandler.getMaxProgress(burnSlots);
        entity.progress = entity.halt || entity.progress >= maxProgress ? 0 : (entity.progress + 3 > maxProgress ? maxProgress : (entity.progress += 3));
        burnSlots = entity.burnSlots;
        entity.level = 0;
        for (int i = 0; i < burnSlots.length; ++i) {
            Transaction transaction;
            BurnSlot burnSlot = burnSlots[i];
            int amount = 41 + 18 * i;
            InventoryStorage moduleStorage = InventoryStorage.of((class_1263)new SlotSimpleInventory(entity.moduleInventory, i), null);
            if (burnSlot.enabled && entity.progress >= amount && entity.lastProgress < amount) {
                transaction = Transaction.openOuter();
                try {
                    StorageUtil.move((Storage)inputStorage, (Storage)moduleStorage, filter, (long)1L, (TransactionContext)transaction);
                    transaction.commit();
                }
                finally {
                    if (transaction != null) {
                        transaction.close();
                    }
                }
                entity.updateHalt((Storage<ItemVariant>)inputStorage, filter);
            }
            if (burnSlot.burnTime <= 0 || --burnSlot.burnTime <= 0) {
                transaction = Transaction.openOuter();
                try {
                    ItemVariant variant = (ItemVariant)StorageUtil.findExtractableResource((Storage)moduleStorage, filter, (TransactionContext)transaction);
                    if (variant != null && !variant.isBlank() && moduleStorage.extract((Object)variant, 1L, (TransactionContext)transaction) == 1L) {
                        burnSlot.burnTime = burnSlot.burnTimeTotal = entity.conditioning.getFuel(variant);
                        ItemVariant result = (ItemVariant)StorageUtil.findExtractableResource((Storage)moduleStorage, filter, (TransactionContext)transaction);
                        if ((result == null || result.isBlank()) && variant.getItem().method_7857()) {
                            class_1792 item = variant.getItem().method_7858();
                            class_1799 stack = item == null ? class_1799.field_8037 : new class_1799((class_1935)item);
                            ItemVariant remainder = ItemVariant.of((class_1799)stack);
                            moduleStorage.insert((Object)remainder, 1L, (TransactionContext)transaction);
                        }
                        transaction.commit();
                    } else {
                        transaction.abort();
                    }
                }
                finally {
                    if (transaction != null) {
                        transaction.close();
                    }
                }
            }
            if (burnSlot.burnTime <= 0) continue;
            ++entity.level;
        }
        if (entity.level > 0) {
            Season worldSeason = FabricSeasons.getCurrentSeason((class_1937)world);
            Season conditionedSeason = entity.conditioning.getConditioned(worldSeason, entity.level);
            if (entity.ticket == null || entity.ticket.expired || !entity.ticket.seasons.contains(conditionedSeason)) {
                class_3341 box = class_3341.method_34390((class_2382)pos.method_10069(-4, -4, -4), (class_2382)pos.method_10069(4, 4, 4));
                entity.ticket = new GreenhouseCache.GreenHouseTicket(box, new Season[]{conditionedSeason});
                class_1923 corner1 = new class_1923(pos.method_10069(-4, -4, -4));
                class_1923 corner2 = new class_1923(pos.method_10069(4, 4, 4));
                for (int x = Math.min(corner1.field_9181, corner2.field_9181); x < Math.max(corner1.field_9181, corner2.field_9181) - Math.min(corner1.field_9181, corner2.field_9181) + 1 + Math.min(corner1.field_9181, corner2.field_9181); ++x) {
                    for (int z = Math.min(corner1.field_9180, corner2.field_9180); z < Math.max(corner1.field_9180, corner2.field_9180) - Math.min(corner1.field_9180, corner2.field_9180) + 1 + Math.min(corner1.field_9180, corner2.field_9180); ++z) {
                        GreenhouseCache.add((class_1937)world, (class_1923)new class_1923(x, z), (GreenhouseCache.GreenHouseTicket)entity.ticket);
                    }
                }
            } else {
                ++entity.ticket.age;
            }
        }
        if ((Integer)state.method_11654(AirConditioningBlock.LEVEL) != entity.level) {
            world.method_8501(pos, (class_2680)state.method_11657(AirConditioningBlock.LEVEL, (Comparable)Integer.valueOf(entity.level)));
        }
        entity.lastProgress = entity.progress;
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, AirConditioningBlockEntity entity) {
        if (entity.particles) {
            class_5819 random = world.method_8409();
            int level = (Integer)state.method_11654(AirConditioningBlock.LEVEL);
            if (level > 0) {
                for (int a = 0; a < random.method_43048(class_3532.method_15384((double)Math.pow(3.0, level))); ++a) {
                    world.method_8406(entity.conditioning.getParticle(), (double)pos.method_10263() + (double)(random.method_43048(900) - 400) / 100.0, (double)pos.method_10264() + (double)(random.method_43048(900) - 400) / 100.0, (double)pos.method_10260() + (double)(random.method_43048(900) - 400) / 100.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public int method_5439() {
        return this.inputInventory.method_5439() + this.moduleInventory.method_5439();
    }

    public boolean method_5442() {
        return this.inputInventory.method_5442() && this.moduleInventory.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return slot < this.inputInventory.method_5439() ? this.inputInventory.method_5438(slot) : this.moduleInventory.method_5438(slot - this.inputInventory.method_5439());
    }

    public class_1799 method_5434(int slot, int amount) {
        return slot < this.inputInventory.method_5439() ? this.inputInventory.method_5434(slot, amount) : this.moduleInventory.method_5434(slot - this.inputInventory.method_5439(), amount);
    }

    public class_1799 method_5441(int slot) {
        return slot < this.inputInventory.method_5439() ? this.inputInventory.method_5441(slot) : this.moduleInventory.method_5441(slot - this.inputInventory.method_5439());
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot < this.inputInventory.method_5439()) {
            this.inputInventory.method_5447(slot, stack);
        } else {
            this.moduleInventory.method_5447(slot - this.inputInventory.method_5439(), stack);
        }
    }

    public boolean method_5443(class_1657 player) {
        return this.inputInventory.method_5443(player) && this.moduleInventory.method_5443(player);
    }

    public void method_5448() {
        this.inputInventory.method_5448();
        this.moduleInventory.method_5448();
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return Arrays.stream(this.moduleInventory.method_5494(side)).map(i -> i + this.inputInventory.method_5439()).toArray();
        }
        return this.inputInventory.method_5494(side);
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot < this.inputInventory.method_5439() ? this.inputInventory.method_5492(slot, stack, dir) : this.moduleInventory.method_5492(slot, stack, dir);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot < this.inputInventory.method_5439() ? this.inputInventory.method_5493(slot, stack, dir) : this.moduleInventory.method_5493(slot, stack, dir);
    }

    private class FilteredSimpleInventory
    extends class_1277
    implements class_1278 {
        private final int[] slots;

        public FilteredSimpleInventory(int size) {
            super(size);
            this.slots = new int[size];
            for (int s = 0; s < size; ++s) {
                this.slots[s] = s;
            }
        }

        public void method_5431() {
            super.method_5431();
            AirConditioningBlockEntity.this.halt = false;
            AirConditioningBlockEntity.this.method_5431();
        }

        public int[] method_5494(class_2350 side) {
            return this.slots;
        }

        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return AirConditioningBlockEntity.this.conditioning.getFilter().test(ItemVariant.of((class_1799)stack));
        }

        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return !this.method_5492(slot, stack, dir);
        }
    }

    public static class BurnSlot {
        public boolean enabled;
        public boolean full;
        public int burnTime;
        public int burnTimeTotal;

        public BurnSlot(boolean enabled, boolean full, int burnTime, int burnTimeTotal) {
            this.enabled = enabled;
            this.full = full;
            this.burnTime = burnTime;
            this.burnTimeTotal = burnTimeTotal;
        }

        public void readNbt(class_2487 nbt) {
            this.enabled = nbt.method_10577("enabled");
            this.burnTime = nbt.method_10550("burnTime");
            this.burnTimeTotal = nbt.method_10550("burnTimeTotal");
        }

        public class_2487 writeNbt(class_2487 nbt) {
            nbt.method_10556("enabled", this.enabled);
            nbt.method_10569("burnTime", this.burnTime);
            nbt.method_10569("burnTimeTotal", this.burnTimeTotal);
            return nbt;
        }
    }

    public static enum Conditioning {
        HEATER(new ModIdentifier("textures/gui/heater.png"), stack -> {
            Integer fuel = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
            if (fuel != null) {
                return fuel * 3;
            }
            return 0;
        }, (current, level) -> {
            if (level == 2 && current == Season.WINTER) {
                return Season.SPRING;
            }
            if (level == 1 && current == Season.FALL) {
                return Season.SPRING;
            }
            if (level == 1 && current == Season.WINTER) {
                return Season.FALL;
            }
            return Season.SUMMER;
        }, (class_2394)class_2398.field_11240),
        CHILLER(new ModIdentifier("textures/gui/chiller.png"), stack -> {
            if (stack.method_31574(class_1802.field_27876)) {
                return 600;
            }
            if (stack.method_31574(class_1802.field_8246)) {
                return 600;
            }
            if (stack.method_31574(class_1802.field_8081)) {
                return 10800;
            }
            if (stack.method_31574(class_1802.field_8178)) {
                return 97200;
            }
            if (stack.method_31574(class_1802.field_8543)) {
                return 150;
            }
            if (stack.method_31574(class_1802.field_8749)) {
                return 300;
            }
            if (stack.method_31574(class_1802.field_8426)) {
                return 1200;
            }
            return 0;
        }, (current, level) -> {
            if (level == 2 && current == Season.SUMMER) {
                return Season.FALL;
            }
            if (level == 1 && current == Season.SPRING) {
                return Season.FALL;
            }
            if (level == 1 && current == Season.SUMMER) {
                return Season.SPRING;
            }
            return Season.WINTER;
        }, (class_2394)class_2398.field_28013);

        private final class_2960 texture;
        private final Function<class_1799, Integer> fuel;
        private final BiFunction<Season, Integer, Season> conditioning;
        private final class_2394 particle;

        private Conditioning(class_2960 texture, Function<class_1799, Integer> fuel, BiFunction<Season, Integer, Season> conditioning, class_2394 particle) {
            this.texture = texture;
            this.fuel = fuel;
            this.conditioning = conditioning;
            this.particle = particle;
        }

        public Season getConditioned(Season current, int level) {
            return this.conditioning.apply(current, level);
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public int getFuel(ItemVariant variant) {
            Integer fuelTime = this.fuel.apply(variant.toStack());
            return fuelTime != null ? fuelTime : 0;
        }

        public Predicate<ItemVariant> getFilter() {
            return variant -> {
                Integer fuelTime = this.fuel.apply(variant.toStack());
                return fuelTime != null && fuelTime > 0;
            };
        }

        public class_2394 getParticle() {
            return this.particle;
        }
    }
}

