/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.logging.PacketLogging;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import net.minecraft.class_2532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2532.class}, priority=99)
public abstract class CompressionDecoderMixin
extends ByteToMessageDecoder {
    @Shadow
    private int field_11623;
    @Shadow
    private boolean field_34058;
    @Unique
    private int size = 0;
    @Unique
    private boolean originalValidate = false;

    @Inject(method={"decode"}, at={@At(value="HEAD")})
    private void disabledLimit(ChannelHandlerContext p_129441_, ByteBuf p_129442_, List<Object> p_129443_, CallbackInfo ci) {
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).disablePacketLimits) {
            this.originalValidate = this.field_34058;
            this.field_34058 = false;
        }
    }

    @Inject(method={"decode"}, at={@At(value="RETURN")})
    private void restoreLimit(ChannelHandlerContext p_129441_, ByteBuf p_129442_, List<Object> p_129443_, CallbackInfo ci) {
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).disablePacketLimits) {
            this.field_34058 = this.originalValidate;
        }
    }

    @Inject(method={"decode"}, at={@At(value="INVOKE", target="Lio/netty/handler/codec/DecoderException;<init>(Ljava/lang/String;)V")}, remap=false)
    private void onError(ChannelHandlerContext p_129441_, ByteBuf p_129442_, List<Object> p_129443_, CallbackInfo ci) {
        this.printDebug(p_129443_);
    }

    @Unique
    private void printDebug(List<Object> decodingResults) {
        if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
            return;
        }
        Connectivity.LOGGER.error("Received message causing a decode exception below, printing data:!");
        Connectivity.LOGGER.error("----BEGIND PRINTING PACKET-----");
        for (int i = 0; i < decodingResults.size(); ++i) {
            ByteBuf buf = (ByteBuf)decodingResults.get(i);
            if (buf == null) continue;
            Connectivity.LOGGER.error("Data:");
            boolean prev = ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages;
            ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = true;
            PacketLogging.logPacket(buf);
            ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages = prev;
            buf.resetReaderIndex();
        }
        Connectivity.LOGGER.error("----END PRINTING PACKET-----");
    }
}

