/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.logging;

import com.connectivity.Connectivity;
import com.connectivity.logging.BlockEntityTypeHandler;
import com.connectivity.logging.ByteArraySerializer;
import com.connectivity.logging.ByteBufferTypeHandler;
import com.connectivity.logging.DoubleArraySerializer;
import com.connectivity.logging.EntityTypeHandler;
import com.connectivity.logging.FloatArraySerializer;
import com.connectivity.logging.GsonErrorHandling;
import com.connectivity.logging.GsonOptionalTypeHandler;
import com.connectivity.logging.HolderReferenceTypeHandler;
import com.connectivity.logging.IntArraySerializer;
import com.connectivity.logging.IterableTypeHandler;
import com.connectivity.logging.LongArraySerializer;
import com.connectivity.logging.RecipeTypeHandler;
import com.connectivity.networkstats.INamedPacket;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.TypeAdapterFactory;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1860;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_6880;

public class PacketLogging {
    private static Object lastPacket = null;

    public static final Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().addReflectionAccessFilter(ReflectionAccessFilter.BLOCK_INACCESSIBLE_JAVA).registerTypeAdapterFactory((TypeAdapterFactory)new GsonErrorHandling()).registerTypeHierarchyAdapter(Optional.class, new GsonOptionalTypeHandler()).registerTypeHierarchyAdapter(class_1299.class, new EntityTypeHandler()).registerTypeHierarchyAdapter(class_2591.class, (Object)new BlockEntityTypeHandler()).registerTypeHierarchyAdapter(ByteBuf.class, new ByteBufferTypeHandler()).registerTypeHierarchyAdapter(class_6880.class_6883.class, new HolderReferenceTypeHandler()).addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return f.getDeclaredType() instanceof class_2378 || f.getDeclaredType() instanceof class_6880;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz.isInstance(class_2378.class) || clazz.isInstance(class_6880.class) || clazz.getName().contains("jdk.internal");
            }
        }).registerTypeHierarchyAdapter(int[].class, (Object)new IntArraySerializer()).registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArraySerializer()).registerTypeHierarchyAdapter(double[].class, (Object)new DoubleArraySerializer()).registerTypeHierarchyAdapter(float[].class, (Object)new FloatArraySerializer()).registerTypeHierarchyAdapter(long[].class, (Object)new LongArraySerializer()).registerTypeHierarchyAdapter(Iterable.class, new IterableTypeHandler()).registerTypeAdapter(class_1860.class, (Object)new RecipeTypeHandler()).create();
    }

    public static void logPacket(Object packet) {
        PacketLogging.logPacket(packet, "");
    }

    public static void logPacket(Object packet, String warning) {
        if (packet == lastPacket) {
            return;
        }
        lastPacket = packet;
        String name = packet.getClass().getSimpleName();
        if (packet instanceof INamedPacket && !((INamedPacket)packet).getName().isEmpty()) {
            name = ((INamedPacket)packet).getName();
        }
        Connectivity.LOGGER.warn("Packet:" + name + " " + warning);
        try {
            Connectivity.LOGGER.warn("Packet data:\n" + PacketLogging.getGson().toJson(packet));
        }
        catch (Throwable e) {
            Connectivity.LOGGER.warn("Failed to print data for packet", e);
        }
    }
}

