/*
 * Decompiled with CFR 0.152.
 */
package toni.packanalytics;

import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraftforge.fml.config.IConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toni.lib.utils.PlatformUtils;
import toni.packanalytics.BCCCompat;
import toni.packanalytics.foundation.config.AllConfigs;

public class PackAnalytics
implements ModInitializer {
    public static final String MODNAME = "Pack Analytics";
    public static final String ID = "packanalytics";
    public static final Logger LOGGER = LogManager.getLogger((String)"Pack Analytics");
    private ScheduledExecutorService scheduler;

    public void onInitialize() {
        AllConfigs.register((type, spec) -> ForgeConfigRegistry.INSTANCE.register(ID, type, (IConfigSpec)spec));
        if (PackAnalytics.isDedicatedServer()) {
            ServerLifecycleEvents.SERVER_STOPPING.register(mc -> {
                this.sendKeepAliveRequest(true);
                this.stopKeepAliveTask();
            });
        } else {
            ClientLifecycleEvents.CLIENT_STOPPING.register(mc -> {
                this.sendKeepAliveRequest(true);
                this.stopKeepAliveTask();
            });
        }
        this.startKeepAliveTask();
    }

    private void startKeepAliveTask() {
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(() -> this.sendKeepAliveRequest(false), 1L, ((Integer)AllConfigs.common().updateRate.get()).intValue(), TimeUnit.MINUTES);
    }

    private void stopKeepAliveTask() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
            }
        }
    }

    private void sendKeepAliveRequest(boolean disconnect) {
        try {
            String packID = (String)AllConfigs.common().packID.get();
            Object uri = (String)AllConfigs.common().endpoint_url.get();
            if (packID.isEmpty()) {
                LOGGER.error("Null Pack ID! Analytics will not send!");
                return;
            }
            if (((String)uri).isEmpty()) {
                LOGGER.error("Null URL endpoint! Analytics will not send.");
                return;
            }
            String packIDParam = "packID=" + packID;
            if (!((String)uri).endsWith("/")) {
                uri = (String)uri + "/";
            }
            String packVersion = "1.0.0";
            if (PlatformUtils.isModLoaded((String)"bcc")) {
                packVersion = BCCCompat.getBCCVersion();
            }
            if (packVersion.equals("CHANGE_ME")) {
                packVersion = "1.0.0";
            }
            String urlString = (String)uri + (disconnect ? "logoff?" : "keepalive?") + packIDParam + "&server=" + PackAnalytics.isDedicatedServer() + "&version=" + packVersion;
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                LOGGER.warn("Failed to send keepalive request, response code: " + responseCode);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error sending keepalive request: " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isDedicatedServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }
}

