/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lmft.utils;

import io.wispforest.lmft.utils.MethodHandleUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ComponentUtils {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    @Nullable
    private static final Function<String, class_5250> mutableComponentEventFactory = ComponentUtils.findConstructor();
    @Nullable
    private static final BiConsumer<class_5250, class_2561> appendMethodCall = ComponentUtils.createAppendHandle();
    private static final BiConsumer<class_5250, UnaryOperator<class_2583>> styleOperatorMethodCall = ComponentUtils.createStyleOperatorMethod();
    private static final BiConsumer<class_5250, class_124[]> styleMethodCall = ComponentUtils.createStyleMethod();

    private static Function<String, class_5250> findConstructor() {
        MethodHandle constructor;
        MethodHandle staticConstructor = MethodHandleUtils.findStaticMethod(lookup, class_2561.class, MethodType.methodType(class_5250.class, String.class), "literal", "method_43470", "m_237113_");
        if (staticConstructor != null) {
            return s -> (class_5250)MethodHandleUtils.wrapForErrors("createMutableComponentNew", () -> staticConstructor.invoke((String)s));
        }
        Class<?> clazz = MethodHandleUtils.findClass("net.minecraft.network.chat.TextComponent", "net.minecraft.text.LiteralText", "net.minecraft.class_2585", "net.minecraft.src.C_5025_");
        if (clazz != null && (constructor = MethodHandleUtils.findConstructor(lookup, clazz, String.class)) != null) {
            return s -> (class_5250)MethodHandleUtils.wrapForErrors("createMutableComponentOld", () -> constructor.invoke((String)s));
        }
        return null;
    }

    public static boolean canCreateMessages() {
        return mutableComponentEventFactory != null;
    }

    @Nullable
    public static class_5250 createMutableComponent(String text) {
        return mutableComponentEventFactory != null ? mutableComponentEventFactory.apply(text) : null;
    }

    private static BiConsumer<class_5250, class_2561> createAppendHandle() {
        MethodHandle method = MethodHandleUtils.findMethod(lookup, class_5250.class, MethodType.methodType(class_5250.class, class_2561.class), "append", "method_10852", "m_7220_");
        return method != null ? (component, sibling) -> MethodHandleUtils.wrapForErrors("append", () -> method.invoke((class_5250)component, (class_2561)sibling)) : null;
    }

    public static class_5250 append(class_5250 component, class_2561 sibling) {
        if (appendMethodCall != null) {
            appendMethodCall.accept(component, sibling);
        }
        return component;
    }

    private static BiConsumer<class_5250, UnaryOperator<class_2583>> createStyleOperatorMethod() {
        MethodHandle method = MethodHandleUtils.findMethod(lookup, class_5250.class, MethodType.methodType(class_5250.class, UnaryOperator.class), "withStyle", "styled", "method_27694", "m_130938_");
        return method != null ? (component, operator) -> MethodHandleUtils.wrapForErrors("withStyle", () -> method.invoke((class_5250)component, (UnaryOperator)operator)) : null;
    }

    public static class_5250 withStyle(class_5250 component, UnaryOperator<class_2583> style) {
        if (styleOperatorMethodCall != null) {
            styleOperatorMethodCall.accept(component, style);
        }
        return component;
    }

    private static BiConsumer<class_5250, class_124[]> createStyleMethod() {
        MethodHandle method = MethodHandleUtils.findMethod(lookup, class_5250.class, MethodType.methodType(class_5250.class, class_124[].class), "withStyle", "formatted", "method_27695", "m_130944_");
        return method != null ? (component, operator) -> MethodHandleUtils.wrapForErrors("withStyle", () -> method.invoke((class_5250)component, (class_124[])operator)) : null;
    }

    public static class_5250 withStyle(class_5250 component, class_124 ... formats) {
        if (styleMethodCall != null) {
            styleMethodCall.accept(component, formats);
        }
        return component;
    }
}

