/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items.complex;

import java.util.function.Function;
import net.minecraft.class_1304;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1820;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7800;
import org.betterx.bclib.items.BaseArmorItem;
import org.betterx.bclib.items.complex.EquipmentSet;
import org.betterx.bclib.items.complex.EquipmentSlot;
import org.betterx.bclib.items.complex.SmithingSet;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.bclib.recipes.CraftingRecipeBuilder;
import org.betterx.bclib.recipes.SmithingRecipeBuilder;
import org.betterx.bclib.registry.ItemRegistry;
import org.jetbrains.annotations.Nullable;

public class EquipmentDescription<I extends class_1792> {
    private final Function<class_1832, I> creator;
    private I item;
    public final EquipmentSlot slot;

    public EquipmentDescription(EquipmentSlot slot, Function<class_1832, I> creator) {
        this.creator = creator;
        this.slot = slot;
    }

    public void init(class_2960 id, ItemRegistry itemsRegistry, class_1832 material, class_1935 stick, @Nullable EquipmentSet sourceSet) {
        this.item = (class_1792)this.creator.apply(material);
        itemsRegistry.registerTool(id, (class_1792)this.item);
        this.addRecipe(id, (class_1792)this.item, material, stick, sourceSet);
    }

    public void addRecipe(class_2960 id, class_1792 tool, class_1832 material, class_1935 stick, @Nullable EquipmentSet sourceSet) {
        SmithingSet smit;
        if (material == null) {
            return;
        }
        class_1856 repair = material.method_8023();
        if (repair == null) {
            return;
        }
        class_1799[] repairItems = repair.method_8105();
        if (repairItems == null || repairItems.length == 0) {
            return;
        }
        class_1792 ingot = repairItems[0].method_7909();
        if (material instanceof SmithingSet && (smit = (SmithingSet)material).getSmithingTemplateItem() != null && sourceSet != null) {
            SmithingRecipeBuilder builder = (SmithingRecipeBuilder)((SmithingRecipeBuilder)BCLRecipeBuilder.smithing(id, (class_1935)tool).setTemplate((class_1792)smit.getSmithingTemplateItem()).setPrimaryInput(new class_1935[]{sourceSet.getSlot(this.slot)})).setAdditionAndUnlock((class_1935)ingot).setCategory(this.slot.category());
            builder.build();
        } else {
            CraftingRecipeBuilder builder = (CraftingRecipeBuilder)BCLRecipeBuilder.crafting(id, (class_1935)tool).addMaterial('#', new class_1935[]{ingot}).setCategory(class_7800.field_40638);
            if (this.buildRecipe(tool, stick, builder)) {
                return;
            }
            builder.setGroup(id.method_12832()).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean buildRecipe(class_1792 tool, class_1935 stick, CraftingRecipeBuilder builder) {
        if (tool instanceof class_1820) {
            builder.setShape(" #", "# ");
            return false;
        } else if (tool instanceof BaseArmorItem) {
            BaseArmorItem bai = (BaseArmorItem)tool;
            if (bai.method_48398().method_48399() == class_1304.field_6166) {
                builder.setShape("# #", "# #");
                return false;
            } else if (bai.method_48398().method_48399() == class_1304.field_6169) {
                builder.setShape("###", "# #");
                return false;
            } else if (bai.method_48398().method_48399() == class_1304.field_6174) {
                builder.setShape("# #", "###", "###");
                return false;
            } else {
                if (bai.method_48398().method_48399() != class_1304.field_6172) return true;
                builder.setShape("###", "# #", "# #");
            }
            return false;
        } else {
            builder.addMaterial('I', stick);
            if (tool instanceof class_1810) {
                builder.setShape("###", " I ", " I ");
                return false;
            } else if (tool instanceof class_1743) {
                builder.setShape("##", "#I", " I");
                return false;
            } else if (tool instanceof class_1794) {
                builder.setShape("##", " I", " I");
                return false;
            } else if (tool instanceof class_1821) {
                builder.setShape("#", "I", "I");
                return false;
            } else {
                if (!(tool instanceof class_1829)) return true;
                builder.setShape("#", "#", "I");
            }
        }
        return false;
    }

    public I getItem() {
        return this.item;
    }
}

