/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.fluid;

import com.google.common.primitives.Ints;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_3611;

public class BalmFluidStorage
extends SnapshotParticipant<ResourceAmount<FluidVariant>>
implements SingleSlotStorage<FluidVariant> {
    private final FluidTank fluidTank;

    public BalmFluidStorage(FluidTank fluidTank) {
        this.fluidTank = fluidTank;
    }

    public long insert(FluidVariant fluidVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)fluidVariant, (long)maxAmount);
        if (this.getAmount() == 0L) {
            return this.fluidTank.fill(fluidVariant.getFluid(), Ints.saturatedCast((long)maxAmount), false);
        }
        if (fluidVariant.isOf((Object)this.getResource().getFluid())) {
            long amountInserted = Math.min(maxAmount, this.getCapacity() - this.getAmount());
            return this.fluidTank.fill(fluidVariant.getFluid(), Ints.saturatedCast((long)amountInserted), false);
        }
        return 0L;
    }

    public long extract(FluidVariant fluidVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)fluidVariant, (long)maxAmount);
        if (fluidVariant.isOf((Object)this.getResource().getFluid())) {
            long currentLevel = this.getAmount();
            long amountExtracted = Math.min(maxAmount, currentLevel);
            return this.fluidTank.drain(fluidVariant.getFluid(), Ints.saturatedCast((long)amountExtracted), false);
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public FluidVariant getResource() {
        return FluidVariant.of((class_3611)this.fluidTank.getFluid());
    }

    public long getAmount() {
        return this.fluidTank.getAmount();
    }

    public long getCapacity() {
        return this.fluidTank.getCapacity();
    }

    protected ResourceAmount<FluidVariant> createSnapshot() {
        return new ResourceAmount((Object)this.getResource(), this.getAmount());
    }

    protected void readSnapshot(ResourceAmount<FluidVariant> snapshot) {
        this.fluidTank.setFluid(((FluidVariant)snapshot.resource()).getFluid(), Ints.saturatedCast((long)snapshot.amount()));
    }

    public void onFinalCommit() {
        this.fluidTank.setChanged();
    }

    public String toString() {
        return "BalmFluidStorage[" + String.valueOf(this.fluidTank) + "]";
    }
}

