/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.resource;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.resource.MappingResolver;

public class FabricMappingResolver
implements MappingResolver {
    private final Map<String, String> data;

    /*
     * Enabled aggressive exception aggregation
     */
    public static FabricMappingResolver create() {
        try (InputStream is = FabricMappingResolver.class.getResourceAsStream("/mapping.kiwi");){
            FabricMappingResolver fabricMappingResolver;
            try (InputStreamReader isr = new InputStreamReader(Objects.requireNonNull(is));){
                fabricMappingResolver = new FabricMappingResolver((Map)new Gson().fromJson((Reader)isr, Map.class));
            }
            return fabricMappingResolver;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FabricMappingResolver(Map<String, String> data) {
        this.data = data;
    }

    @Override
    public String unmapClass(String clazz) {
        if (Platform.isProduction() && clazz.startsWith("net.minecraft.")) {
            clazz = clazz.substring("net.minecraft.".length());
            return "net.minecraft." + this.data.getOrDefault(clazz, clazz);
        }
        return clazz;
    }
}

