/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.command;

import com.google.common.base.Stopwatch;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.placement.PlaceChoices;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.util.resource.OneTimeLoader;

public class ReloadSlotsCommand {
    public static void register(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"placement_system").executes(ctx -> ReloadSlotsCommand.reload((class_2168)ctx.getSource())));
    }

    private static int reload(class_2168 source) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        OneTimeLoader.Context context = new OneTimeLoader.Context();
        BlockFundamentals fundamentals = BlockFundamentals.reload(CustomizationHooks.collectKiwiPacks(), context, false);
        long parseTime = stopwatch.elapsed().toMillis();
        stopwatch.reset().start();
        int choicesCount = ReloadSlotsCommand.reload(fundamentals);
        long attachTime = stopwatch.elapsed().toMillis();
        Kiwi.LOGGER.info("Parse time %dms + Attach time %dms = %dms".formatted(parseTime, attachTime, parseTime + attachTime));
        source.method_9226(() -> class_2561.method_43470((String)"Slots in %d blocks, %d block states have been reloaded, using %d providers".formatted(PlaceSlot.blockCount(), fundamentals.slotProviders().slots().size(), fundamentals.slotProviders().providers().size())), false);
        source.method_9226(() -> class_2561.method_43470((String)"Place choices in %d blocks have been reloaded, using %d providers".formatted(choicesCount, fundamentals.placeChoices().choices().size())), false);
        return 1;
    }

    public static int reload(BlockFundamentals fundamentals) {
        AtomicInteger choicesCounter = new AtomicInteger();
        class_7923.field_41175.method_40270().forEach(holder -> {
            PlaceChoices.setTo((class_2248)holder.comp_349(), null);
            KBlockDefinition definition = fundamentals.blocks().get(holder.method_40237().method_29177());
            if (definition == null) {
                return;
            }
            fundamentals.slotProviders().attachSlotsA((class_2248)holder.comp_349(), definition);
            if (fundamentals.placeChoices().attachChoicesA((class_2248)holder.comp_349(), definition)) {
                choicesCounter.incrementAndGet();
            }
        });
        fundamentals.slotProviders().attachSlotsB();
        choicesCounter.addAndGet(fundamentals.placeChoices().attachChoicesB());
        fundamentals.slotLinks().finish();
        return choicesCounter.get();
    }
}

