/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.builder.FacingLimitation;
import snownee.kiwi.customization.placement.StatePropertiesPredicate;

public record BlockSpread(Type type, Optional<StatePropertiesPredicate> statePropertiesPredicate, FacingLimitation facingLimitation, int maxDistance) {
    public List<class_2338> collect(class_1838 context, Predicate<class_2248> blockPredicate) {
        return this.collect((class_1922)context.method_8045(), context.method_8037(), Objects.requireNonNull(context.method_8036()), blockPredicate);
    }

    public List<class_2338> collect(class_1922 level, class_2338 origin, class_1657 player, Predicate<class_2248> blockPredicate) {
        class_2680 originalBlock = level.method_8320(origin);
        class_2350 direction = player.method_5735();
        class_2350 originalDirection = class_2350.field_11043;
        try {
            String s = KBlockUtils.getValueString(originalBlock, "facing");
            originalDirection = class_2350.valueOf((String)s.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception s) {
            // empty catch block
        }
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.PLANE_XZ -> {
                List<class_2338> list2;
                List<Object> list = List.of();
                if (this.facingLimitation.test(originalDirection, direction) && (list = this.collectPlaneXZ(level, origin, originalBlock, direction)).size() > 1) {
                    yield list;
                }
                if (this.facingLimitation.test(originalDirection, direction.method_10170()) && (list2 = this.collectPlaneXZ(level, origin, originalBlock, direction.method_10170())).size() > list.size()) {
                    yield list2;
                }
                yield list;
            }
            case Type.PLANE_XYZ -> this.collectPlaneXYZ(level, origin, originalBlock, player);
        };
    }

    private List<class_2338> collectPlaneXYZ(class_1922 level, class_2338 origin, class_2680 originalBlock, class_1657 player) {
        throw new NotImplementedException();
    }

    private List<class_2338> collectPlaneXZ(class_1922 level, class_2338 origin, class_2680 originalBlock, class_2350 direction) {
        ArrayList list = Lists.newArrayList((Object[])new class_2338[]{origin});
        PlacePosIterator iterator = new PlacePosIterator(origin, this.maxDistance, direction);
        while (iterator.hasNext()) {
            class_2338 next = iterator.next();
            class_2680 blockState = level.method_8320(next);
            if (!blockState.method_27852(originalBlock.method_26204()) || this.statePropertiesPredicate.isPresent() && !this.statePropertiesPredicate.get().smartTest(originalBlock, blockState)) continue;
            list.add(next);
            iterator.add(next, null);
        }
        return list;
    }

    public static enum Type {
        PLANE_XZ,
        PLANE_XYZ;

    }

    static class PlacePosIterator
    extends PosIterator {
        final class_2350 direction;

        PlacePosIterator(class_2338 origin, int maxDistance, class_2350 direction) {
            super(origin, maxDistance);
            this.direction = direction;
        }

        @Override
        public Stream<class_2338> listPossibleNext(class_2338 cur, @Nullable class_2338 from) {
            Stream.Builder<class_2338> builder = Stream.builder();
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    class_2338 next;
                    if (i == 0 && j == 0 || (next = cur.method_10079(this.direction, i).method_10079(class_2350.field_11036, j)).equals((Object)from)) continue;
                    builder.accept(next);
                }
            }
            return builder.build();
        }
    }

    static abstract class PosIterator
    implements Iterator<class_2338> {
        final LongSet visited = new LongAVLTreeSet();
        final Queue<class_2338> queue = Lists.newLinkedList();
        final class_2338 origin;
        final int maxDistance;

        PosIterator(class_2338 origin, int maxDistance) {
            this.origin = origin;
            this.maxDistance = maxDistance;
        }

        @Override
        public boolean hasNext() {
            if (this.visited.isEmpty()) {
                this.add(this.origin, null);
            }
            return !this.queue.isEmpty();
        }

        @Override
        public class_2338 next() {
            return this.queue.poll();
        }

        public void add(class_2338 cur, @Nullable class_2338 from) {
            if (this.origin.method_19455((class_2382)cur) > this.maxDistance) {
                return;
            }
            this.visited.add(cur.method_10063());
            this.listPossibleNext(cur, from).filter(pos -> {
                long l = pos.method_10063();
                if (this.visited.contains(l)) {
                    return false;
                }
                this.visited.add(l);
                return true;
            }).forEach(this.queue::add);
        }

        public abstract Stream<class_2338> listPossibleNext(class_2338 var1, @Nullable class_2338 var2);
    }
}

