/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.snowundertrees.world;

import dev.imb11.snowundertrees.config.SnowUnderTreesConfig;
import dev.imb11.snowundertrees.mixins.ThreadedAnvilChunkStorageInvoker;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2493;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class WorldTickHandler
implements ServerTickEvents.StartWorldTick {
    public void onStartTick(class_3218 world) {
        if (!(SnowUnderTreesConfig.get().enableBiomeFeature && SnowUnderTreesConfig.get().enableWhenSnowing && world.method_8419())) {
            return;
        }
        ThreadedAnvilChunkStorageInvoker chunkStorage = (ThreadedAnvilChunkStorageInvoker)world.method_14178().field_17254;
        Iterable<class_3193> chunkHolders = chunkStorage.invokeEntryIterator();
        chunkHolders.forEach(chunkHolder -> this.processChunk(world, (class_3193)chunkHolder));
    }

    private void processChunk(class_3218 world, class_3193 chunkHolder) {
        Optional optionalChunk = chunkHolder.method_14003().getNow(class_3193.field_16427).left();
        if (optionalChunk.isPresent() && this.shouldProcessChunk(world)) {
            class_2338 snowPlacementPos;
            class_2818 chunk = optionalChunk.orElse(null);
            if (chunk == null) {
                return;
            }
            if (!WorldTickHandler.isBiomeSuitable(world, chunk)) {
                return;
            }
            class_2338 randomPos = this.findRandomSurfacePosition(world, chunk);
            if (randomPos != null && this.canPlaceSnow(world, snowPlacementPos = world.method_8598(class_2902.class_2903.field_13203, randomPos))) {
                this.placeSnowLayers(world, snowPlacementPos);
            }
        }
    }

    private boolean shouldProcessChunk(class_3218 world) {
        return world.field_9229.method_43048(4) == 0;
    }

    public static boolean isBiomeSuitable(class_3218 world, class_2818 chunk) {
        class_2338 biomeCheckPos = world.method_8536(chunk.method_12004().method_8326(), 0, chunk.method_12004().method_8328(), 15);
        class_1959 biome = (class_1959)world.method_23753(biomeCheckPos).comp_349();
        class_2960 biomeId = ((class_5321)world.method_30349().method_30530(class_7924.field_41236).method_29113((Object)biome).get()).method_29177();
        boolean isSupported = SnowUnderTreesConfig.get().supportedBiomes.contains(biomeId.toString());
        return isSupported;
    }

    private class_2338 findRandomSurfacePosition(class_3218 world, class_2818 chunk) {
        class_2338 randomPos = world.method_8536(chunk.method_12004().method_8326(), 0, chunk.method_12004().method_8328(), 15);
        if (world.method_8320(world.method_8598(class_2902.class_2903.field_13197, randomPos).method_10074()).method_26204() instanceof class_2397) {
            return randomPos;
        }
        return null;
    }

    private boolean canPlaceSnow(class_3218 world, class_2338 pos) {
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        return biome.method_8696((class_4538)world, pos) && world.method_22347(pos);
    }

    private void placeSnowLayers(class_3218 world, class_2338 pos) {
        world.method_8501(pos, class_2246.field_10477.method_9564());
        class_2338 belowPos = pos.method_10074();
        class_2680 belowState = world.method_8320(belowPos);
        if (belowState.method_26206((class_1922)world, belowPos, class_2350.field_11036) && belowState.method_28498((class_2769)class_2493.field_11522)) {
            world.method_8652(belowPos, (class_2680)belowState.method_11657((class_2769)class_2493.field_11522, (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

