/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.dawn.block;

import fr.hugman.dawn.block.CauldronUtil;
import java.util.function.Predicate;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.class_5620;
import net.minecraft.class_5712;

public class CauldronInteractionBuilder {
    private Predicate<class_2680> predicate;
    private class_1799 stack;
    private class_2248 cauldron;
    private int level;
    private boolean overwriteLevel;
    private class_3414 sound;

    private CauldronInteractionBuilder(Predicate<class_2680> predicate, class_1799 stack, class_2248 cauldron, int level, boolean overwriteLevel, class_3414 sound) {
        this.predicate = predicate;
        this.stack = stack;
        this.cauldron = cauldron;
        this.level = level;
        this.overwriteLevel = overwriteLevel;
        this.sound = sound;
    }

    public static CauldronInteractionBuilder create() {
        return new CauldronInteractionBuilder(state -> true, null, null, 0, false, null);
    }

    public CauldronInteractionBuilder test(Predicate<class_2680> predicate) {
        this.predicate = predicate;
        return this;
    }

    public CauldronInteractionBuilder testLevel(Predicate<Integer> predicate) {
        return this.test(state -> predicate.test(CauldronUtil.getLevel(state)));
    }

    public CauldronInteractionBuilder stack(class_1799 newStack) {
        this.stack = newStack;
        return this;
    }

    public CauldronInteractionBuilder item(class_1792 item) {
        this.stack = item.method_7854();
        return this;
    }

    public CauldronInteractionBuilder cauldron(class_2248 cauldron) {
        this.cauldron = cauldron;
        return this;
    }

    public CauldronInteractionBuilder sameCauldron() {
        return this.cauldron(null);
    }

    public CauldronInteractionBuilder addLevel(int level) {
        this.level = level;
        this.overwriteLevel = false;
        if (level > 0) {
            return this.test(CauldronUtil::isNotFull);
        }
        if (level < 0) {
            return this.testLevel(i -> i >= level * -1);
        }
        return this;
    }

    public CauldronInteractionBuilder setLevel(int level) {
        this.level = level;
        this.overwriteLevel = true;
        return this;
    }

    public CauldronInteractionBuilder sound(class_3414 sound) {
        this.sound = sound;
        return this;
    }

    public class_5620 build() {
        return (state, world, pos, player, hand, stack) -> {
            if (this.predicate.test(state)) {
                int newLevel;
                if (this.cauldron == null) {
                    this.cauldron = state.method_26204();
                }
                int n = newLevel = !this.overwriteLevel ? CauldronUtil.getLevel(state) + this.level : this.level;
                if (!world.field_9236) {
                    class_2680 returnedState = CauldronUtil.modifyCauldron(state, this.cauldron, newLevel);
                    player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)this.stack.method_7972()));
                    player.method_7281(CauldronUtil.isFull(returnedState) ? class_3468.field_15430 : class_3468.field_15373);
                    player.method_7259(class_3468.field_15372.method_14956((Object)this.stack.method_7909()));
                    world.method_8501(pos, returnedState);
                    world.method_33596(null, newLevel < 0 ? class_5712.field_28167 : class_5712.field_28166, pos);
                    if (this.sound != null) {
                        world.method_8396(null, pos, this.sound, class_3419.field_15245, 1.0f, 1.0f);
                    }
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
            return class_1269.field_5811;
        };
    }

    public CauldronInteractionBuilder copy() {
        return new CauldronInteractionBuilder(this.predicate, this.stack, this.cauldron, this.level, this.overwriteLevel, this.sound);
    }
}

