/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.xpstorage;

import com.github.charlyb01.xpstorage.BookInfo;
import com.github.charlyb01.xpstorage.Utils;
import com.github.charlyb01.xpstorage.cardinal.ExperienceComponent;
import com.github.charlyb01.xpstorage.cardinal.MyComponents;
import com.github.charlyb01.xpstorage.config.ModConfig;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class XpBook
extends class_1792
implements BookInfo {
    private final int maxLevel;
    private final int maxExperience;
    private final int xpFromUsing;
    private final int colorBar;

    public XpBook(int maxLevel, int xpFromUsing, int colorBar, boolean isFireproof, class_1814 rarity) {
        super(isFireproof ? new class_1792.class_1793().method_7889(1).method_7894(rarity).method_24359() : new class_1792.class_1793().method_7889(1).method_7894(rarity));
        this.maxLevel = maxLevel;
        this.maxExperience = Utils.getExperienceToLevel(maxLevel);
        this.xpFromUsing = xpFromUsing;
        this.colorBar = colorBar;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int bookLevel = ((ExperienceComponent)MyComponents.XP_COMPONENT.get((Object)stack)).getLevel();
        tooltip.add((class_2561)class_2561.method_43469((String)"item.xp_storage.xp_books.tooltip", (Object[])new Object[]{bookLevel, this.maxLevel}).method_27692(class_124.field_1080));
        if (ModConfig.get().cosmetic.bookTooltip) {
            int bookExperience = ((ExperienceComponent)MyComponents.XP_COMPONENT.get((Object)stack)).getAmount();
            tooltip.add((class_2561)class_2561.method_43469((String)"item.xp_storage.xp_books.advanced_tooltip", (Object[])new Object[]{bookExperience, this.maxExperience}).method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        }
    }

    public boolean method_7886(class_1799 stack) {
        int bookExperience = ((ExperienceComponent)MyComponents.XP_COMPONENT.get((Object)stack)).getAmount();
        return (float)bookExperience / (float)this.maxExperience * 100.0f >= (float)ModConfig.get().cosmetic.glint;
    }

    public int method_31571(class_1799 stack) {
        return this.colorBar;
    }

    public int method_31569(class_1799 stack) {
        int bookExperience = ((ExperienceComponent)MyComponents.XP_COMPONENT.get((Object)stack)).getAmount();
        return Math.round((float)(bookExperience * 13) / (float)this.maxExperience);
    }

    public boolean method_31567(class_1799 stack) {
        return ((ExperienceComponent)MyComponents.XP_COMPONENT.get((Object)stack)).getAmount() > 0;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_6047().method_7909() instanceof XpBook ? user.method_6047() : user.method_6079();
        int bookExperience = ((ExperienceComponent)MyComponents.XP_COMPONENT.get((Object)stack)).getAmount();
        int playerExperience = Utils.getPlayerExperience(user);
        if (world.field_9236) {
            if (!user.method_5715() && playerExperience > 0 && bookExperience < this.maxExperience) {
                user.method_5783(class_3417.field_14627, 1.0f, 1.0f);
            }
        } else if (user.method_5715()) {
            int retrievedExperience = Math.round((float)bookExperience * ((float)this.xpFromUsing / 100.0f));
            class_1303.method_31493((class_3218)((class_3218)world), (class_243)user.method_19538(), (int)retrievedExperience);
            ((ExperienceComponent)MyComponents.XP_COMPONENT.get((Object)stack)).setAmount(0);
        } else if (this.maxExperience - bookExperience < playerExperience) {
            user.method_7255(bookExperience - this.maxExperience);
            ((ExperienceComponent)MyComponents.XP_COMPONENT.get((Object)stack)).setAmount(this.maxExperience);
        } else {
            ((ExperienceComponent)MyComponents.XP_COMPONENT.get((Object)stack)).setAmount(bookExperience + playerExperience);
            user.method_7255(-playerExperience);
        }
        return new class_1271(class_1269.field_5812, (Object)user.method_5998(hand));
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public int getMaxExperience() {
        return this.maxExperience;
    }

    @Override
    public int getXpFromUsing() {
        return this.xpFromUsing;
    }

    @Override
    public int getColorBar() {
        return this.colorBar;
    }
}

