/*
 * Decompiled with CFR 0.152.
 */
package toni.cerulean.mixin;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2066;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toni.cerulean.Common;
import toni.cerulean.iface.IItemStackMixin;
import toni.cerulean.impl.StackSizeThresholdManager;
import toni.cerulean.util.LogHelper;

@Mixin(value={class_2066.class})
abstract class InventoryChangeTriggerMixin {
    @Unique
    private Map<UUID, Map<String, Integer>> cerulean$skipTicks = new HashMap<UUID, Map<String, Integer>>();

    InventoryChangeTriggerMixin() {
    }

    @Inject(method={"trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void trigger(class_3222 serverPlayer, class_1661 inventory, class_1799 itemStack, CallbackInfo ci) {
        Map skipTickMap = this.cerulean$skipTicks.computeIfAbsent(serverPlayer.method_5667(), k -> new HashMap());
        if (Common.config.ENABLE_SKIP_TICKS) {
            String itemName = itemStack.method_7909().toString();
            Integer skipTicks = skipTickMap.getOrDefault(itemName, 5);
            if (skipTicks < 4) {
                Integer n = skipTicks;
                skipTicks = skipTicks + 1;
                skipTickMap.put(itemName, skipTicks);
                ci.cancel();
                return;
            }
            skipTickMap.put(itemName, 0);
        }
        if (itemStack.method_7960() && Common.config.IGNORE_TRIGGERS_FOR_EMPTIED_STACKS || Common.config.IGNORE_TRIGGERS_FOR_DECREASED_STACKS && itemStack.method_7947() < ((IItemStackMixin)itemStack).cerulean$getPreviousStackSize() || Common.config.OPTIMIZE_TRIGGERS_FOR_INCREASED_STACKS && !StackSizeThresholdManager.doesStackPassThreshold(itemStack)) {
            ci.cancel();
            LogHelper.debug(() -> "InventoryChangeTrigger cancelled for %s".formatted(itemStack));
        } else {
            LogHelper.debug(() -> "InventoryChangeTrigger passed for %s".formatted(itemStack));
        }
    }
}

