/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion;

import fuzs.illagerinvasion.config.RaidWavesConfigHelper;
import fuzs.illagerinvasion.config.ServerConfig;
import fuzs.illagerinvasion.core.CommonAbstractions;
import fuzs.illagerinvasion.handler.PlatinumTrimHandler;
import fuzs.illagerinvasion.handler.VillagerGoalHandler;
import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerEvents;
import fuzs.puzzleslib.api.event.v1.level.BlockEvents;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadEvents;
import fuzs.puzzleslib.api.init.v2.PotionBrewingRegistry;
import fuzs.puzzleslib.api.init.v2.RegistryReference;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3732;
import net.minecraft.class_3763;
import net.minecraft.class_44;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6880;
import net.minecraft.class_79;
import net.minecraft.class_83;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IllagerInvasion
implements ModConstructor {
    public static final String MOD_ID = "illagerinvasion";
    public static final String MOD_NAME = "Illager Invasion";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Illager Invasion");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"illagerinvasion").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        IllagerInvasion.registerHandlers();
    }

    private static void registerHandlers() {
        PlayerEvents.BREAK_SPEED.register(PlatinumTrimHandler::onBreakSpeed);
        LivingExperienceDropCallback.EVENT.register(PlatinumTrimHandler::onLivingExperienceDrop);
        BlockEvents.FARMLAND_TRAMPLE.register(PlatinumTrimHandler::onFarmlandTrample);
        ServerEntityLevelEvents.LOAD.register(VillagerGoalHandler::onEntityJoinServerLevel);
        LootTableLoadEvents.MODIFY.register((lootManager, identifier, addPool, removePool) -> {
            IllagerInvasion.injectLootPool(identifier, addPool, class_1299.field_6065.method_16351(), ModRegistry.ILLUSIONER_INJECT_LOOT_TABLE);
            IllagerInvasion.injectLootPool(identifier, addPool, class_1299.field_6105.method_16351(), ModRegistry.PILLAGER_INJECT_LOOT_TABLE);
            IllagerInvasion.injectLootPool(identifier, addPool, class_1299.field_6134.method_16351(), ModRegistry.RAVAGER_INJECT_LOOT_TABLE);
        });
    }

    private static void injectLootPool(class_2960 identifier, Consumer<class_55> addPool, class_2960 builtInLootTable, class_2960 injectedLootTable) {
        if (identifier.equals((Object)builtInLootTable)) {
            addPool.accept(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_83.method_428((class_2960)injectedLootTable)).method_355());
        }
    }

    public void onCommonSetup() {
        IllagerInvasion.registerRaiderTypes();
        IllagerInvasion.registerPotionRecipes();
        VillagerGoalHandler.init();
    }

    private static void registerRaiderTypes() {
        IllagerInvasion.registerRaiderType(ModRegistry.BASHER_ENTITY_TYPE, RaidWavesConfigHelper.BASHER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.PROVOKER_ENTITY_TYPE, RaidWavesConfigHelper.PROVOKER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.NECROMANCER_ENTITY_TYPE, RaidWavesConfigHelper.NECROMANCER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.SORCERER_ENTITY_TYPE, RaidWavesConfigHelper.SORCERER_RAID_WAVES);
        IllagerInvasion.registerRaiderType((class_6880.class_6883<? extends class_1299<? extends class_3763>>)class_1299.field_6065.method_40124(), RaidWavesConfigHelper.ILLUSIONER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.ARCHIVIST_ENTITY_TYPE, RaidWavesConfigHelper.ARCHIVIST_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.MARAUDER_ENTITY_TYPE, RaidWavesConfigHelper.MARAUDER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.INQUISITOR_ENTITY_TYPE, RaidWavesConfigHelper.INQUISITOR_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.ALCHEMIST_ENTITY_TYPE, RaidWavesConfigHelper.ALCHEMIST_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModRegistry.INVOKER_ENTITY_TYPE, RaidWavesConfigHelper.INVOKER_RAID_WAVES);
    }

    private static void registerRaiderType(class_6880.class_6883<? extends class_1299<? extends class_3763>> holder, int[] spawnsPerWaveBeforeBonus) {
        IllagerInvasion.registerRaiderType((class_5321<? extends class_1299<? extends class_3763>>)holder.method_40237(), (class_1299<? extends class_3763>)((class_1299)holder.comp_349()), spawnsPerWaveBeforeBonus);
    }

    private static void registerRaiderType(RegistryReference<? extends class_1299<? extends class_3763>> registryReference, int[] spawnsPerWaveBeforeBonus) {
        IllagerInvasion.registerRaiderType((class_5321<? extends class_1299<? extends class_3763>>)registryReference.getResourceKey(), (class_1299<? extends class_3763>)((class_1299)registryReference.get()), spawnsPerWaveBeforeBonus);
    }

    private static void registerRaiderType(class_5321<? extends class_1299<? extends class_3763>> resourceKey, class_1299<? extends class_3763> entityType, int[] spawnsPerWaveBeforeBonus) {
        CommonAbstractions.INSTANCE.registerRaiderType(resourceKey.method_29177().method_36181().toUpperCase(Locale.ROOT), entityType, spawnsPerWaveBeforeBonus);
    }

    private static void registerPotionRecipes() {
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(class_1847.field_8999, class_1802.field_39057, (class_1842)ModRegistry.BERSERKING_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((class_1842)ModRegistry.BERSERKING_POTION.get(), class_1802.field_8725, (class_1842)ModRegistry.LONG_BERSERKING_POTION.get());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe((class_1842)ModRegistry.BERSERKING_POTION.get(), class_1802.field_8601, (class_1842)ModRegistry.STRONG_BERSERKING_POTION.get());
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((class_1299)ModRegistry.ALCHEMIST_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.38));
        context.registerEntityAttributes((class_1299)ModRegistry.ARCHIVIST_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.36));
        context.registerEntityAttributes((class_1299)ModRegistry.BASHER_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.31).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23722, 0.2));
        context.registerEntityAttributes((class_1299)ModRegistry.FIRECALLER_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.38));
        context.registerEntityAttributes((class_1299)ModRegistry.INQUISITOR_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23719, 0.33).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23722, 1.6).method_26868(class_5134.field_23718, 0.8));
        context.registerEntityAttributes((class_1299)ModRegistry.INVOKER_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 250.0).method_26868(class_5134.field_23719, 0.36).method_26868(class_5134.field_23718, 0.3).method_26868(class_5134.field_23721, 8.0));
        context.registerEntityAttributes((class_1299)ModRegistry.MARAUDER_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.3));
        context.registerEntityAttributes((class_1299)ModRegistry.PROVOKER_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.38));
        context.registerEntityAttributes((class_1299)ModRegistry.SORCERER_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.38));
        context.registerEntityAttributes((class_1299)ModRegistry.SURRENDERED_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 14.0).method_26868(class_5134.field_23721, 5.0));
        context.registerEntityAttributes((class_1299)ModRegistry.NECROMANCER_ENTITY_TYPE.get(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.38));
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((class_1299)ModRegistry.ALCHEMIST_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModRegistry.ARCHIVIST_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModRegistry.BASHER_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModRegistry.FIRECALLER_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModRegistry.INQUISITOR_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModRegistry.INVOKER_ENTITY_TYPE.get(), class_1317.class_1319.field_19350, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModRegistry.MARAUDER_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModRegistry.PROVOKER_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModRegistry.SORCERER_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModRegistry.SURRENDERED_ENTITY_TYPE.get(), class_1317.class_1319.field_19350, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModRegistry.NECROMANCER_ENTITY_TYPE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> new class_1799((class_1935)ModRegistry.HORN_OF_SIGHT_ITEM.get())).displayItems((itemDisplayParameters, output) -> {
            output.method_45421((class_1935)ModRegistry.IMBUIING_TABLE_ITEM.get());
            output.method_45421((class_1935)ModRegistry.UNUSUAL_DUST_ITEM.get());
            output.method_45421((class_1935)ModRegistry.ILLUSIONARY_DUST_ITEM.get());
            output.method_45421((class_1935)ModRegistry.HALLOWED_GEM_ITEM.get());
            output.method_45421((class_1935)ModRegistry.PRIMAL_ESSENCE_ITEM.get());
            output.method_45421((class_1935)ModRegistry.PLATINUM_CHUNK_ITEM.get());
            output.method_45421((class_1935)ModRegistry.PLATINUM_SHEET_ITEM.get());
            output.method_45421((class_1935)ModRegistry.PLATINUM_INFUSED_HATCHET_ITEM.get());
            output.method_45421((class_1935)ModRegistry.HORN_OF_SIGHT_ITEM.get());
            output.method_45421((class_1935)ModRegistry.LOST_CANDLE_ITEM.get());
            output.method_45421((class_1935)ModRegistry.MAGICAL_FIRE_CHARGE_ITEM.get());
            output.method_45421((class_1935)ModRegistry.PROVOKER_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.BASHER_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.SORCERER_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.ARCHIVIST_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.INQUISITOR_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.MARAUDER_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.INVOKER_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.ALCHEMIST_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.FIRECALLER_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.NECROMANCER_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.SURRENDERED_SPAWN_EGG_ITEM.get());
            output.method_45421((class_1935)ModRegistry.ILLUSIONER_SPAWN_EGG_ITEM.get());
        }));
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }
}

