/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.config.ServerClassPolicy;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.network.handler.PayloadHandler;
import dev.terminalmc.clientsort.network.handler.validate.PolicyManager;
import dev.terminalmc.clientsort.network.handler.validate.SchemaValidator;
import dev.terminalmc.clientsort.network.payload.SortPayload;
import dev.terminalmc.clientsort.network.payload.SortResultPayload;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.TreeMap;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SortHandler
extends PayloadHandler {
    private SortHandler() {
    }

    public static void handle(SortPayload payload, MinecraftServer server, class_3222 player) {
        server.execute(() -> SortHandler.processPayload(server, player, payload.containerId(), menu -> SortHandler.checkPolicy(player, menu, payload.slotMapping()), menu -> SchemaValidator.validateSlotMapping(player, menu, payload.slotMapping()), menu -> SortHandler.sort(server, menu, payload.slotMapping()), SortPayload.ID, SortResultPayload.ID, (result, message) -> new SortResultPayload(result.code, (String)message)));
    }

    private static void sort(MinecraftServer server, class_1703 menu, int[] slotMapping) throws PayloadHandlerException {
        TreeMap<Integer, class_1799> stacks = new TreeMap<Integer, class_1799>();
        for (class_1735 slot : menu.field_7761) {
            stacks.put(((ISlot)slot).clientsort$getIndexInMenu(), slot.method_7677().method_7972());
        }
        for (int i = 0; i < slotMapping.length - 1; i += 2) {
            int srcSlotId = slotMapping[i];
            int dstSlotId = slotMapping[i + 1];
            class_1735 dstSlot = (class_1735)menu.field_7761.get(dstSlotId);
            if (srcSlotId == dstSlotId) continue;
            dstSlot.method_48931((class_1799)stacks.get(srcSlotId));
            try {
                int finalSrcSlotId = srcSlotId;
                int finalDstSlotId = dstSlotId;
                SortHandler.validate(server, (class_1799)stacks.get(srcSlotId), dstSlot.method_7677(), () -> String.format("Sort operation failed at slot mapping %d->%d", finalSrcSlotId, finalDstSlotId), msg -> SortHandler.setPolicy(menu, slotMapping, msg));
                continue;
            }
            catch (PayloadHandlerException.InconsistentStateException e) {
                for (int j = 0; j <= i; j += 2) {
                    srcSlotId = slotMapping[j];
                    ((class_1735)menu.field_7761.get(srcSlotId)).method_7673((class_1799)stacks.get(srcSlotId));
                    dstSlotId = slotMapping[j + 1];
                    ((class_1735)menu.field_7761.get(dstSlotId)).method_7673((class_1799)stacks.get(dstSlotId));
                }
                throw e;
            }
        }
    }

    private static void checkPolicy(class_3222 player, class_1703 menu, int[] slotIds) throws PayloadHandlerException.UnsupportedOpException {
        class_1263 container = slotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)slotIds[0])).field_7871 : null;
        Object object = ClientSort.getObj(container, menu);
        if (object == null) {
            throw new PayloadHandlerException.UnsupportedOpException("Reference object is null for inputs '%s', '%s'!".formatted(container == null ? "null" : container.getClass().getName(), menu == null ? "null" : menu.getClass().getName()));
        }
        if (container != player.method_31548()) {
            PolicyManager.checkPolicy(object.getClass(), bl -> bl.sortEnabled);
        }
    }

    private static void setPolicy(class_1703 menu, int[] slotIds, String message) {
        class_1263 container = slotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)slotIds[0])).field_7871 : null;
        Object object = ClientSort.getObj(container, menu);
        if (object == null) {
            ClientSort.LOG.warn("Could not set policy: reference object is null for inputs '{}', '{}'!", container == null ? "null" : container.getClass().getName(), menu == null ? "null" : menu.getClass().getName());
            return;
        }
        PolicyManager.setPolicy(new ServerClassPolicy(object.getClass().getName(), false, true, true), SortPayload.ID.toString(), message);
    }
}

