/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ModFingerprinter {
    public static IdentificationResult identify(Path path) throws IOException {
        MessageDigest sha1Digest;
        int normalizedLength = 0;
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = ((InputStream)stream).read(buffer)) != -1) {
                for (int i = 0; i < read; ++i) {
                    if (ModFingerprinter.isWhitespace(buffer[i])) continue;
                    ++normalizedLength;
                }
            }
        }
        try {
            sha1Digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1 algorithm not found in JVM", e);
        }
        long murmurValue = ModFingerprinter.computeMurmur2AndSha1Streamed(path, normalizedLength, sha1Digest);
        String sha1Hex = ModFingerprinter.bytesToHex(sha1Digest.digest());
        return new IdentificationResult(murmurValue, sha1Hex);
    }

    private static boolean isWhitespace(byte b) {
        return b == 9 || b == 10 || b == 13 || b == 32;
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static long computeMurmur2AndSha1Streamed(Path path, int length, MessageDigest sha1Digest) throws IOException {
        block12: {
            m = 1540483477;
            r = 24;
            seed = 1;
            h = seed ^ length;
            stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            try {
                buffer = new byte[8192];
                chunkBuffer = new byte[4];
                chunkIndex = 0;
                while ((read = stream.read(buffer)) != -1) {
                    sha1Digest.update(buffer, 0, read);
                    for (i = 0; i < read; ++i) {
                        b = buffer[i];
                        if (ModFingerprinter.isWhitespace(b)) continue;
                        chunkBuffer[chunkIndex++] = b;
                        if (chunkIndex != 4) continue;
                        k = chunkBuffer[0] & 255 | (chunkBuffer[1] & 255) << 8 | (chunkBuffer[2] & 255) << 16 | (chunkBuffer[3] & 255) << 24;
                        k *= 1540483477;
                        k ^= k >>> 24;
                        h *= 1540483477;
                        h ^= (k *= 1540483477);
                        chunkIndex = 0;
                    }
                }
                if (chunkIndex <= 0) break block12;
                switch (chunkIndex) {
                    case 3: {
                        h ^= (chunkBuffer[2] & 255) << 16;
                    }
                    case 2: {
                        h ^= (chunkBuffer[1] & 255) << 8;
                    }
                    case 1: {
                        h ^= chunkBuffer[0] & 255;
                        h *= 1540483477;
                        break;
                    }
                    ** default:
lbl36:
                    // 1 sources

                    break;
                }
            }
            finally {
                stream.close();
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return (long)h & 0xFFFFFFFFL;
    }

    public static class IdentificationResult {
        private final long curseForgeHash;
        private final String modrinthHash;

        public IdentificationResult(long curseForgeHash, String modrinthHash) {
            this.curseForgeHash = curseForgeHash;
            this.modrinthHash = modrinthHash;
        }

        public long getCurseForgeHash() {
            return this.curseForgeHash;
        }

        public String getModrinthHash() {
            return this.modrinthHash;
        }

        public String toString() {
            return String.format("Result[CF=%d, MR=%s]", this.curseForgeHash, this.modrinthHash);
        }
    }
}

