/*
 * Decompiled with CFR 0.152.
 */
package toni.foolproof;

import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.IConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toni.foolproof.ClientEvents;
import toni.foolproof.features.VoidGraveReminder;
import toni.foolproof.foundation.FoolproofPersistentData;
import toni.foolproof.foundation.config.AllConfigs;

public class Foolproof
implements ModInitializer,
ClientModInitializer {
    public static final String MODNAME = "Foolproof";
    public static final String ID = "foolproof";
    public static final Logger LOGGER = LogManager.getLogger((String)"Foolproof");
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final AtomicLong serverStartTime = new AtomicLong(0L);
    public static FoolproofPersistentData DATA;

    public static boolean hasSeenWarning(String warning) {
        return Foolproof.DATA.seenWarnings.contains(warning);
    }

    public void onInitialize() {
        AllConfigs.register((type, spec) -> ForgeConfigRegistry.INSTANCE.register(ID, type, (IConfigSpec)spec));
        VoidGraveReminder.init();
    }

    public void onInitializeClient() {
        DATA = FoolproofPersistentData.load();
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (DATA != null) {
                DATA.save();
            }
        });
        ClientEvents.init();
    }

    private void onServerStarted(MinecraftServer server) {
        serverStartTime.set(System.currentTimeMillis());
        scheduler.schedule(() -> System.out.println("[SERVER] The server is fully started and ready to join!"), 5L, TimeUnit.SECONDS);
    }
}

