/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.task;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.task.IServerSpreadoutQueuedTask;
import xaero.pac.common.server.task.ServerSpreadoutTaskHandler;

public final class ServerSpreadoutQueuedTaskHandler<T extends IServerSpreadoutQueuedTask<T>>
extends ServerSpreadoutTaskHandler<T, T> {
    private final Deque<T> taskQueue;

    private ServerSpreadoutQueuedTaskHandler(Deque<T> tasks, Function<T, T> holderToTask, int perTickLimit, int perTickPerTaskLimit) {
        super(holderToTask, perTickLimit, perTickPerTaskLimit);
        this.taskQueue = tasks;
    }

    public boolean addTask(T task, IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        if (this.taskQueue.add(task)) {
            task.onQueued(serverData);
            return true;
        }
        return false;
    }

    @Override
    protected Iterator<T> getTaskHolderIterator(IServerData<?, ?> serverData) {
        return this.taskQueue.iterator();
    }

    @Override
    protected void handleTasksToAdd(List<T> tasksToAdd) {
        this.taskQueue.addAll(tasksToAdd);
    }

    public static final class Builder<T extends IServerSpreadoutQueuedTask<T>>
    extends ServerSpreadoutTaskHandler.Builder<T, T, Builder<T>> {
        private Builder() {
        }

        @Override
        public Builder<T> setDefault() {
            super.setDefault();
            return (Builder)this.self;
        }

        @Override
        public Builder<T> setHolderToTask(Function<T, T> holderToTask) {
            if (holderToTask != null) {
                throw new RuntimeException(new IllegalAccessException());
            }
            return (Builder)super.setHolderToTask(holderToTask);
        }

        public ServerSpreadoutQueuedTaskHandler<T> build() {
            this.holderToTask = Function.identity();
            return (ServerSpreadoutQueuedTaskHandler)super.build();
        }

        @Override
        protected ServerSpreadoutTaskHandler<T, T> buildInternally() {
            return new ServerSpreadoutQueuedTaskHandler(new LinkedList(), this.holderToTask, this.perTickLimit, this.perTickPerTaskLimit);
        }

        public static <T extends IServerSpreadoutQueuedTask<T>> Builder<T> begin() {
            return new Builder<T>().setDefault();
        }
    }
}

