/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.system.impl;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamRank;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xaero.pac.common.server.parties.system.api.IPlayerPartySystemAPI;

public class PlayerFTBPartySystem
implements IPlayerPartySystemAPI<Team> {
    @Override
    @Nullable
    public Team getPartyByOwner(@Nonnull UUID playerId) {
        Team team = FTBTeamsAPI.api().getManager().getTeamForPlayerID(playerId).orElse(null);
        if (team == null) {
            return null;
        }
        if (team.getOwner().equals(playerId)) {
            return team;
        }
        return null;
    }

    @Override
    @Nullable
    public Team getPartyByMember(@Nonnull UUID playerId) {
        return FTBTeamsAPI.api().getManager().getTeamForPlayerID(playerId).orElse(null);
    }

    @Override
    public boolean isPlayerAllying(@Nonnull UUID playerId, @Nonnull UUID potentialAllyPlayerId) {
        Team playerTeam = this.getPartyByMember(playerId);
        if (playerTeam == null) {
            return false;
        }
        Team potentialAllyPlayerTeam = this.getPartyByMember(potentialAllyPlayerId);
        return playerTeam != potentialAllyPlayerTeam && playerTeam.getRankForPlayer(potentialAllyPlayerId) == TeamRank.ALLY;
    }

    @Override
    public boolean isPermittedToPartyClaim(@Nonnull UUID playerId) {
        Team playerTeam = this.getPartyByMember(playerId);
        return playerTeam != null && playerTeam.getRankForPlayer(playerId).isOfficerOrBetter();
    }
}

