/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.sync.player;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_3222;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.claims.ClientboundClaimOwnerPropertiesPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfo;
import xaero.pac.common.server.claims.sync.ClaimsManagerSynchronizer;
import xaero.pac.common.server.claims.sync.player.ClaimsManagerPlayerLazyPacketScheduler;
import xaero.pac.common.server.parties.party.IServerParty;

public final class ClaimsManagerPlayerClaimOwnerPropertiesSync
extends ClaimsManagerPlayerLazyPacketScheduler {
    private Iterator<ServerPlayerClaimInfo> toSync;

    private ClaimsManagerPlayerClaimOwnerPropertiesSync(Iterator<ServerPlayerClaimInfo> toSync, ClaimsManagerSynchronizer synchronizer) {
        super(synchronizer);
        this.toSync = toSync;
    }

    @Override
    public void onTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_3222 player, int limit) {
        ArrayList<ClientboundClaimOwnerPropertiesPacket.PlayerProperties> packetBuilder = new ArrayList<ClientboundClaimOwnerPropertiesPacket.PlayerProperties>(32);
        for (int canSync = limit; canSync > 0 && this.toSync.hasNext(); --canSync) {
            this.buildClaimPropertiesPacket(packetBuilder, this.toSync.next(), player);
        }
        if (!packetBuilder.isEmpty()) {
            this.synchronizer.syncClaimOwnerProperties(packetBuilder, player);
        }
    }

    private void buildClaimPropertiesPacket(List<ClientboundClaimOwnerPropertiesPacket.PlayerProperties> packetBuilder, ServerPlayerClaimInfo pi, class_3222 player) {
        UUID playerId = pi.getPlayerId();
        String username = pi.getPlayerUsername();
        packetBuilder.add(new ClientboundClaimOwnerPropertiesPacket.PlayerProperties(playerId, username));
        if (packetBuilder.size() == 32) {
            this.synchronizer.syncClaimOwnerProperties(packetBuilder, player);
            packetBuilder.clear();
        }
    }

    @Override
    public void onLazyPacketsDropped() {
        this.toSync = null;
    }

    public boolean isFinished() {
        return this.toSync == null || !this.toSync.hasNext();
    }

    @Override
    public boolean shouldWorkNotClogged(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_3222 player) {
        return this.started && !this.isFinished();
    }

    public static final class Builder {
        private ClaimsManagerSynchronizer synchronizer;
        private class_3222 player;

        private Builder() {
        }

        public Builder setDefault() {
            this.setSynchronizer(null);
            this.setPlayer(null);
            return this;
        }

        public Builder setSynchronizer(ClaimsManagerSynchronizer synchronizer) {
            this.synchronizer = synchronizer;
            return this;
        }

        public Builder setPlayer(class_3222 player) {
            this.player = player;
            return this;
        }

        public ClaimsManagerPlayerClaimOwnerPropertiesSync build() {
            if (this.synchronizer == null || this.player == null) {
                throw new IllegalStateException();
            }
            Iterator<ServerPlayerClaimInfo> toSync = this.synchronizer.getClaimPropertiesToSync(this.player);
            return new ClaimsManagerPlayerClaimOwnerPropertiesSync(toSync, this.synchronizer);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

