/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.network;

import com.blackgear.platform.core.network.PacketRegistry;
import com.blackgear.platform.core.network.base.NetworkDirection;
import com.blackgear.platform.core.network.base.Packet;
import com.blackgear.platform.core.network.base.PacketHandler;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.server.MinecraftServer;

public class NetworkChannel {
    private final class_2960 channel;

    public NetworkChannel(String modId, int version, String channel) {
        this.channel = new class_2960(modId, channel);
        PacketRegistry.registerChannel(this.channel, version);
    }

    public <T extends Packet<T>> void registerPacket(NetworkDirection direction, class_2960 id, PacketHandler<T> handler, Class<T> packet) {
        if (direction == NetworkDirection.TO_SERVER) {
            PacketRegistry.registerServerbound(this.channel, id, handler, packet);
        } else {
            PacketRegistry.registerClientbound(this.channel, id, handler, packet);
        }
    }

    public <T extends Packet<T>> void sendToServer(T packet) {
        PacketRegistry.sendToServer(this.channel, packet);
    }

    public <T extends Packet<T>> void sendToPlayer(T packet, class_1657 player) {
        PacketRegistry.sendToPlayer(this.channel, packet, player);
    }

    public <T extends Packet<T>> void sendToPlayers(T packet, Collection<? extends class_1657> players) {
        players.forEach(player -> this.sendToPlayer(packet, (class_1657)player));
    }

    public <T extends Packet<T>> void sendToAllPlayers(T packet, MinecraftServer server) {
        this.sendToPlayers(packet, server.method_3760().method_14571());
    }

    public <T extends Packet<T>> void sendToPlayersInLevel(T packet, class_1937 level) {
        this.sendToPlayers(packet, level.method_18456());
    }

    public <T extends Packet<T>> void sendToAllLoadedPlayers(T packet, class_1937 level, class_2338 pos) {
        class_2818 chunk = level.method_8500(pos);
        class_2802 class_28022 = level.method_8398();
        if (class_28022 instanceof class_3215) {
            class_3215 cache = (class_3215)class_28022;
            cache.field_17254.method_17210(chunk.method_12004(), false).forEach(player -> this.sendToPlayer(packet, (class_1657)player));
        }
    }

    public <T extends Packet<T>> void sendToPlayersInRange(T packet, class_1937 level, class_2338 pos, double range) {
        level.method_18456().stream().filter(player -> player.method_24515().method_10262((class_2382)pos) <= range).forEach(player -> this.sendToPlayer(packet, (class_1657)player));
    }
}

