/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.config;

import com.terraformersmc.biolith.impl.Biolith;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_18;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class BiolithState
extends class_18 {
    private final LinkedHashMap<class_5321<class_1959>, LinkedHashSet<class_5321<class_1959>>> biomeReplacements = new LinkedHashMap(64);
    private final class_3218 world;
    private final String stateId;
    private static final int STATE_VERSION = 0;

    public BiolithState(class_3218 world) {
        this(world, world.method_44013().method_29177().method_12832());
    }

    public BiolithState(class_3218 serverWorld, String name) {
        this.world = serverWorld;
        this.stateId = "biolith_" + name + "_state";
        this.world.method_17983().method_123(this.stateId, (class_18)this);
        this.readState();
    }

    private void writeState() {
        this.method_80();
        this.world.method_17983().method_125();
    }

    private void readState() {
        class_2487 nbt = null;
        class_2487 nbtState = null;
        try {
            nbt = this.world.method_17983().method_17923(this.stateId, 0);
        }
        catch (IOException e) {
            Biolith.LOGGER.debug("No saved state found for {}; starting anew...", (Object)this.stateId);
        }
        if (nbt != null && nbt.method_10545("data")) {
            int nbtVersion = nbt.method_10550("DataVersion");
            nbtState = nbt.method_10562("data");
        }
        this.biomeReplacements.clear();
        if (nbtState != null && !nbtState.method_33133()) {
            class_2499 biomeReplacementsNbt = nbtState.method_10554("BiomeReplacementsList", 9);
            biomeReplacementsNbt.forEach(nbtElement -> {
                class_2499 replacementsNbt = (class_2499)nbtElement.method_10707();
                class_2960 elementId = class_2960.method_12829((String)replacementsNbt.method_10608(0));
                if (elementId == null) {
                    Biolith.LOGGER.warn("{}: Failed to parse target biome identifier from NBT: {}", (Object)this.stateId, (Object)replacementsNbt.method_10608(0));
                } else if (replacementsNbt.size() < 2) {
                    Biolith.LOGGER.warn("{}: Replacements list from NBT contains no replacements: {}", (Object)this.stateId, (Object)replacementsNbt.method_10608(0));
                } else {
                    class_5321 target = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)elementId);
                    replacementsNbt.method_10536(0);
                    this.biomeReplacements.put((class_5321<class_1959>)target, replacementsNbt.stream().map(element -> class_2960.method_12829((String)element.method_10714())).filter(Objects::nonNull).map(id -> class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)id)).collect(Collectors.toCollection(LinkedHashSet::new)));
                    Biolith.LOGGER.debug("{}: Resolved replacements list from NBT: {} -> {}", new Object[]{this.stateId, target.method_29177(), this.biomeReplacements.get(target).stream().map(class_5321::method_29177).toList()});
                }
            });
        }
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 biomeReplacementsNbt = new class_2499();
        this.biomeReplacements.forEach((target, replacements) -> {
            class_2499 replacementsNbt = new class_2499();
            replacementsNbt.add((Object)class_2519.method_23256((String)target.method_29177().toString()));
            replacementsNbt.addAll(replacements.stream().map(replacement -> class_2519.method_23256((String)replacement.method_29177().toString())).toList());
            biomeReplacementsNbt.add((Object)replacementsNbt);
        });
        Biolith.LOGGER.debug("{}: Describing biome replacemnts NBT:\n{}", (Object)this.stateId, (Object)biomeReplacementsNbt);
        nbt.method_10566("BiomeReplacementsList", (class_2520)biomeReplacementsNbt);
        return nbt;
    }

    public Stream<class_5321<class_1959>> getBiomeReplacements(class_5321<class_1959> target) {
        if (this.biomeReplacements.containsKey(target)) {
            return this.biomeReplacements.get(target).stream();
        }
        return Stream.empty();
    }

    public void addBiomeReplacements(class_5321<class_1959> target, Stream<class_5321<class_1959>> replacements) {
        if (this.biomeReplacements.containsKey(target)) {
            replacements.forEachOrdered(this.biomeReplacements.get(target)::add);
        } else {
            this.biomeReplacements.put(target, replacements.collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        this.method_80();
    }
}

