/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.SubBiomeMatcherImpl;
import com.terraformersmc.biolith.impl.compat.BiolithCompat;
import com.terraformersmc.biolith.impl.compat.VanillaCompat;
import com.terraformersmc.biolith.impl.platform.Services;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

public class BiolithDescribeCommand {
    protected static int atCaller(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (!((class_2168)context.getSource()).method_43737()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"biolith.command.describe.nonPlayer").method_27692(class_124.field_1061));
            return -1;
        }
        return BiolithDescribeCommand.atBlockPos(context, ((class_2168)context.getSource()).method_9207().method_24515());
    }

    protected static int atEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        return BiolithDescribeCommand.atBlockPos(context, class_2186.method_9313(context, (String)"entity").method_24515());
    }

    protected static int atPosition(CommandContext<class_2168> context) throws CommandSyntaxException {
        return BiolithDescribeCommand.atBlockPos(context, class_2262.method_9697(context, (String)"position"));
    }

    private static int atBlockPos(CommandContext<class_2168> context, class_2338 pos) {
        DescribeBiomeData describeBiomeData;
        int replacementScale;
        double replacementNoise;
        BiolithFittestNodes<Object> vanillaFittestNodes;
        class_6544.class_6553 noisePoint;
        int mbStatus;
        class_1966 biomeSource;
        class_1966 iBiomeSource;
        class_6544.class_6547<class_6880<class_1959>> biomeEntries;
        int biomeX = class_5742.method_33100((int)pos.method_10263());
        int biomeY = class_5742.method_33100((int)pos.method_10264());
        int biomeZ = class_5742.method_33100((int)pos.method_10260());
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        if (world == null) {
            world = ((class_2168)context.getSource()).method_9211().method_30002();
        }
        if ((biomeEntries = (iBiomeSource = (biomeSource = world.method_14178().method_12129().method_12098())).biolith$getBiomeEntries()) == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"biolith.command.describe.notOurs").method_27692(class_124.field_1061));
            return -1;
        }
        class_6544.class_6552 noise = world.method_14178().method_41248().method_42371();
        if (BiolithCompat.COMPAT_MODERN_BETA && (mbStatus = Services.PLATFORM.describeModernBeta(context, biomeX, biomeY, biomeZ, world, biomeSource, biomeEntries, noise)) != 0) {
            return mbStatus;
        }
        BiolithFittestNodes<Object> fittestNodes = null;
        BiolithFittestNodes<Object> terrablenderFittestNodes = null;
        if (world.method_40134().method_40225(class_7134.field_37666)) {
            noisePoint = noise.method_40444(biomeX, biomeY, biomeZ);
            vanillaFittestNodes = VanillaCompat.getBiome(noisePoint, biomeEntries);
            if (BiolithCompat.COMPAT_TERRABLENDER) {
                terrablenderFittestNodes = Services.PLATFORM.getTerraBlenderCompat().getBiome(biomeX, biomeY, biomeZ, noisePoint, biomeEntries);
                fittestNodes = terrablenderFittestNodes;
            }
            if (fittestNodes == null) {
                fittestNodes = vanillaFittestNodes;
            }
            replacementNoise = BiomeCoordinator.OVERWORLD.getLocalNoise(biomeX, biomeY, biomeZ);
            replacementScale = Biolith.getConfigManager().getGeneralConfig().getOverworldReplacementScale();
            describeBiomeData = BiomeCoordinator.OVERWORLD.getBiomeData(biomeX, biomeY, biomeZ, noisePoint, fittestNodes);
        } else if (world.method_40134().method_40225(class_7134.field_37667)) {
            noisePoint = noise.method_40444(biomeX, biomeY, biomeZ);
            vanillaFittestNodes = VanillaCompat.getBiome(noisePoint, biomeEntries);
            if (BiolithCompat.COMPAT_TERRABLENDER) {
                terrablenderFittestNodes = Services.PLATFORM.getTerraBlenderCompat().getBiome(biomeX, biomeY, biomeZ, noisePoint, biomeEntries);
                fittestNodes = terrablenderFittestNodes;
            }
            if (fittestNodes == null) {
                fittestNodes = vanillaFittestNodes;
            }
            replacementNoise = BiomeCoordinator.NETHER.getLocalNoise(biomeX, biomeY, biomeZ);
            replacementScale = Biolith.getConfigManager().getGeneralConfig().getNetherReplacementScale();
            describeBiomeData = BiomeCoordinator.NETHER.getBiomeData(biomeX, biomeY, biomeZ, noisePoint, fittestNodes);
        } else if (world.method_40134().method_40225(class_7134.field_37668)) {
            class_6880<class_1959> original = VanillaCompat.getOriginalEndBiome(biomeX, biomeY, biomeZ, noise);
            noisePoint = BiomeCoordinator.END.sampleEndNoise(biomeX, biomeY, biomeZ, noise, original);
            vanillaFittestNodes = new BiolithFittestNodes(new class_6544.class_6548.class_6549(DimensionBiomePlacement.OUT_OF_RANGE, VanillaCompat.getOriginalEndBiome(biomeX, biomeY, biomeZ, noise)), 0L);
            if (BiolithCompat.COMPAT_TERRABLENDER) {
                iBiomeSource.biolith$setBypass(true);
                terrablenderFittestNodes = new BiolithFittestNodes(new class_6544.class_6548.class_6549(DimensionBiomePlacement.OUT_OF_RANGE, (Object)biomeSource.method_38109(biomeX, biomeY, biomeZ, noise)), 0L);
                fittestNodes = terrablenderFittestNodes;
                iBiomeSource.biolith$setBypass(false);
            }
            if (fittestNodes == null) {
                fittestNodes = vanillaFittestNodes;
            }
            replacementNoise = BiomeCoordinator.END.getLocalNoise(biomeX, biomeY, biomeZ);
            replacementScale = Biolith.getConfigManager().getGeneralConfig().getEndReplacementScale();
            describeBiomeData = BiomeCoordinator.END.getBiomeData(biomeX, biomeY, biomeZ, noisePoint, fittestNodes);
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"biolith.command.describe.notOurs").method_27692(class_124.field_1061));
            return -1;
        }
        String worldTranslationKey = world.method_27983().method_29177().method_42094();
        if (worldTranslationKey.equals("minecraft.overworld")) {
            worldTranslationKey = "biolith.world.minecraft.overworld";
        } else if (worldTranslationKey.equals("minecraft.the_nether")) {
            worldTranslationKey = "biolith.world.minecraft.the_nether";
        } else if (worldTranslationKey.equals("minecraft.the_end")) {
            worldTranslationKey = "biolith.world.minecraft.the_end";
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7nBiolith ").method_10852((class_2561)class_2561.method_43471((String)worldTranslationKey).method_27692(class_124.field_1073)).method_10852((class_2561)class_2561.method_43470((String)"\u00a7n (")).method_10852((class_2561)class_2561.method_43471((String)"biolith.command.describe.biome.scale").method_27692(class_124.field_1073)).method_10852((class_2561)class_2561.method_43470((String)("\u00a7n: " + replacementScale + ") "))).method_10852((class_2561)class_2561.method_43471((String)"biolith.command.describe.header").method_27692(class_124.field_1073)));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)String.format("\u00a72Co\u00a7r:%+05.3f  \u00a78De\u00a7r:%+05.3f  \u00a7cEr\u00a7r:%+05.3f  \u00a71Hu\u00a7r:%+05.3f", Float.valueOf(class_6544.method_38666((long)noisePoint.comp_114())), Float.valueOf(class_6544.method_38666((long)noisePoint.comp_116())), Float.valueOf(class_6544.method_38666((long)noisePoint.comp_115())), Float.valueOf(class_6544.method_38666((long)noisePoint.comp_113())))));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)String.format("\u00a77PV\u00a7r:%+05.3f  \u00a74Te\u00a7r:%+05.3f  \u00a75We\u00a7r:%+05.3f  \u00a76BR\u00a7r:%+05.3f", Float.valueOf(class_6544.method_38666((long)SubBiomeMatcherImpl.pvFromWeirdness(noisePoint.comp_117()))), Float.valueOf(class_6544.method_38666((long)noisePoint.comp_112())), Float.valueOf(class_6544.method_38666((long)noisePoint.comp_117())), replacementNoise)));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"biolith.command.describe.biome.vanilla").method_10852((class_2561)BiolithDescribeCommand.textFromFittestNodes(vanillaFittestNodes)));
        if (terrablenderFittestNodes != null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"biolith.command.describe.biome.terrablender").method_10852((class_2561)BiolithDescribeCommand.textFromFittestNodes(terrablenderFittestNodes)));
        }
        if (describeBiomeData.replacementBiome != null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"biolith.command.describe.biome.replacement").method_10852((class_2561)BiolithDescribeCommand.textFromBiome(describeBiomeData.replacementBiome)).method_10852((class_2561)class_2561.method_43470((String)"\n    ")).method_10852((class_2561)(describeBiomeData.lowerBiome == null ? class_2561.method_43471((String)"biolith.command.describe.biome.none") : BiolithDescribeCommand.textFromBiome(describeBiomeData.lowerBiome))).method_10852((class_2561)class_2561.method_43470((String)" < ")).method_10852((class_2561)BiolithDescribeCommand.textFromBiome(describeBiomeData.replacementBiome)).method_10852((class_2561)class_2561.method_43470((String)" < ")).method_10852((class_2561)(describeBiomeData.higherBiome == null ? class_2561.method_43471((String)"biolith.command.describe.biome.none") : BiolithDescribeCommand.textFromBiome(describeBiomeData.higherBiome))).method_10852((class_2561)class_2561.method_43470((String)String.format("\n    %+05.3f < %+05.3f < %+05.3f ", Float.valueOf(describeBiomeData.replacementRange.x), replacementNoise, Float.valueOf(describeBiomeData.replacementRange.y)))));
        }
        if (describeBiomeData.subBiome != null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"biolith.command.describe.biome.sub").method_10852((class_2561)BiolithDescribeCommand.textFromBiome(describeBiomeData.subBiome)));
        }
        return 1;
    }

    public static class_5250 textFromFittestNodes(BiolithFittestNodes<class_6880<class_1959>> fittestNodes) {
        class_5250 text = BiolithDescribeCommand.textFromBiome(fittestNodes.ultimate());
        if (fittestNodes.penultimate() != null) {
            text = text.method_10852((class_2561)class_2561.method_43470((String)"\n    ")).method_10852((class_2561)class_2561.method_43471((String)"biolith.command.describe.biome.nearest")).method_10852((class_2561)BiolithDescribeCommand.textFromBiome(fittestNodes.penultimate())).method_27693(" (+" + (fittestNodes.penultimateDistance() - fittestNodes.ultimateDistance()) + ")");
        }
        return text;
    }

    public static class_5250 textFromBiome(class_6544.class_6548.class_6549<class_6880<class_1959>> leafNode) {
        return BiolithDescribeCommand.textFromBiome((class_5321<class_1959>)((class_5321)((class_6880)leafNode.field_34489).method_40230().orElseThrow()));
    }

    public static class_5250 textFromBiome(class_6880<class_1959> biome) {
        return BiolithDescribeCommand.textFromBiome((class_5321<class_1959>)((class_5321)biome.method_40230().orElseThrow()));
    }

    public static class_5250 textFromBiome(class_5321<class_1959> biome) {
        return class_2561.method_43471((String)biome.method_29177().method_42093("biome"));
    }

    public record DescribeBiomeData(@Nullable Vector2f replacementRange, @Nullable class_5321<class_1959> replacementBiome, @Nullable class_5321<class_1959> lowerBiome, @Nullable class_5321<class_1959> higherBiome, @Nullable class_5321<class_1959> subBiome) {
    }
}

