/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.terraformersmc.biolith.api.biome.SubBiomeMatcher;
import com.terraformersmc.biolith.impl.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2fc;

public class SubBiomeMatcherImpl
extends SubBiomeMatcher {
    private final List<SubBiomeMatcher.Criterion> criteria = new ArrayList<SubBiomeMatcher.Criterion>(8);

    SubBiomeMatcherImpl() {
    }

    public static SubBiomeMatcherImpl of(SubBiomeMatcher.Criterion ... criteria) {
        SubBiomeMatcherImpl matcher = new SubBiomeMatcherImpl();
        for (SubBiomeMatcher.Criterion criterion : criteria) {
            matcher.addCriterion(criterion);
        }
        return matcher;
    }

    @Override
    public SubBiomeMatcherImpl addCriterion(SubBiomeMatcher.Criterion criterion) {
        if (!this.criteria.contains(criterion)) {
            this.criteria.add(criterion);
        }
        return this;
    }

    @Override
    public void sort() {
        this.criteria.sort(Comparator.comparingInt(criterion -> criterion.target().ordinal()));
    }

    @Override
    public boolean matches(BiolithFittestNodes<class_6880<class_1959>> fittestNodes, DimensionBiomePlacement biomePlacement, class_6544.class_6553 noisePoint, @Nullable Vector2fc replacementRange, float replacementNoise) {
        class_6544.class_6546[] parameters = fittestNodes.ultimate().field_34490;
        for (SubBiomeMatcher.Criterion criterion : this.criteria) {
            switch (criterion.target()) {
                case ALTERNATE: {
                    if (!criterion.checkBiome(SubBiomeMatcher.CriterionTargets.ALTERNATE, fittestNodes, biomePlacement, replacementNoise)) break;
                    return false;
                }
                case CENTER: {
                    if (!criterion.checkReplacement(SubBiomeMatcher.CriterionTargets.CENTER, fittestNodes, noisePoint, replacementRange, replacementNoise)) break;
                    return false;
                }
                case EDGE: {
                    if (!criterion.checkReplacement(SubBiomeMatcher.CriterionTargets.EDGE, fittestNodes, noisePoint, replacementRange, replacementNoise)) break;
                    return false;
                }
                case NEIGHBOR: {
                    if (!criterion.checkBiome(SubBiomeMatcher.CriterionTargets.NEIGHBOR, fittestNodes, biomePlacement, replacementNoise)) break;
                    return false;
                }
                case CONTINENTALNESS: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.CONTINENTALNESS.ordinal()], noisePoint.comp_114())) break;
                    return false;
                }
                case DEPTH: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.DEPTH.ordinal()], noisePoint.comp_116())) break;
                    return false;
                }
                case EROSION: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.EROSION.ordinal()], noisePoint.comp_115())) break;
                    return false;
                }
                case HUMIDITY: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.HUMIDITY.ordinal()], noisePoint.comp_113())) break;
                    return false;
                }
                case ORIGINAL: {
                    if (!criterion.checkBiome(SubBiomeMatcher.CriterionTargets.ORIGINAL, fittestNodes, biomePlacement, replacementNoise)) break;
                    return false;
                }
                case PEAKS_VALLEYS: {
                    long weirdnessMin = parameters[SubBiomeMatcher.ParameterListIndex.WEIRDNESS.ordinal()].comp_103();
                    long weirdnessMax = parameters[SubBiomeMatcher.ParameterListIndex.WEIRDNESS.ordinal()].comp_104();
                    long point1 = SubBiomeMatcherImpl.pvFromWeirdness(weirdnessMin);
                    long point2 = SubBiomeMatcherImpl.pvFromWeirdness(weirdnessMax);
                    long pvMin = (float)weirdnessMin < 0.0f && (float)weirdnessMax > 0.0f ? -10000L : Math.min(point1, point2);
                    long pvMax = (float)weirdnessMin < -6666.6665f && (float)weirdnessMax > -6666.6665f || (float)weirdnessMin < 6666.6665f && (float)weirdnessMax > 6666.6665f ? 10000L : Math.max(point1, point2);
                    class_6544.class_6546 pvRange = new class_6544.class_6546(pvMin, pvMax);
                    if (!criterion.checkRange(criterion.type(), pvRange, SubBiomeMatcherImpl.pvFromWeirdness(noisePoint.comp_117()))) break;
                    return false;
                }
                case TEMPERATURE: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.TEMPERATURE.ordinal()], noisePoint.comp_112())) break;
                    return false;
                }
                case WEIRDNESS: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.WEIRDNESS.ordinal()], noisePoint.comp_117())) break;
                    return false;
                }
            }
        }
        return true;
    }

    public static long pvFromWeirdness(long weirdness) {
        return 10000L - Math.abs(Math.abs(weirdness * 3L) - 20000L);
    }

    public record Criterion(SubBiomeMatcher.CriterionTargets target, SubBiomeMatcher.CriterionTypes type, class_5321<class_1959> biome, class_5321<class_1959> secondary, class_6862<class_1959> biomeTag, float min, float max, boolean invert) implements SubBiomeMatcher.Criterion
    {
        public Criterion {
            switch (type) {
                case BIOME: {
                    if (target == SubBiomeMatcher.CriterionTargets.ALTERNATE || target == SubBiomeMatcher.CriterionTargets.NEIGHBOR || target == SubBiomeMatcher.CriterionTargets.ORIGINAL) break;
                    throw new IllegalArgumentException("Criterion type BIOME must have targets ALTERNATE, NEIGHBOR, or ORIGINAL.");
                }
                case RATIO: {
                    if (target == SubBiomeMatcher.CriterionTargets.CENTER || target == SubBiomeMatcher.CriterionTargets.EDGE) break;
                    throw new IllegalArgumentException("Criterion type RATIO must have targets CENTER or EDGE.");
                }
                case DISTANCE: 
                case VALUE: {
                    if (target != SubBiomeMatcher.CriterionTargets.CENTER && target != SubBiomeMatcher.CriterionTargets.EDGE && target != SubBiomeMatcher.CriterionTargets.NEIGHBOR && target != SubBiomeMatcher.CriterionTargets.ORIGINAL) break;
                    throw new IllegalArgumentException("Criterion types DISTANCE and VALUE cannot have targets ALTERNATE, CENTER, EDGE, NEIGHBOR, or ORIGINAL.");
                }
            }
        }

        public static Criterion ofRange(SubBiomeMatcher.CriterionTargets target, SubBiomeMatcher.CriterionTypes type, float min, float max, boolean invert) {
            return new Criterion(target, type, null, null, null, min, max, invert);
        }

        public static Criterion ofMin(SubBiomeMatcher.CriterionTargets target, SubBiomeMatcher.CriterionTypes type, float min) {
            return new Criterion(target, type, null, null, null, min, Float.MAX_VALUE, false);
        }

        public static Criterion ofMax(SubBiomeMatcher.CriterionTargets target, SubBiomeMatcher.CriterionTypes type, float max) {
            return new Criterion(target, type, null, null, null, Float.MIN_VALUE, max, false);
        }

        public static Criterion ofBiome(SubBiomeMatcher.CriterionTargets target, class_5321<class_1959> biome, boolean invert) {
            return new Criterion(target, SubBiomeMatcher.CriterionTypes.BIOME, biome, null, null, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        public static Criterion ofBiome(SubBiomeMatcher.CriterionTargets target, class_6862<class_1959> biomeTag, boolean invert) {
            return new Criterion(target, SubBiomeMatcher.CriterionTypes.BIOME, null, null, biomeTag, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        public static Criterion ofAlternate(SubBiomeMatcher.CriterionTargets target, class_5321<class_1959> biome, class_5321<class_1959> alternateBiome, boolean invert) {
            return new Criterion(target, SubBiomeMatcher.CriterionTypes.BIOME, biome, alternateBiome, null, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        @Override
        public boolean checkBiome(SubBiomeMatcher.CriterionTargets target, BiolithFittestNodes<class_6880<class_1959>> fittestNodes, DimensionBiomePlacement biomePlacement, float replacementNoise) {
            class_6880<class_1959> comparable = null;
            if (target == SubBiomeMatcher.CriterionTargets.ORIGINAL) {
                comparable = (class_6880<class_1959>)fittestNodes.ultimate().field_34489;
            } else if (target == SubBiomeMatcher.CriterionTargets.NEIGHBOR) {
                if (fittestNodes.penultimate() != null) {
                    comparable = (class_6880)fittestNodes.penultimate().field_34489;
                }
            } else if (target == SubBiomeMatcher.CriterionTargets.ALTERNATE) {
                DimensionBiomePlacement.ReplacementRequestSet requests = biomePlacement.replacementRequests.get(this.secondary);
                DimensionBiomePlacement.ReplacementRequest request = null;
                if (requests != null) {
                    request = requests.selectReplacement(replacementNoise);
                }
                if (request == null || request.biome().equals(DimensionBiomePlacement.VANILLA_PLACEHOLDER)) {
                    return this.invert == (this.biome != null && this.biome.equals(this.secondary));
                }
                comparable = request.biomeEntry();
            }
            return this.invert == (comparable != null && (this.biome != null && comparable.method_40225(this.biome) || this.biomeTag != null && comparable.method_40220(this.biomeTag)));
        }

        @Override
        public boolean checkRange(SubBiomeMatcher.CriterionTypes type, class_6544.class_6546 range, long value) {
            float comparable = Float.MAX_VALUE;
            if (type == SubBiomeMatcher.CriterionTypes.DISTANCE) {
                comparable = class_6544.method_38666((long)(value - Criterion.parameterCenter(range)));
            } else if (type == SubBiomeMatcher.CriterionTypes.VALUE) {
                comparable = class_6544.method_38666((long)value);
            }
            return this.invert == (comparable >= this.min() && comparable <= this.max());
        }

        @Override
        public boolean checkReplacement(SubBiomeMatcher.CriterionTargets target, BiolithFittestNodes<class_6880<class_1959>> fittestNodes, class_6544.class_6553 noisePoint, @Nullable Vector2fc replacementRange, float replacementNoise) {
            float comparable = Float.MAX_VALUE;
            if (target == SubBiomeMatcher.CriterionTargets.CENTER) {
                comparable = class_3532.method_15355((float)Criterion.getSquaredDistance(Criterion.parametersCenterPoint(fittestNodes.ultimate().field_34490), noisePoint)) / 10000.0f;
                if (replacementRange != null) {
                    if (replacementRange.x() <= 0.0f) {
                        if (replacementRange.y() < 1.0f) {
                            comparable = Math.max(replacementNoise, comparable);
                        }
                    } else {
                        comparable = replacementRange.y() >= 1.0f ? Math.max(1.0f - replacementNoise, comparable) : Math.max(Math.abs(replacementNoise - (replacementRange.x() + replacementRange.y()) / 2.0f), comparable);
                    }
                }
            } else if (target == SubBiomeMatcher.CriterionTargets.EDGE) {
                comparable = fittestNodes.penultimate() == null ? 1.0f : (fittestNodes.penultimateDistance() == 0L ? 0.0f : (float)(fittestNodes.penultimateDistance() - fittestNodes.ultimateDistance()) / (float)fittestNodes.penultimateDistance());
                if (replacementRange != null) {
                    if (replacementRange.x() <= 0.0f) {
                        if (replacementRange.y() < 1.0f) {
                            comparable = Math.min(replacementRange.y() - replacementNoise, comparable);
                        }
                    } else {
                        comparable = replacementRange.y() >= 1.0f ? Math.min(replacementNoise - replacementRange.x(), comparable) : Math.min(Math.min(replacementNoise - replacementRange.x(), replacementRange.y() - replacementNoise), comparable);
                    }
                }
            }
            return this.invert == (comparable >= this.min() && comparable <= this.max());
        }

        static long parameterCenter(class_6544.class_6546 range) {
            return (range.comp_103() + range.comp_104()) / 2L;
        }

        static class_6544.class_6553 parametersCenterPoint(class_6544.class_6546[] parameters) {
            return new class_6544.class_6553(Criterion.parameterCenter(parameters[0]), Criterion.parameterCenter(parameters[1]), Criterion.parameterCenter(parameters[2]), Criterion.parameterCenter(parameters[3]), Criterion.parameterCenter(parameters[4]), Criterion.parameterCenter(parameters[5]));
        }

        static long getSquaredDistance(class_6544.class_6553 point1, class_6544.class_6553 point2) {
            return class_3532.method_38652((long)(point1.comp_112() - point2.comp_112())) + class_3532.method_38652((long)(point1.comp_113() - point2.comp_113())) + class_3532.method_38652((long)(point1.comp_114() - point2.comp_114())) + class_3532.method_38652((long)(point1.comp_115() - point2.comp_115())) + class_3532.method_38652((long)(point1.comp_116() - point2.comp_116())) + class_3532.method_38652((long)(point1.comp_117() - point2.comp_117()));
        }
    }
}

