/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7871;

public class NetherBiomePlacement
extends DimensionBiomePlacement {
    private final double[] scale = new double[5];

    public NetherBiomePlacement() {
        int configScale = Biolith.getConfigManager().getGeneralConfig().getNetherReplacementScale();
        this.scale[0] = 256 * configScale;
        this.scale[1] = 64 * configScale;
        this.scale[2] = 32 * configScale;
        this.scale[3] = 8 * configScale;
        this.scale[4] = 2 * configScale;
    }

    @Override
    public double getLocalNoise(int x, int y, int z) {
        double localNoise = this.replacementNoise.sample((double)(x + this.seedlets[0]) / this.scale[0], (double)(y + this.seedlets[0]) / this.scale[1], (double)(z + this.seedlets[1]) / this.scale[0]);
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[4]) / this.scale[2], (double)(y + this.seedlets[0]) / this.scale[3], (double)(z + this.seedlets[5]) / this.scale[2]) / 16.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[6]) / this.scale[3], (double)(y + this.seedlets[0]) / this.scale[4], (double)(z + this.seedlets[7]) / this.scale[3]) / 32.0;
        localNoise = this.normalize(localNoise / 1.09375);
        return localNoise;
    }

    @Override
    public void writeBiomeEntries(Consumer<Pair<class_6544.class_4762, class_6880<class_1959>>> parameters) {
        this.biomesInjected = true;
        class_7871<class_1959> biomeEntryGetter = BiomeCoordinator.getBiomeLookupOrThrow();
        this.placementRequests.forEach(pair -> parameters.accept(pair.mapSecond(arg_0 -> ((class_7871)biomeEntryGetter).method_46747(arg_0))));
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.method_46747(biome)));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.method_46747(biome))));
    }

    @Override
    public void writeBiomeParameters(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        this.biomesInjected = true;
        this.placementRequests.forEach(parameters);
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome)));
    }
}

