/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.config.BiolithState;
import com.terraformersmc.biolith.impl.noise.OpenSimplexNoise2;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7871;

public class EndBiomePlacement
extends DimensionBiomePlacement {
    private final double[] scale = new double[4];
    private final class_6544.class_4762 noiseSmallEndIslands = new class_6544.class_4762(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.21875f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    private final class_6544.class_4762 noiseEndBarrens = new class_6544.class_4762(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, class_6544.class_6546.method_38121((float)-0.21875f, (float)-0.0625f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    private final class_6544.class_4762 noiseEndMidlands = new class_6544.class_4762(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, class_6544.class_6546.method_38121((float)-0.0625f, (float)0.25f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    private final class_6544.class_4762 noiseEndHighlands = new class_6544.class_4762(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, class_6544.class_6546.method_38121((float)0.25f, (float)1.0f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    public class_6544.class_6548.class_6549<class_6880<class_1959>> nodeSmallEndIslands;
    public class_6544.class_6548.class_6549<class_6880<class_1959>> nodeEndBarrens;
    public class_6544.class_6548.class_6549<class_6880<class_1959>> nodeEndMidlands;
    public class_6544.class_6548.class_6549<class_6880<class_1959>> nodeEndHighlands;
    public OpenSimplexNoise2 humidityNoise;
    public OpenSimplexNoise2 temperatureNoise;
    public OpenSimplexNoise2 weirdnessNoise;

    public EndBiomePlacement() {
        int configScale = Biolith.getConfigManager().getGeneralConfig().getEndReplacementScale();
        this.scale[0] = 256 * configScale;
        this.scale[1] = 64 * configScale;
        this.scale[2] = 16 * configScale;
        this.scale[3] = 4 * configScale;
    }

    @Override
    protected void serverReplaced(BiolithState state, long seed) {
        super.serverReplaced(state, seed);
        class_7871<class_1959> biomeEntryGetter = BiomeCoordinator.getBiomeLookupOrThrow();
        this.nodeSmallEndIslands = new class_6544.class_6548.class_6549(this.noiseSmallEndIslands, (Object)biomeEntryGetter.method_46747(class_1972.field_9457));
        this.nodeEndBarrens = new class_6544.class_6548.class_6549(this.noiseEndBarrens, (Object)biomeEntryGetter.method_46747(class_1972.field_9465));
        this.nodeEndMidlands = new class_6544.class_6548.class_6549(this.noiseEndMidlands, (Object)biomeEntryGetter.method_46747(class_1972.field_9447));
        this.nodeEndHighlands = new class_6544.class_6548.class_6549(this.noiseEndHighlands, (Object)biomeEntryGetter.method_46747(class_1972.field_9442));
        this.humidityNoise = new OpenSimplexNoise2(this.seedlets[7]);
        this.temperatureNoise = new OpenSimplexNoise2(this.seedlets[5]);
        this.weirdnessNoise = new OpenSimplexNoise2(this.seedlets[3]);
    }

    @Override
    public double getLocalNoise(int x, int y, int z) {
        double localNoise = this.replacementNoise.sample((double)(x + this.seedlets[0]) / this.scale[0], (double)(z + this.seedlets[1]) / this.scale[0]);
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[2]) / this.scale[1], (double)(z + this.seedlets[3]) / this.scale[1]) / 4.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[4]) / this.scale[2], (double)(z + this.seedlets[5]) / this.scale[2]) / 16.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[6]) / this.scale[3], (double)(z + this.seedlets[7]) / this.scale[3]) / 32.0;
        localNoise = this.normalize(localNoise / 1.3125);
        return localNoise;
    }

    @Override
    public void writeBiomeEntries(Consumer<Pair<class_6544.class_4762, class_6880<class_1959>>> parameters) {
        this.biomesInjected = true;
        class_7871<class_1959> biomeEntryGetter = BiomeCoordinator.getBiomeLookupOrThrow();
        this.placementRequests.forEach(pair -> parameters.accept(pair.mapSecond(arg_0 -> ((class_7871)biomeEntryGetter).method_46747(arg_0))));
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.method_46747(biome)));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.method_46747(biome))));
    }

    @Override
    public void writeBiomeParameters(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        this.biomesInjected = true;
        this.placementRequests.forEach(parameters);
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome)));
    }

    public class_6544.class_6553 sampleEndNoise(int x, int y, int z, class_6544.class_6552 originalNoise, class_6880<class_1959> originalBiome) {
        double erosion = originalNoise.comp_367().method_40464((class_6910.class_6912)new class_6910.class_6914((class_4076.method_18675((int)class_5742.method_33101((int)x)) * 2 + 1) * 8, class_5742.method_33101((int)y), (class_4076.method_18675((int)class_5742.method_33101((int)z)) * 2 + 1) * 8));
        return new class_6544.class_6553(class_6544.method_38665((float)this.temperatureNoise.sample((double)x / 576.0, (double)z / 576.0)), class_6544.method_38665((float)this.humidityNoise.sample((double)x / 448.0, (double)z / 448.0)), originalBiome.method_40225(class_1972.field_9411) ? 0L : class_6544.method_38665((float)class_3532.method_15363((float)((float)erosion + 0.0625f), (float)-1.0f, (float)1.0f)), class_6544.method_38665((float)((float)erosion)), 156L * (long)(56 - y), class_6544.method_38665((float)this.weirdnessNoise.sample((double)x / 192.0, (double)z / 192.0)));
    }
}

