/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.mobspawners;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.mobspawners.MobSpawnerObj;
import com.telepathicgrunt.repurposedstructures.mixins.features.DungeonFeatureAccessor;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.apache.logging.log4j.Level;

public class MobSpawnerManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    public static final MobSpawnerManager MOB_SPAWNER_MANAGER = new MobSpawnerManager();
    private Map<class_2960, List<MobSpawnerObj>> spawnerMap = ImmutableMap.of();

    public MobSpawnerManager() {
        super(GSON, "rs_spawners");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                List spawnerMobEntries = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("mobs"), new TypeToken<List<MobSpawnerObj>>(){}.getType());
                for (int i = spawnerMobEntries.size() - 1; i >= 0; --i) {
                    MobSpawnerObj entry = (MobSpawnerObj)spawnerMobEntries.get(i);
                    entry.setEntityType();
                    if (entry.weight == 0.0f || entry.entityType == null) {
                        spawnerMobEntries.remove(i);
                        continue;
                    }
                    if (!(entry.weight < 0.0f)) continue;
                    throw new Exception("Error: Found " + entry.name + " entry has a weight less than 0. Please remove the entry if you don't want a mob to be picked");
                }
                builder.put(fileIdentifier, (Object)spawnerMobEntries);
            }
            catch (Exception e) {
                RepurposedStructures.LOGGER.error("Repurposed Structures Error: Couldn't parse spawner mob list {}", fileIdentifier, (Object)e);
            }
        });
        this.spawnerMap = builder.build();
    }

    public class_1299<?> getSpawnerMob(class_2960 spawnerJsonEntry, class_5819 random) {
        List<MobSpawnerObj> spawnerMobEntries = this.spawnerMap.get(spawnerJsonEntry);
        if (spawnerMobEntries == null) {
            RepurposedStructures.LOGGER.log(Level.ERROR, "\n***************************************\nFailed to get mob. Please check that " + String.valueOf(spawnerJsonEntry) + ".json is correct or that no other mod is interfering with how vanilla reads data folders. Let TelepathicGrunt know about this too!\n***************************************");
            return (class_1299)class_156.method_27173((Object[])DungeonFeatureAccessor.getMOBS(), (class_5819)random);
        }
        float totalWeight = 0.0f;
        for (MobSpawnerObj mobSpawnerObj : spawnerMobEntries) {
            totalWeight += mobSpawnerObj.weight;
        }
        if (totalWeight == 0.0f) {
            return null;
        }
        float randomWeight = random.method_43057() * totalWeight;
        int index = 0;
        try {
            while (true) {
                if ((randomWeight -= spawnerMobEntries.get((int)index).weight) <= 0.0f) {
                    return (class_1299)class_7923.field_41177.method_10223(new class_2960(spawnerMobEntries.get((int)index).name));
                }
                ++index;
            }
        }
        catch (Exception e) {
            RepurposedStructures.LOGGER.log(Level.ERROR, "\n***************************************\nFailed to get mob. Please check that " + String.valueOf(spawnerJsonEntry) + ".json is correct and let Telepathicgrunt (mod author) know he broke the mob spawner code!\n***************************************");
            return class_1299.field_6093;
        }
    }
}

