/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.maptrades;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixins.entities.MerchantOfferAccessor;
import com.telepathicgrunt.repurposedstructures.mixins.items.MapItemAccessor;
import com.telepathicgrunt.repurposedstructures.utils.AsyncLocator;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3988;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;

public class MerchantMapUpdating {
    private MerchantMapUpdating() {
    }

    public static void invalidateMap(class_3988 merchant, class_1799 mapStack) {
        mapStack.method_7977((class_2561)class_2561.method_43471((String)"item.minecraft.map"));
        merchant.method_8264().stream().filter(offer -> offer.method_8250() == mapStack).findFirst().ifPresentOrElse(offer -> MerchantMapUpdating.removeOffer(merchant, offer), () -> RepurposedStructures.LOGGER.warn("Failed to find merchant offer for map"));
    }

    public static void removeOffer(class_3988 merchant, class_1914 offer) {
        ((MerchantOfferAccessor)offer).setMaxUses(0);
        offer.method_8254();
    }

    public static void handleLocationFound(class_3218 level, class_3988 merchant, class_1799 mapStack, String displayName, class_20.class_21 destinationType, class_2338 pos) {
        if (pos == null) {
            MerchantMapUpdating.invalidateMap(merchant, mapStack);
        } else {
            MerchantMapUpdating.updateMap(mapStack, level, pos, 2, destinationType, displayName);
        }
        class_1657 class_16572 = merchant.method_8257();
        if (class_16572 instanceof class_3222) {
            int n;
            class_3222 tradingPlayer = (class_3222)class_16572;
            int n2 = tradingPlayer.field_7512.field_7763;
            class_1916 class_19162 = merchant.method_8264();
            if (merchant instanceof class_1646) {
                class_1646 villager = (class_1646)merchant;
                n = villager.method_7231().method_16925();
            } else {
                n = 1;
            }
            tradingPlayer.method_17354(n2, class_19162, n, merchant.method_19269(), merchant.method_19270(), merchant.method_20708());
        }
    }

    public static class_1914 updateMapAsync(class_1297 pTrader, int emeraldCost, String displayName, class_20.class_21 destinationType, int maxUses, int villagerXp, class_6862<class_3195> destination, int searchRadius) {
        return MerchantMapUpdating.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locate(level, destination, merchant.method_24515(), searchRadius, true).thenOnServerThread(pos -> MerchantMapUpdating.handleLocationFound(level, merchant, mapStack, displayName, destinationType, pos)));
    }

    public static class_1914 updateMapAsync(class_1297 pTrader, int emeraldCost, String displayName, class_20.class_21 destinationType, int maxUses, int villagerXp, class_6885<class_3195> structureSet, int searchRadius) {
        return MerchantMapUpdating.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locate(level, structureSet, merchant.method_24515(), searchRadius, true).thenOnServerThread(pair -> MerchantMapUpdating.handleLocationFound(level, merchant, mapStack, displayName, destinationType, pair == null ? null : (class_2338)pair.getFirst())));
    }

    private static class_1914 updateMapAsyncInternal(class_1297 trader, int emeraldCost, int maxUses, int villagerXp, MapUpdateTask task) {
        if (trader instanceof class_3988) {
            class_3988 merchant = (class_3988)trader;
            class_1799 mapStack = MerchantMapUpdating.createEmptyMap();
            task.apply((class_3218)trader.method_37908(), merchant, mapStack);
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, emeraldCost), new class_1799((class_1935)class_1802.field_8251), mapStack, maxUses, villagerXp, 0.2f);
        }
        return null;
    }

    public static class_1799 createEmptyMap() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8204);
        stack.method_7977((class_2561)class_2561.method_43471((String)"Locating... (Do not buy this map until finished)"));
        return stack;
    }

    public static void updateMap(class_1799 mapStack, class_3218 level, class_2338 pos, int scale, class_20.class_21 destinationType, String displayName) {
        MapItemAccessor.callCreateAndStoreSavedData(mapStack, (class_1937)level, pos.method_10263(), pos.method_10260(), scale, true, true, (class_5321<class_1937>)level.method_27983());
        class_1806.method_8002((class_3218)level, (class_1799)mapStack);
        class_22.method_110((class_1799)mapStack, (class_2338)pos, (String)"+", (class_20.class_21)destinationType);
        if (displayName != null) {
            mapStack.method_7977((class_2561)class_2561.method_43471((String)displayName));
        }
    }

    public static interface MapUpdateTask {
        public void apply(class_3218 var1, class_3988 var2, class_1799 var3);
    }
}

