/*
 * Decompiled with CFR 0.152.
 */
package fuzs.skeletonaifix;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEvents;
import fuzs.skeletonaifix.config.ServerConfig;
import fuzs.skeletonaifix.init.ModRegistry;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1380;
import net.minecraft.class_1547;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkeletonAIFix
implements ModConstructor {
    public static final String MOD_ID = "skeletonaifix";
    public static final String MOD_NAME = "Skeleton AI Fix";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Skeleton AI Fix");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"skeletonaifix").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        SkeletonAIFix.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        LivingEvents.TICK.register(SkeletonAIFix::onEndEntityTick);
    }

    private static EventResult onEndEntityTick(class_1309 entity) {
        class_1547 abstractSkeleton;
        if (entity instanceof class_1547 && (abstractSkeleton = (class_1547)entity).method_5864().method_20210(ModRegistry.WELL_BEHAVED_SKELETONS_ENTITY_TYPE_TAG)) {
            class_1380 bowGoal = abstractSkeleton.field_7220;
            bowGoal.field_6568 = Integer.MIN_VALUE;
            class_1309 livingEntity = abstractSkeleton.method_5968();
            if (livingEntity != null) {
                double attackInterval = SkeletonAIFix.getAttackInterval(abstractSkeleton);
                double distanceToTargetSqr = abstractSkeleton.method_5858((class_1297)livingEntity);
                int minAttackInterval = SkeletonAIFix.getMinAttackInterval(attackInterval, distanceToTargetSqr, bowGoal.field_6570);
                bowGoal.method_6305(minAttackInterval);
            }
        }
        return EventResult.PASS;
    }

    private static double getAttackInterval(class_1547 abstractSkeleton) {
        double attackInterval = abstractSkeleton.method_37908().method_8407() == class_1267.field_5807 ? 40.0 : 20.0;
        return attackInterval *= ((ServerConfig)SkeletonAIFix.CONFIG.get(ServerConfig.class)).attackIntervalMultiplier;
    }

    private static int getMinAttackInterval(double attackInterval, double distanceToTargetSqr, double attackRadiusSqr) {
        double distanceScale = ((ServerConfig)SkeletonAIFix.CONFIG.get(ServerConfig.class)).attackIntervalDistanceScale;
        double baseAttackInterval = attackInterval * (1.0 - distanceScale);
        double attackRadiusScale = SkeletonAIFix.easeOutQuad(Math.min(distanceToTargetSqr / attackRadiusSqr, 1.0));
        double scaledAttackInterval = attackInterval * distanceScale * attackRadiusScale;
        return (int)(baseAttackInterval + scaledAttackInterval);
    }

    static double easeOutQuad(double x) {
        return 1.0 - (1.0 - x) * (1.0 - x);
    }

    public static class_2960 id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

