/*
 * Decompiled with CFR 0.152.
 */
package ru.hollowhorizon.additions.questing.mixins;

import dev.ftb.mods.ftbquests.client.gui.quests.QuestPanel;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.hollowhorizon.additions.questing.client.Animator;
import ru.hollowhorizon.additions.questing.client.QuestScreenZoom;
import ru.hollowhorizon.additions.questing.config.QuestAnimationsConfig;

@Mixin(value={QuestScreen.class}, remap=false)
public class QuestScreenMixin
implements QuestScreenZoom {
    @Unique
    private final Animator hollow$zoomAnimator = new Animator(16.0f, 0.075f, f -> f);
    @Shadow
    @Final
    public QuestPanel questPanel;
    @Shadow
    Chapter selectedChapter;
    @Unique
    private boolean hollow$zoomAnimating = false;

    @Inject(method={"addZoom"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onAddZoom(double up, CallbackInfo ci) {
        if (((Boolean)QuestAnimationsConfig.SMOOTH_SCROLLING.get()).booleanValue()) {
            float targetZoom = (float)Math.min(Math.max((double)this.hollow$zoomAnimator.get() + up * 4.0, 4.0), 28.0);
            this.hollow$zoomAnimator.set(targetZoom);
            this.hollow$zoomAnimating = true;
            ci.cancel();
        }
    }

    @Inject(method={"drawBackground"}, at={@At(value="HEAD")}, remap=false)
    private void onDraw(CallbackInfo ci) {
        if (this.hollow$zoomAnimating && ((Boolean)QuestAnimationsConfig.SMOOTH_SCROLLING.get()).booleanValue()) {
            this.hollow$zoomAnimator.update();
            this.questPanel.withPreservedPos(QuestPanel::resetScroll);
            if (!this.hollow$zoomAnimator.isAnimating()) {
                this.hollow$zoomAnimating = false;
            }
        }
    }

    @Inject(method={"getQuestButtonSize"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetQuestButtonSize(CallbackInfoReturnable<Double> cir) {
        if (!((Boolean)QuestAnimationsConfig.SMOOTH_SCROLLING.get()).booleanValue()) {
            return;
        }
        cir.setReturnValue((Object)(this.hollow$zoomAnimator.get() * 3.0f / 2.0f));
    }

    @Inject(method={"getQuestButtonSpacing"}, at={@At(value="HEAD")}, cancellable=true)
    public void getQuestButtonSpacing(CallbackInfoReturnable<Double> cir) {
        if (!((Boolean)QuestAnimationsConfig.SMOOTH_SCROLLING.get()).booleanValue()) {
            return;
        }
        cir.setReturnValue((Object)((double)this.hollow$zoomAnimator.get() * (Double)ThemeProperties.QUEST_SPACING.get((QuestObjectBase)this.selectedChapter) / 4.0));
    }

    @Override
    public float cqa$getZoom() {
        return this.hollow$zoomAnimator.get();
    }
}

