/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.client;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.CorgiLib;
import corgitaco.corgilib.platform.ModPlatform;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public record AnnouncementInfo(class_2561 title, class_2561 desc, class_2561 actionButtonText, long timeStamp, String url) {
    private static final String URL = "https://corgitaco.github.io/announcement.json";
    public static final Codec<AnnouncementInfo> CODEC = RecordCodecBuilder.create(announcementInfoInstance -> announcementInfoInstance.group((App)class_5699.field_40722.fieldOf("title").forGetter(AnnouncementInfo::title), (App)class_5699.field_40722.fieldOf("description").forGetter(AnnouncementInfo::desc), (App)class_5699.field_40722.fieldOf("action_button_text").forGetter(AnnouncementInfo::actionButtonText), (App)Codec.LONG.fieldOf("time").forGetter(AnnouncementInfo::timeStamp), (App)Codec.STRING.fieldOf("action_link").forGetter(AnnouncementInfo::url)).apply((Applicative)announcementInfoInstance, AnnouncementInfo::new));
    private static CompletableFuture<AnnouncementInfo> INSTANCE = CompletableFuture.supplyAsync(AnnouncementInfo::getTimeCheckedAnnouncement, class_156.method_18349());

    public static void saveStoredAnnouncementInfo() {
        if (INSTANCE == null) {
            return;
        }
        AnnouncementInfo announcementInfo = INSTANCE.getNow(null);
        if (announcementInfo == null) {
            return;
        }
        Path path = ModPlatform.PLATFORM.modConfigDir().resolve("announcement_store.json");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            StoredAnnouncementInfo storedAnnouncementInfo = new StoredAnnouncementInfo(class_310.method_1551().method_1548().method_44717(), announcementInfo.timeStamp);
            String json = new GsonBuilder().create().toJson((Object)storedAnnouncementInfo);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        INSTANCE = null;
    }

    @Nullable
    private static AnnouncementInfo getTimeCheckedAnnouncement() {
        AnnouncementInfo announcementInfo = AnnouncementInfo.createInstance();
        if (announcementInfo == null) {
            return null;
        }
        Path path = ModPlatform.PLATFORM.modConfigDir().resolve("announcement_store.json");
        if (path.toFile().exists()) {
            try {
                JsonElement jsonElement = JsonParser.parseReader((Reader)new FileReader(path.toFile()));
                StoredAnnouncementInfo storedAnnouncementInfo = (StoredAnnouncementInfo)new GsonBuilder().create().fromJson(jsonElement, StoredAnnouncementInfo.class);
                if (storedAnnouncementInfo.unixTime < announcementInfo.timeStamp() || !storedAnnouncementInfo.player.equals(class_310.method_1551().method_1548().method_44717())) {
                    return announcementInfo;
                }
                return null;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return announcementInfo;
    }

    @Nullable
    private static AnnouncementInfo createInstance() {
        JsonObject jsonObject = AnnouncementInfo.fetchAnnouncementJson(URL);
        if (jsonObject != null) {
            DataResult decoded = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject);
            if (decoded.result().isPresent()) {
                return (AnnouncementInfo)((Pair)decoded.result().orElseThrow()).getFirst();
            }
            if (decoded.error().isPresent()) {
                CorgiLib.LOGGER.error("Could not parse announcement json due to: %s".formatted(decoded.error().orElseThrow()));
            }
        }
        return null;
    }

    @Nullable
    private static JsonObject fetchAnnouncementJson(String url) {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                String body = response.body();
                JsonElement jsonElement = JsonParser.parseString((String)body);
                return jsonElement.getAsJsonObject();
            }
            CorgiLib.LOGGER.error("GET request failed. Response Code: {}", (Object)response.statusCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public static AnnouncementInfo getInstance() {
        return INSTANCE == null ? null : (AnnouncementInfo)INSTANCE.getNow(null);
    }

    private record StoredAnnouncementInfo(UUID player, long unixTime) {
    }
}

