/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.block.entity;

import com.google.common.collect.Lists;
import com.ninni.spawn.block.AnthillBlock;
import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnSoundEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class AnthillBlockEntity
extends class_2586 {
    public static final String MIN_OCCUPATION_TICKS_KEY = "MinOccupationTicks";
    public static final String ENTITY_DATA_KEY = "EntityData";
    public static final String TICKS_IN_ANTHILL_KEY = "TicksInAnthill";
    public static final String ANTS_KEY = "Ants";
    private static final List<String> IGNORED_ANT_TAGS = Arrays.asList("Bees", "Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "CannotEnterAnthillTicks", "TicksSinceGathering", "AnthillPos", "Passengers", "Leash", "UUID");
    private final List<Ant> ants = Lists.newArrayList();
    @Nullable
    private class_2338 savedResourcePos;
    private boolean hasResource;

    public AnthillBlockEntity(class_2338 pos, class_2680 state) {
        super(SpawnBlockEntityTypes.ANTHILL, pos, state);
    }

    public boolean hasNoAnts() {
        return this.ants.isEmpty();
    }

    public boolean isFullOfAnts() {
        return this.ants.size() == 3;
    }

    public void angerAnts(@Nullable class_1657 player, class_2680 state, AntState antState) {
        List<class_1297> list = this.tryReleaseAnt(state, antState);
        if (player != null) {
            for (class_1297 entity : list) {
                if (!(entity instanceof com.ninni.spawn.entity.Ant)) continue;
                com.ninni.spawn.entity.Ant ant = (com.ninni.spawn.entity.Ant)entity;
                if (!(player.method_19538().method_1025(entity.method_19538()) <= 16.0)) continue;
                ant.method_5980((class_1309)player);
                ant.setStayOutOfAnthillCountdown(400);
            }
        }
    }

    public void storeAnt(class_2487 nbt, int i, boolean bl) {
        this.ants.add(new Ant(nbt, i, bl ? 2400 : 600));
    }

    private List<class_1297> tryReleaseAnt(class_2680 state, AntState antState) {
        ArrayList list = Lists.newArrayList();
        this.ants.removeIf(ant -> {
            assert (this.field_11863 != null);
            return AnthillBlockEntity.releaseAnt(this.field_11863, this.field_11867, state, ant, list, antState, this.savedResourcePos);
        });
        if (!list.isEmpty()) {
            super.method_5431();
        }
        return list;
    }

    public void tryEnterAnthill(class_1297 entity, boolean bl) {
        this.tryEnterAnthill(entity, bl, 0);
    }

    public void tryEnterAnthill(class_1297 entity, boolean bl, int ticksInAnthill) {
        if (this.ants.size() >= 3) {
            return;
        }
        entity.method_5848();
        entity.method_5772();
        class_2487 nbtCompound = new class_2487();
        entity.method_5662(nbtCompound);
        class_2338 blockPos = this.method_11016();
        this.addAnt(nbtCompound, ticksInAnthill, bl, entity.method_37908().method_8409());
        if (this.field_11863 != null) {
            if (entity instanceof com.ninni.spawn.entity.Ant) {
                com.ninni.spawn.entity.Ant ant = (com.ninni.spawn.entity.Ant)entity;
                if (ant.hasSavedResourcePos()) {
                    this.savedResourcePos = ant.getSavedResourcePos();
                }
                this.hasResource = ant.hasResource();
            }
            this.field_11863.method_43128(null, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), SpawnSoundEvents.ANTHILL_ENTER, class_3419.field_15245, 1.0f, 1.0f);
            this.field_11863.method_43276(class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)this.method_11010()));
        }
        entity.method_31472();
        super.method_5431();
    }

    public void addAnt(class_2487 nbtCompound, int ticksInAnthill, boolean bl, class_5819 random) {
        assert (this.field_11863 != null);
        this.ants.add(new Ant(nbtCompound, ticksInAnthill, (bl ? 2400 : 600) + random.method_43048(600)));
    }

    private static boolean releaseAnt(class_1937 world, class_2338 pos, class_2680 state, Ant ant, @Nullable List<class_1297> entities, AntState antState, class_2338 resourcePos) {
        boolean bl;
        if (world.method_23886() && antState != AntState.EMERGENCY) {
            return false;
        }
        class_2487 nbtCompound = ant.entityData.method_10553();
        AnthillBlockEntity.removeIrrelevantNbtKeys(nbtCompound);
        nbtCompound.method_10566("AnthillPos", (class_2520)class_2512.method_10692((class_2338)pos));
        boolean bl2 = bl = !world.method_8320(pos.method_10084()).method_26220((class_1922)world, pos.method_10084()).method_1110();
        if (bl && antState != AntState.EMERGENCY) {
            return false;
        }
        class_1297 newAnt = class_1299.method_17842((class_2487)nbtCompound, (class_1937)world, entity -> entity);
        if (newAnt != null) {
            com.ninni.spawn.entity.Ant releasedAnt;
            if (newAnt instanceof com.ninni.spawn.entity.Ant) {
                releasedAnt = (com.ninni.spawn.entity.Ant)newAnt;
                if (resourcePos != null && !releasedAnt.hasSavedResourcePos()) {
                    releasedAnt.setSavedResourcePos(resourcePos);
                }
                if (antState == AntState.RESOURCE_DELIVERED) {
                    releasedAnt.setHasResource(false);
                    int i = (Integer)state.method_11654((class_2769)AnthillBlock.RESOURCE_LEVEL);
                    if (state.method_26204() instanceof AnthillBlock && i < 3) {
                        world.method_8501(pos, (class_2680)state.method_11657((class_2769)AnthillBlock.RESOURCE_LEVEL, (Comparable)Integer.valueOf(i + 1)));
                    }
                }
                AnthillBlockEntity.ageAnt(Ant.ticksInAnthill, releasedAnt);
                if (entities != null) {
                    entities.add((class_1297)releasedAnt);
                }
            } else {
                return false;
            }
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5;
            releasedAnt.method_5808(x, y, z, releasedAnt.method_36454(), releasedAnt.method_36455());
            world.method_8396(null, pos, SpawnSoundEvents.ANTHILL_EXIT, class_3419.field_15245, 1.0f, 1.0f);
            world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)releasedAnt, (class_2680)world.method_8320(pos)));
            if (world instanceof class_3218) {
                class_3218 serverLevel = (class_3218)world;
                releasedAnt.method_5943((class_5425)serverLevel, serverLevel.method_8404(releasedAnt.method_24515()), class_3730.field_16467, null, nbtCompound);
            }
            return world.method_8649((class_1297)releasedAnt);
        }
        return false;
    }

    static void removeIrrelevantNbtKeys(class_2487 compound) {
        for (String string : IGNORED_ANT_TAGS) {
            compound.method_10551(string);
        }
    }

    private static void ageAnt(int ticks, com.ninni.spawn.entity.Ant ant) {
        int i = ant.method_5618();
        if (i < 0) {
            ant.method_5614(Math.min(0, i + ticks));
        } else if (i > 0) {
            ant.method_5614(Math.max(0, i - ticks));
        }
    }

    private static void tickAnts(class_1937 world, class_2338 pos, class_2680 state, List<Ant> ants, class_2338 resourcePos, boolean hasResource) {
        boolean bl = false;
        Iterator<Ant> iterator = ants.iterator();
        while (iterator.hasNext()) {
            Ant ant = iterator.next();
            if (Ant.ticksInAnthill > ant.minOccupationTicks) {
                AntState antState;
                AntState antState2 = antState = hasResource ? AntState.RESOURCE_DELIVERED : AntState.ANT_RELEASED;
                if (AnthillBlockEntity.releaseAnt(world, pos, state, ant, null, antState, resourcePos)) {
                    bl = true;
                    iterator.remove();
                }
            }
            ++Ant.ticksInAnthill;
        }
        if (bl) {
            AnthillBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, AnthillBlockEntity blockEntity) {
        AnthillBlockEntity.tickAnts(world, pos, state, blockEntity.ants, blockEntity.savedResourcePos, blockEntity.hasResource);
        if (!blockEntity.ants.isEmpty() && world.method_8409().method_43058() < 0.005) {
            double d = (double)pos.method_10263() + 0.5;
            double e = pos.method_10264();
            double f = (double)pos.method_10260() + 0.5;
            world.method_43128(null, d, e, f, SpawnSoundEvents.ANTHILL_WORK, class_3419.field_15245, 0.5f, 1.0f);
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.ants.clear();
        class_2499 nbtList = nbt.method_10554(ANTS_KEY, 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            Ant ant = new Ant(nbtCompound.method_10562(ENTITY_DATA_KEY), nbtCompound.method_10550(TICKS_IN_ANTHILL_KEY), nbtCompound.method_10550(MIN_OCCUPATION_TICKS_KEY));
            this.ants.add(ant);
        }
        this.hasResource = nbt.method_10577("HasResource");
        this.savedResourcePos = null;
        if (nbt.method_10545("ResourcePos")) {
            this.savedResourcePos = class_2512.method_10691((class_2487)nbt.method_10562("ResourcePos"));
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566(ANTS_KEY, (class_2520)this.getAnts());
        nbt.method_10556("HasResource", this.hasResource);
        if (this.savedResourcePos != null) {
            nbt.method_10566("ResourcePos", (class_2520)class_2512.method_10692((class_2338)this.savedResourcePos));
        }
    }

    public class_2499 getAnts() {
        class_2499 nbtList = new class_2499();
        for (Ant ant : this.ants) {
            class_2487 nbtCompound = ant.entityData.method_10553();
            nbtCompound.method_10551("UUID");
            class_2487 nbtCompound2 = new class_2487();
            nbtCompound2.method_10566(ENTITY_DATA_KEY, (class_2520)nbtCompound);
            nbtCompound2.method_10569(IGNORED_ANT_TAGS.toString(), Ant.ticksInAnthill);
            nbtCompound2.method_10569(MIN_OCCUPATION_TICKS_KEY, ant.minOccupationTicks);
            nbtList.add((Object)nbtCompound2);
        }
        return nbtList;
    }

    public static enum AntState {
        RESOURCE_DELIVERED,
        ANT_RELEASED,
        EMERGENCY;

    }

    static class Ant {
        final class_2487 entityData;
        static int ticksInAnthill;
        final int minOccupationTicks;

        Ant(class_2487 entityData, int ticksInDwelling, int minOccupationTicks) {
            AnthillBlockEntity.removeIrrelevantNbtKeys(entityData);
            this.entityData = entityData;
            ticksInAnthill = ticksInDwelling;
            this.minOccupationTicks = minOccupationTicks;
        }
    }
}

