/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.block;

import com.google.common.collect.Lists;
import com.ninni.spawn.SpawnProperties;
import com.ninni.spawn.block.entity.AnthillBlockEntity;
import com.ninni.spawn.entity.Ant;
import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1687;
import net.minecraft.class_1701;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2465;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_8174;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class AnthillBlock
extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2758 RESOURCE_LEVEL = SpawnProperties.RESOURCE_LEVEL;

    public AnthillBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)RESOURCE_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public void method_9556(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState, @Nullable class_2586 blockEntity, class_1799 itemStack) {
        super.method_9556(level, player, blockPos, blockState, blockEntity, itemStack);
        if (!level.field_9236 && blockEntity instanceof AnthillBlockEntity) {
            AnthillBlockEntity anthillBlockEntity = (AnthillBlockEntity)blockEntity;
            if (class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)itemStack) == 0) {
                anthillBlockEntity.angerAnts(player, blockState, AnthillBlockEntity.AntState.EMERGENCY);
                level.method_8455(blockPos, (class_2248)this);
                this.angerNearbyAnts(level, blockPos);
            }
        }
    }

    private void angerNearbyAnts(class_1937 world, class_2338 pos) {
        List antList = world.method_18467(Ant.class, new class_238(pos).method_1009(8.0, 6.0, 8.0));
        if (!antList.isEmpty()) {
            List playerList = world.method_18467(class_1657.class, new class_238(pos).method_1009(8.0, 6.0, 8.0));
            for (Ant ant : antList) {
                if (ant.method_5968() != null || ant.method_6181()) continue;
                ant.method_5980((class_1309)playerList.get(world.field_9229.method_43048(playerList.size())));
            }
        }
    }

    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new AnthillBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return level.field_9236 ? null : AnthillBlock.method_31618(blockEntityType, SpawnBlockEntityTypes.ANTHILL, AnthillBlockEntity::serverTick);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 blockState, class_1657 player) {
        class_2586 blockEntity;
        if (!world.method_8608() && player.method_7337() && world.method_8450().method_8355(class_1928.field_19392) && (blockEntity = world.method_8321(pos)) instanceof AnthillBlockEntity) {
            boolean bl;
            AnthillBlockEntity blockEntity1 = (AnthillBlockEntity)blockEntity;
            class_1799 itemStack = new class_1799((class_1935)this);
            boolean bl2 = bl = !blockEntity1.hasNoAnts();
            if (bl) {
                class_2487 nbtCompound = new class_2487();
                nbtCompound.method_10566("Ants", (class_2520)blockEntity1.getAnts());
                class_1747.method_38073((class_1799)itemStack, SpawnBlockEntityTypes.ANTHILL, (class_2487)nbtCompound);
                nbtCompound = new class_2487();
                itemStack.method_7959("BlockStateTag", (class_2520)nbtCompound);
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), itemStack);
                itemEntity.method_6988();
                world.method_8649((class_1297)itemEntity);
            }
        }
        super.method_9576(world, pos, blockState, player);
    }

    public boolean method_9542(class_2680 blockState) {
        return (Integer)blockState.method_11654((class_2769)RESOURCE_LEVEL) == 3;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 randomSource) {
        int range = 1;
        ArrayList list = Lists.newArrayList();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                class_2338 blockPos = new class_2338(pos.method_10263() + x, pos.method_10264() - range, pos.method_10260() + z);
                class_2680 belowState = world.method_8320(blockPos);
                if (!belowState.method_26164(class_3481.field_39030) && (!belowState.method_26164(class_3481.field_29822) || belowState.method_27852(SpawnBlocks.ANT_MOUND))) continue;
                list.add(blockPos);
            }
        }
        if (!list.isEmpty()) {
            class_2338 blockPos = (class_2338)list.get(randomSource.method_43048(list.size()));
            class_2680 placeState = null;
            if (world.method_8320(blockPos).method_26164(class_3481.field_39030)) {
                placeState = (class_2680)SpawnBlocks.ROTTEN_LOG.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)world.method_8320(blockPos).method_11654((class_2769)class_2465.field_11459)));
            } else if (world.method_8320(blockPos).method_26164(class_3481.field_29822) && !world.method_8320(blockPos).method_27852(SpawnBlocks.ANT_MOUND)) {
                placeState = SpawnBlocks.ANT_MOUND.method_9564();
            }
            world.method_8652(blockPos, placeState, 2);
            class_2586 class_25862 = world.method_8321(blockPos);
            if (class_25862 instanceof class_8174) {
                class_8174 brushableBlockEntity = (class_8174)class_25862;
                brushableBlockEntity.method_49216(new class_2960("spawn", "archaeology/anthill"), blockPos.method_10063());
            }
            world.method_45447(null, pos, SpawnSoundEvents.ANTHILL_RESOURCE, class_3419.field_15245);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)RESOURCE_LEVEL, (Comparable)Integer.valueOf(0)), 2);
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2586 blockEntity;
        class_1297 entity = (class_1297)builder.method_51876(class_181.field_1226);
        if ((entity instanceof class_1541 || entity instanceof class_1548 || entity instanceof class_1687 || entity instanceof class_1528 || entity instanceof class_1701) && (blockEntity = (class_2586)builder.method_51876(class_181.field_1228)) instanceof AnthillBlockEntity) {
            AnthillBlockEntity blockEntity1 = (AnthillBlockEntity)blockEntity;
            blockEntity1.angerAnts(null, state, AnthillBlockEntity.AntState.EMERGENCY);
        }
        return super.method_9560(state, builder);
    }

    public class_2680 method_9605(class_1750 blockPlaceContext) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)blockPlaceContext.method_8042().method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, RESOURCE_LEVEL});
    }
}

